/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Objects;
import net.morimekta.providence.PException;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PExceptionDescriptor;
import net.morimekta.providence.descriptor.PExceptionDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JAnnotation;
import net.morimekta.providence.generator.format.java.JField;
import net.morimekta.providence.generator.format.java.JHeader;
import net.morimekta.providence.generator.format.java.JHelper;
import net.morimekta.providence.generator.format.java.JMessage;
import net.morimekta.providence.generator.format.java.JMessageAndroidFormat;
import net.morimekta.providence.generator.format.java.JMessageBuilderFormat;
import net.morimekta.providence.generator.format.java.JMessageOverridesFormat;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.providence.generator.format.java.JUtils;
import net.morimekta.providence.generator.format.java.JValueFormat;
import net.morimekta.providence.util.PTypeUtils;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class JMessageFormat {
    public static final String DBL_INDENT = "        ";
    private final JHelper helper;
    private final JOptions options;

    public JMessageFormat(JHelper helper, JOptions options) {
        this.helper = helper;
        this.options = options;
    }

    public void format(IndentedPrintWriter writer, PStructDescriptor<?, ?> descriptor) throws GeneratorException, IOException {
        JMessage message = new JMessage(descriptor, this.helper);
        JMessageAndroidFormat android = new JMessageAndroidFormat(writer, this.helper);
        JMessageOverridesFormat overrides = new JMessageOverridesFormat(writer, this.options, this.helper);
        JMessageBuilderFormat builder = new JMessageBuilderFormat(writer, this.helper);
        JValueFormat values = new JValueFormat(writer, this.options, this.helper);
        this.appendFileHeader(writer, message, values);
        if (descriptor.getComment() != null) {
            JUtils.appendBlockComment(writer, descriptor.getComment());
            if (JAnnotation.isDeprecated(descriptor)) {
                writer.appendln((CharSequence)"@Deprecated");
            }
        }
        if (this.options.jackson) {
            writer.appendln((CharSequence)"@JsonIgnoreProperties(ignoreUnknown = true)").appendln((CharSequence)"@JsonInclude(JsonInclude.Include.NON_EMPTY)");
        }
        writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")").formatln("public class %s", new Object[]{message.instanceType()}).begin(DBL_INDENT);
        if (message.variant().equals((Object)PMessageVariant.EXCEPTION)) {
            writer.appendln((CharSequence)"extends PException");
        }
        writer.formatln("implements %s<%s>, Serializable, Comparable<%s>", new Object[]{message.isUnion() ? "PUnion" : "PMessage", message.instanceType(), message.instanceType()});
        if (this.options.android) {
            writer.format(", Parcelable", new Object[0]);
        }
        writer.append((CharSequence)" {").end().begin();
        writer.formatln("private final static long serialVersionUID = %dL;", new Object[]{JUtils.generateSerialVersionUID(message.descriptor())}).newline();
        values.appendDefaultConstants(message.fields());
        this.appendFieldDeclarations(writer, message);
        this.appendBuilderConstructor(writer, message);
        this.appendCreateConstructor(writer, message);
        this.appendFieldGetters(writer, message);
        overrides.appendOverrides(message);
        this.appendFieldEnum(writer, message);
        this.appendDescriptor(writer, message);
        if (this.options.android) {
            android.appendParcelable(message);
        }
        builder.appendBuilder(message);
        writer.end().appendln('}').newline();
    }

    private void appendFieldEnum(IndentedPrintWriter writer, JMessage message) {
        writer.appendln((CharSequence)"public enum _Field implements PField {").begin();
        for (JField field : message.fields()) {
            String provider = this.helper.getProviderName(field.getPField().getDescriptor());
            String defValue = "null";
            if (field.getPField().hasDefaultValue()) {
                defValue = String.format("new PDefaultValueProvider<>(%s)", field.kDefault());
            }
            writer.formatln("%s(%d, PRequirement.%s, \"%s\", %s, %s),", new Object[]{field.fieldEnum(), field.id(), field.getPField().getRequirement().name(), field.name(), provider, defValue});
        }
        writer.appendln(';').newline();
        writer.appendln((CharSequence)"private final int mKey;").appendln((CharSequence)"private final PRequirement mRequired;").appendln((CharSequence)"private final String mName;").appendln((CharSequence)"private final PDescriptorProvider<?> mTypeProvider;").appendln((CharSequence)"private final PValueProvider<?> mDefaultValue;").newline().appendln((CharSequence)"_Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {").begin().appendln((CharSequence)"mKey = key;").appendln((CharSequence)"mRequired = required;").appendln((CharSequence)"mName = name;").appendln((CharSequence)"mTypeProvider = typeProvider;").appendln((CharSequence)"mDefaultValue = defaultValue;").end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String getComment() { return null; }").newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int getKey() { return mKey; }").newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public PRequirement getRequirement() { return mRequired; }").newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public PType getType() { return getDescriptor().getType(); }").newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public PDescriptor<?> getDescriptor() { return mTypeProvider.descriptor(); }").newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String getName() { return mName; }").newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean hasDefaultValue() { return mDefaultValue != null; }").newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public Object getDefaultValue() {").appendln((CharSequence)"    return hasDefaultValue() ? mDefaultValue.get() : null;").appendln('}').newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String toString() {").begin().appendln((CharSequence)"StringBuilder builder = new StringBuilder();").formatln("builder.append(\"%s._Field(\")", new Object[]{message.instanceType()}).appendln((CharSequence)"       .append(mKey)").appendln((CharSequence)"       .append(\": \");").appendln((CharSequence)"if (mRequired != PRequirement.DEFAULT) {").appendln((CharSequence)"    builder.append(mRequired.label).append(\" \");").appendln((CharSequence)"}").appendln((CharSequence)"builder.append(getDescriptor().getQualifiedName(null))").appendln((CharSequence)"       .append(' ')").appendln((CharSequence)"       .append(mName)").appendln((CharSequence)"       .append(')');").appendln((CharSequence)"return builder.toString();").end().appendln('}').newline();
        writer.appendln((CharSequence)"public static _Field forKey(int key) {").begin().appendln((CharSequence)"switch (key) {").begin();
        for (JField field : message.fields()) {
            writer.formatln("case %d: return _Field.%s;", new Object[]{field.id(), field.fieldEnum()});
        }
        writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
        writer.appendln((CharSequence)"public static _Field forName(String name) {").begin().appendln((CharSequence)"switch (name) {").begin();
        for (JField field : message.fields()) {
            writer.formatln("case \"%s\": return _Field.%s;", new Object[]{field.name(), field.fieldEnum()});
        }
        writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}');
        writer.end().appendln('}').newline();
    }

    private void appendDescriptor(IndentedPrintWriter writer, JMessage message) throws GeneratorException {
        String typeClass;
        switch (message.variant()) {
            case STRUCT: {
                typeClass = PStructDescriptor.class.getSimpleName();
                break;
            }
            case UNION: {
                typeClass = PUnionDescriptor.class.getSimpleName();
                break;
            }
            case EXCEPTION: {
                typeClass = PExceptionDescriptor.class.getSimpleName();
                break;
            }
            default: {
                throw new GeneratorException("Unable to determine type class for " + message.variant());
            }
        }
        writer.formatln("public static %sProvider<%s,_Field> provider() {", new Object[]{typeClass, message.instanceType()}).begin().formatln("return new _Provider();", new Object[0]).end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").formatln("public %s<%s,_Field> descriptor() {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"return kDescriptor;").end().appendln('}').newline();
        writer.formatln("public static final %s<%s,_Field> kDescriptor;", new Object[]{typeClass, message.instanceType()}).newline();
        writer.formatln("private static class _Descriptor", new Object[0]).formatln("        extends %s<%s,_Field> {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"public _Descriptor() {").begin();
        if (message.isException() || message.isUnion()) {
            writer.formatln("super(null, \"%s\", \"%s\", new _Factory(), %s);", new Object[]{message.descriptor().getPackageName(), message.descriptor().getName(), message.descriptor().isSimple()});
        } else {
            writer.formatln("super(null, \"%s\", \"%s\", new _Factory(), %b, %b);", new Object[]{message.descriptor().getPackageName(), message.descriptor().getName(), message.descriptor().isSimple(), message.descriptor().isCompactible()});
        }
        writer.end().appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"public _Field[] getFields() {").begin().appendln((CharSequence)"return _Field.values();").end().appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"public _Field getField(String name) {").begin().appendln((CharSequence)"return _Field.forName(name);").end().appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"public _Field getField(int key) {").begin().appendln((CharSequence)"return _Field.forKey(key);").end().appendln('}').end().appendln('}').newline();
        writer.formatln("static {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"kDescriptor = new _Descriptor();").end().appendln('}').newline();
        writer.formatln("private final static class _Provider extends %sProvider<%s,_Field> {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"@Override").formatln("public %s<%s,_Field> descriptor() {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"return kDescriptor;").end().appendln('}').end().appendln((CharSequence)"}").newline();
        writer.appendln((CharSequence)"private final static class _Factory").begin().formatln("    extends PMessageBuilderFactory<%s> {", new Object[]{message.instanceType()}).appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder builder() {").begin().appendln((CharSequence)"return new _Builder();").end().appendln('}').end().appendln('}').newline();
    }

    private void appendFieldGetters(IndentedPrintWriter writer, JMessage message) throws GeneratorException {
        for (JField field : message.fields()) {
            if (message.isUnion()) {
                if (field.container()) {
                    writer.formatln("public int %s() {", new Object[]{field.counter()}).formatln("    return tUnionField == _Field.%s ? %s.size() : 0;", new Object[]{field.fieldEnum(), field.member()}).appendln('}').newline();
                } else if (field.alwaysPresent()) {
                    writer.formatln("public boolean %s() {", new Object[]{field.presence()}).formatln("    return tUnionField == _Field.%s;", new Object[]{field.fieldEnum()}).appendln('}').newline();
                } else {
                    writer.formatln("public boolean %s() {", new Object[]{field.presence()}).formatln("    return tUnionField == _Field.%s && %s != null;", new Object[]{field.fieldEnum(), field.member()}).appendln('}').newline();
                }
            } else if (field.container()) {
                writer.formatln("public int %s() {", new Object[]{field.counter()}).formatln("    return %s != null ? %s.size() : 0;", new Object[]{field.member(), field.member()}).appendln('}').newline();
            } else if (field.alwaysPresent()) {
                writer.formatln("public boolean %s() {", new Object[]{field.presence()}).begin().formatln("return true;", new Object[0]).end().appendln('}').newline();
            } else {
                writer.formatln("public boolean %s() {", new Object[]{field.presence()}).begin().formatln("return %s != null;", new Object[]{field.member()}).end().appendln('}').newline();
            }
            if (field.hasComment()) {
                JUtils.appendBlockComment(writer, field.comment());
                if (JAnnotation.isDeprecated(field)) {
                    writer.appendln((CharSequence)"@Deprecated");
                }
            }
            if (this.options.jackson) {
                writer.formatln("@JsonProperty(\"%s\")", new Object[]{field.name()});
                if (field.binary()) {
                    writer.appendln((CharSequence)"@JsonSerialize(using = BinaryJsonSerializer.class) ");
                }
            }
            writer.formatln("public %s %s() {", new Object[]{field.valueType(), field.getter()});
            if (!field.container() && !field.alwaysPresent() && field.getPField().hasDefaultValue()) {
                writer.formatln("    return %s() ? %s : %s;", new Object[]{field.presence(), field.member(), field.kDefault()});
            } else {
                writer.formatln("    return %s;", new Object[]{field.member()});
            }
            writer.appendln('}').newline();
        }
        if (message.isUnion()) {
            writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Field unionField() {").begin().appendln((CharSequence)"return tUnionField;").end().appendln('}').newline();
        }
    }

    private void appendFieldDeclarations(IndentedPrintWriter writer, JMessage message) {
        for (JField field : message.fields()) {
            writer.formatln("private final %s %s;", new Object[]{field.fieldType(), field.member()});
        }
        if (message.isUnion()) {
            writer.newline().appendln((CharSequence)"private final _Field tUnionField;");
        }
        writer.appendln().appendln((CharSequence)"private volatile int tHashCode;").newline();
    }

    private void appendBuilderConstructor(IndentedPrintWriter writer, JMessage message) {
        writer.formatln("private %s(_Builder builder) {", new Object[]{message.instanceType()}).begin();
        if (message.isUnion()) {
            writer.appendln((CharSequence)"tUnionField = builder.tUnionField;").newline();
            block10: for (JField field : message.fields()) {
                switch (field.type()) {
                    case LIST: {
                        writer.formatln("%s = tUnionField == _Field.%s ? Collections.unmodifiableList(new %s<>(builder.%s)) : null;", new Object[]{field.member(), field.fieldEnum(), field.instanceType(), field.member()});
                        continue block10;
                    }
                    case SET: {
                        writer.formatln("%s = tUnionField == _Field.%s ? Collections.unmodifiableSet(new %s<>(builder.%s)) : null;", new Object[]{field.member(), field.fieldEnum(), field.instanceType(), field.member()});
                        continue block10;
                    }
                    case MAP: {
                        writer.formatln("%s = tUnionField == _Field.%s ? Collections.unmodifiableMap(new %s<>(builder.%s)) : null;", new Object[]{field.member(), field.fieldEnum(), field.instanceType(), field.member()});
                        continue block10;
                    }
                }
                if (field.alwaysPresent()) {
                    writer.formatln("%s = tUnionField == _Field.%s ? builder.%s : %s;", new Object[]{field.member(), field.fieldEnum(), field.member(), field.kDefault()});
                    continue;
                }
                writer.formatln("%s = tUnionField == _Field.%s ? builder.%s : null;", new Object[]{field.member(), field.fieldEnum(), field.member()});
            }
        } else {
            if (message.isException()) {
                writer.appendln((CharSequence)"super(builder.createMessage());").newline();
            }
            block11: for (JField field : message.fields()) {
                switch (field.type()) {
                    case LIST: {
                        writer.formatln("%s = Collections.unmodifiableList(new %s<>(builder.%s));", new Object[]{field.member(), field.instanceType(), field.member()});
                        continue block11;
                    }
                    case SET: {
                        writer.formatln("%s = Collections.unmodifiableSet(new %s<>(builder.%s));", new Object[]{field.member(), field.instanceType(), field.member()});
                        continue block11;
                    }
                    case MAP: {
                        writer.formatln("%s = Collections.unmodifiableMap(new %s<>(builder.%s));", new Object[]{field.member(), field.instanceType(), field.member()});
                        continue block11;
                    }
                }
                writer.formatln("%s = builder.%s;", new Object[]{field.member(), field.member()});
            }
        }
        writer.end().appendln('}').newline();
    }

    private void appendCreateConstructor(IndentedPrintWriter writer, JMessage message) {
        if (!message.isException()) {
            if (message.isUnion()) {
                for (JField field : message.fields()) {
                    writer.formatln("public static %s %s(%s value) {", new Object[]{message.instanceType(), Strings.camelCase((String)"with", (String)field.name()), field.valueType()}).begin().formatln("return new _Builder().%s(value).build();", new Object[]{field.setter()}).end().appendln((CharSequence)"}").newline();
                }
            } else {
                if (this.options.jackson) {
                    writer.appendln((CharSequence)"@JsonCreator");
                }
                String spaces = message.instanceType().replaceAll("[\\S]", " ");
                writer.formatln("public %s(", new Object[]{message.instanceType()}).begin(DBL_INDENT + spaces);
                boolean first = true;
                for (JField field : message.fields()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append(',').appendln();
                    }
                    if (this.options.jackson) {
                        writer.format("@JsonProperty(\"%s\") ", new Object[]{field.name()});
                        if (field.binary()) {
                            writer.append((CharSequence)"@JsonDeserialize(using = BinaryJsonDeserializer.class) ");
                        }
                    }
                    writer.format("%s %s", new Object[]{field.valueType(), field.param()});
                }
                writer.end().append((CharSequence)") {").begin();
                block7: for (JField field : message.fields()) {
                    switch (field.type()) {
                        case LIST: {
                            writer.formatln("%s = Collections.unmodifiableList(new %s<>(%s));", new Object[]{field.member(), field.instanceType(), field.param()});
                            continue block7;
                        }
                        case SET: {
                            writer.formatln("%s = Collections.unmodifiableSet(new %s<>(%s));", new Object[]{field.member(), field.instanceType(), field.param()});
                            continue block7;
                        }
                        case MAP: {
                            writer.formatln("%s = Collections.unmodifiableMap(new %s<>(%s));", new Object[]{field.member(), field.instanceType(), field.param()});
                            continue block7;
                        }
                    }
                    writer.formatln("%s = %s;", new Object[]{field.member(), field.param()});
                }
                writer.end().appendln('}').newline();
            }
        }
    }

    private void appendFileHeader(IndentedPrintWriter writer, JMessage message, JValueFormat values) throws GeneratorException, IOException {
        JHeader header = new JHeader(this.helper.getJavaPackage((PDeclaredDescriptor<?>)message.descriptor()));
        header.include(Serializable.class.getName());
        header.include(PMessageBuilder.class.getName());
        header.include(PMessageBuilderFactory.class.getName());
        header.include(PField.class.getName());
        header.include(PType.class.getName());
        header.include(PRequirement.class.getName());
        header.include(PDescriptorProvider.class.getName());
        header.include(PValueProvider.class.getName());
        header.include(PDescriptor.class.getName());
        header.include(Objects.class.getName());
        header.include(Comparable.class.getName());
        if (!message.isUnion()) {
            header.include(BitSet.class.getName());
        }
        switch (message.variant()) {
            case STRUCT: {
                header.include(PMessage.class.getName());
                header.include(PStructDescriptor.class.getName());
                header.include(PStructDescriptorProvider.class.getName());
                break;
            }
            case UNION: {
                header.include(PUnion.class.getName());
                header.include(PUnionDescriptor.class.getName());
                header.include(PUnionDescriptorProvider.class.getName());
                break;
            }
            case EXCEPTION: {
                header.include(PMessage.class.getName());
                header.include(PException.class.getName());
                header.include(PExceptionDescriptor.class.getName());
                header.include(PExceptionDescriptorProvider.class.getName());
            }
        }
        for (JField field : message.fields()) {
            values.addTypeImports(header, field.getPField().getDescriptor());
            if (field.getPField().hasDefaultValue()) {
                header.include(PDefaultValueProvider.class.getName());
            }
            if (field.container() || field.type() == PType.DOUBLE) {
                header.include(PTypeUtils.class.getName());
            }
            if (!this.options.jackson || !field.binary()) continue;
            header.include("com.fasterxml.jackson.databind.annotation.JsonDeserialize");
            header.include("com.fasterxml.jackson.databind.annotation.JsonSerialize");
            header.include("net.morimekta.providence.jackson.BinaryJsonDeserializer");
            header.include("net.morimekta.providence.jackson.BinaryJsonSerializer");
        }
        if (this.options.android) {
            header.include("android.os.Parcel");
            header.include("android.os.Parcelable");
        }
        if (this.options.jackson) {
            header.include("com.fasterxml.jackson.annotation.JsonIgnore");
            header.include("com.fasterxml.jackson.annotation.JsonIgnoreProperties");
            header.include("com.fasterxml.jackson.annotation.JsonCreator");
            header.include("com.fasterxml.jackson.annotation.JsonProperty");
            header.include("com.fasterxml.jackson.annotation.JsonInclude");
        }
        header.format(writer);
    }
}

