/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.generator.format.java.JAnnotation;
import net.morimekta.providence.generator.format.java.JField;
import net.morimekta.providence.generator.format.java.JHelper;
import net.morimekta.providence.generator.format.java.JMessage;
import net.morimekta.providence.generator.format.java.JUtils;
import net.morimekta.util.io.IndentedPrintWriter;

public class JMessageBuilderFormat {
    IndentedPrintWriter writer;
    JHelper helper;

    public JMessageBuilderFormat(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    public void appendBuilder(JMessage message) {
        this.appendMutators();
        this.writer.appendln((CharSequence)"public static class _Builder").begin().formatln("    extends PMessageBuilder<%s> {", new Object[]{message.instanceType()});
        this.appendFields(message);
        this.appendDefaultConstructor(message);
        this.appendMutateConstructor(message);
        for (JField field : message.fields()) {
            this.appendSetter(message, field);
            if (field.container()) {
                this.appendAdder(message, field);
            }
            this.appendResetter(message, field);
        }
        this.appendOverrideSetter(message);
        this.appendOverrideAdder(message);
        this.appendOverrideResetter(message);
        this.appendOverrideIsValid(message);
        if (message.isException()) {
            this.appendCreateMessage(message);
        }
        this.writer.appendln((CharSequence)"@Override").formatln("public %s build() {", new Object[]{message.instanceType()}).begin().formatln("return new %s(this);", new Object[]{message.instanceType()}).end().appendln('}');
        this.writer.end().appendln('}');
    }

    private void appendMutators() {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder mutate() {").begin().appendln((CharSequence)"return new _Builder(this);").end().appendln('}').newline();
        this.writer.formatln("public static _Builder builder() {", new Object[0]).begin().appendln((CharSequence)"return new _Builder();").end().appendln('}').newline();
    }

    private void appendFields(JMessage message) {
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"private _Field tUnionField;");
        } else {
            this.writer.appendln((CharSequence)"private BitSet optionals;");
        }
        this.writer.newline();
        for (JField field : message.fields()) {
            this.writer.formatln("private %s %s;", new Object[]{field.fieldType(), field.member()});
        }
        if (message.fields().size() > 0) {
            this.writer.newline();
        }
    }

    private void appendDefaultConstructor(JMessage message) {
        this.writer.newline().appendln((CharSequence)"public _Builder() {").begin();
        if (!message.isUnion()) {
            this.writer.formatln("optionals = new BitSet(%d);", new Object[]{message.fields().size()});
        }
        for (JField field : message.fields()) {
            if (field.container()) {
                this.writer.formatln("%s = new %s<>();", new Object[]{field.member(), field.instanceType()});
                continue;
            }
            if (!field.alwaysPresent()) continue;
            this.writer.formatln("%s = %s;", new Object[]{field.member(), field.kDefault()});
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendMutateConstructor(JMessage message) {
        this.writer.formatln("public _Builder(%s base) {", new Object[]{message.instanceType()}).begin().appendln((CharSequence)"this();").newline();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"tUnionField = base.tUnionField;").newline();
        }
        for (JField field : message.fields()) {
            boolean checkPresence;
            boolean bl = message.isUnion() ? field.container() : (checkPresence = !field.alwaysPresent());
            if (checkPresence) {
                if (field.container()) {
                    this.writer.formatln("if (base.%s() > 0) {", new Object[]{field.counter()}).begin();
                } else {
                    this.writer.formatln("if (base.%s()) {", new Object[]{field.presence()}).begin();
                }
            }
            if (!message.isUnion()) {
                this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
            }
            switch (field.type()) {
                case LIST: 
                case SET: {
                    this.writer.formatln("%s.addAll(base.%s);", new Object[]{field.member(), field.member()});
                    break;
                }
                case MAP: {
                    this.writer.formatln("%s.putAll(base.%s);", new Object[]{field.member(), field.member()});
                    break;
                }
                default: {
                    this.writer.formatln("%s = base.%s;", new Object[]{field.member(), field.member()});
                }
            }
            if (!checkPresence) continue;
            this.writer.end().appendln('}');
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendSetter(JMessage message, JField field) {
        if (field.hasComment()) {
            JUtils.appendBlockComment(this.writer, field.comment());
            if (JAnnotation.isDeprecated(field)) {
                this.writer.appendln((CharSequence)"@Deprecated");
            }
        }
        if (field.type() == PType.SET || field.type() == PType.LIST) {
            PContainer cType = (PContainer)field.getPField().getDescriptor();
            String iType = this.helper.getFieldType(cType.itemDescriptor());
            this.writer.formatln("public _Builder %s(Collection<%s> value) {", new Object[]{field.setter(), iType});
        } else {
            this.writer.formatln("public _Builder %s(%s value) {", new Object[]{field.setter(), field.valueType()});
        }
        this.writer.begin();
        if (message.isUnion()) {
            this.writer.formatln("tUnionField = _Field.%s;", new Object[]{field.fieldEnum()});
        } else {
            this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
        }
        switch (field.type()) {
            case LIST: 
            case SET: {
                this.writer.formatln("%s.clear();", new Object[]{field.member()}).formatln("%s.addAll(value);", new Object[]{field.member()});
                break;
            }
            case MAP: {
                this.writer.formatln("%s.clear();", new Object[]{field.member()}).formatln("%s.putAll(value);", new Object[]{field.member()});
                break;
            }
            default: {
                this.writer.formatln("%s = value;", new Object[]{field.member()});
            }
        }
        this.writer.appendln((CharSequence)"return this;").end().appendln('}');
    }

    private void appendAdder(JMessage message, JField field) {
        if (field.hasComment()) {
            JUtils.appendBlockComment(this.writer, field.comment());
            if (JAnnotation.isDeprecated(field)) {
                this.writer.appendln((CharSequence)"@Deprecated");
            }
        }
        switch (field.type()) {
            case MAP: {
                PMap mType = (PMap)field.getPField().getDescriptor();
                String mkType = this.helper.getValueType(mType.keyDescriptor());
                String miType = this.helper.getValueType(mType.itemDescriptor());
                this.writer.formatln("public _Builder %s(%s key, %s value) {", new Object[]{field.adder(), mkType, miType}).begin();
                if (message.isUnion()) {
                    this.writer.formatln("tUnionField = _Field.%s;", new Object[]{field.fieldEnum()});
                } else {
                    this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                }
                this.writer.formatln("%s.put(key, value);", new Object[]{field.member()}).appendln((CharSequence)"return this;").end().appendln('}').newline();
                break;
            }
            case LIST: 
            case SET: {
                PContainer lType = (PContainer)field.getPField().getDescriptor();
                String liType = this.helper.getValueType(lType.itemDescriptor());
                this.writer.formatln("public _Builder %s(%s... values) {", new Object[]{field.adder(), liType}).begin();
                if (message.isUnion()) {
                    this.writer.formatln("tUnionField = _Field.%s;", new Object[]{field.fieldEnum()});
                } else {
                    this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                }
                this.writer.formatln("for (%s item : values) {", new Object[]{liType}).begin().formatln("%s.add(item);", new Object[]{field.member()}).end().appendln('}').appendln((CharSequence)"return this;").end().appendln('}').newline();
                break;
            }
        }
    }

    private void appendResetter(JMessage message, JField field) {
        this.writer.formatln("public _Builder %s() {", new Object[]{field.resetter()}).begin();
        if (message.isUnion()) {
            this.writer.formatln("if (tUnionField == _Field.%s) tUnionField = null;", new Object[]{field.fieldEnum()});
        } else {
            this.writer.formatln("optionals.set(%d, false);", new Object[]{field.index()});
        }
        if (field.container()) {
            this.writer.formatln("%s.clear();", new Object[]{field.member()});
        } else if (field.alwaysPresent()) {
            this.writer.formatln("%s = %s;", new Object[]{field.member(), field.kDefault()});
        } else {
            this.writer.formatln("%s = null;", new Object[]{field.member()});
        }
        this.writer.appendln((CharSequence)"return this;").end().appendln('}');
    }

    private void appendOverrideSetter(JMessage message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder set(int key, Object value) {").begin().appendln((CharSequence)"if (value == null) return clear(key);").appendln((CharSequence)"switch (key) {").begin();
        for (JField field : message.fields()) {
            this.writer.formatln("case %d: %s((%s) value); break;", new Object[]{field.id(), field.setter(), field.valueType()});
        }
        this.writer.end().appendln('}').appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendOverrideAdder(JMessage message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder addTo(int key, Object value) {").begin().appendln((CharSequence)"switch (key) {").begin();
        for (JField field : message.fields()) {
            if (field.type() != PType.LIST && field.type() != PType.SET) continue;
            PContainer ct = (PContainer)field.getPField().getDescriptor();
            PDescriptor itype = ct.itemDescriptor();
            this.writer.formatln("case %d: %s((%s) value); break;", new Object[]{field.id(), field.adder(), this.helper.getValueType(itype)});
        }
        this.writer.appendln((CharSequence)"default: break;").end().appendln('}').appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendOverrideResetter(JMessage message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder clear(int key) {").begin().appendln((CharSequence)"switch (key) {").begin();
        for (JField field : message.fields()) {
            this.writer.formatln("case %d: %s(); break;", new Object[]{field.id(), field.resetter()});
        }
        this.writer.end().appendln('}').appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendOverrideIsValid(JMessage message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean isValid() {").begin();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"return tUnionField != null;");
        } else {
            this.writer.appendln((CharSequence)"return ").begin("       ");
            boolean first = true;
            for (JField field : message.fields()) {
                if (!field.isRequired()) continue;
                if (first) {
                    first = false;
                } else {
                    this.writer.append((CharSequence)" &&").appendln((CharSequence)"");
                }
                this.writer.format("optionals.get(%d)", new Object[]{field.index()});
            }
            if (first) {
                this.writer.append((CharSequence)"true");
            }
            this.writer.end().append(';');
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendCreateMessage(JMessage message) {
        this.writer.appendln((CharSequence)"protected String createMessage() {").begin().appendln((CharSequence)"StringBuilder builder = new StringBuilder();").appendln((CharSequence)"builder.append('{');").appendln((CharSequence)"boolean first = true;");
        boolean alwaysAfter = false;
        for (JField field : message.fields()) {
            if (!field.alwaysPresent()) {
                if (field.container()) {
                    this.writer.formatln("if (%s.size() > 0) {", new Object[]{field.member()});
                } else {
                    this.writer.formatln("if (%s != null) {", new Object[]{field.member()});
                }
                this.writer.begin();
            }
            if (alwaysAfter) {
                this.writer.appendln((CharSequence)"builder.append(',');");
            } else {
                this.writer.appendln((CharSequence)"if (first) first = false;").appendln((CharSequence)"else builder.append(',');");
            }
            this.writer.formatln("builder.append(\"%s:\")", new Object[]{field.name()});
            switch (field.type()) {
                case BOOL: 
                case I32: 
                case I64: {
                    this.writer.formatln("       .append(%s);", new Object[]{field.member()});
                    break;
                }
                case BYTE: 
                case I16: {
                    this.writer.formatln("       .append((int) %s);", new Object[]{field.member()});
                    break;
                }
                case LIST: 
                case SET: 
                case MAP: 
                case DOUBLE: {
                    this.writer.formatln("       .append(PTypeUtils.toString(%s));", new Object[]{field.member()});
                    break;
                }
                case STRING: {
                    this.writer.formatln("       .append(%s.toString());", new Object[]{field.member()});
                    break;
                }
                case BINARY: {
                    this.writer.appendln((CharSequence)"       .append(\"b64(\")").formatln("       .append(%s.toBase64())", new Object[]{field.member()}).appendln((CharSequence)"       .append(')');");
                    break;
                }
                case MESSAGE: {
                    this.writer.formatln("       .append(%s.asString());", new Object[]{field.member()});
                    break;
                }
                default: {
                    this.writer.formatln("       .append(%s.toString());", new Object[]{field.member()});
                }
            }
            if (!field.alwaysPresent()) {
                this.writer.end().appendln('}');
                continue;
            }
            alwaysAfter = true;
        }
        this.writer.appendln((CharSequence)"builder.append('}');").appendln((CharSequence)"return builder.toString();").end().appendln('}').newline();
    }
}

