/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JField;
import net.morimekta.providence.generator.format.java.JHelper;
import net.morimekta.providence.generator.format.java.JMessage;
import net.morimekta.util.io.IndentedPrintWriter;

public class JMessageAndroidFormat {
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public JMessageAndroidFormat(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    private void appendParcelableArrayConverter(String srcType, String srcName, String destType, String itemConvert) {
        this.writer.formatln("%s[] arr = new %s[%s.size()];", new Object[]{destType, destType, srcName}).appendln((CharSequence)"int pos = 0;").formatln("for (%s item : %s) {", new Object[]{srcType, srcName}).begin().formatln("arr[pos++] = %s;", new Object[]{itemConvert}).end().appendln('}');
    }

    private void appendParcelableWriter(String fName, PDescriptor<?> desc) throws GeneratorException {
        block0 : switch (desc.getType()) {
            case BOOL: {
                this.writer.formatln("dest.writeByte(%s ? (byte) 1 : (byte) 0);", new Object[]{fName});
                break;
            }
            case BYTE: {
                this.writer.formatln("dest.writeByte(%s);", new Object[]{fName});
                break;
            }
            case I16: 
            case I32: {
                this.writer.formatln("dest.writeInt(%s);", new Object[]{fName});
                break;
            }
            case I64: {
                this.writer.formatln("dest.writeLong(%s);", new Object[]{fName});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("dest.writeDouble(%s);", new Object[]{fName});
                break;
            }
            case STRING: {
                this.writer.formatln("dest.writeString(%s);", new Object[]{fName});
                break;
            }
            case BINARY: {
                this.writer.formatln("dest.writeByteArray(%s.get());", new Object[]{fName});
                break;
            }
            case ENUM: {
                this.writer.formatln("dest.writeInt(%s.getValue());", new Object[]{fName});
                break;
            }
            case MESSAGE: {
                this.writer.formatln("dest.writeTypedObject(%s, 0);", new Object[]{fName});
                break;
            }
            case LIST: 
            case SET: {
                PContainer cType = (PContainer)desc;
                String iTypeName = this.helper.getInstanceClassName(cType.itemDescriptor());
                switch (cType.itemDescriptor().getType()) {
                    case BOOL: {
                        this.appendParcelableArrayConverter("Boolean", fName, "boolean", "item");
                        this.writer.appendln((CharSequence)"dest.writeBooleanArray(arr);");
                        break;
                    }
                    case BYTE: {
                        this.appendParcelableArrayConverter("Byte", fName, "byte", "item");
                        this.writer.appendln((CharSequence)"dest.writeByteArray(arr);");
                        break;
                    }
                    case I16: {
                        this.appendParcelableArrayConverter("Short", fName, "int", "item");
                        this.writer.appendln((CharSequence)"dest.writeIntArray(arr);");
                        break;
                    }
                    case I32: {
                        this.appendParcelableArrayConverter("Integer", fName, "int", "item");
                        this.writer.appendln((CharSequence)"dest.writeIntArray(arr);");
                        break;
                    }
                    case I64: {
                        this.appendParcelableArrayConverter("Long", fName, "long", "item");
                        this.writer.appendln((CharSequence)"dest.writeLongArray(arr);");
                        break;
                    }
                    case DOUBLE: {
                        this.appendParcelableArrayConverter("Double", fName, "double", "item");
                        this.writer.appendln((CharSequence)"dest.writeDoubleArray(arr);");
                        break;
                    }
                    case STRING: {
                        this.writer.formatln("dest.writeStringArray(%s.toArray(new String[%s.size()]));", new Object[]{fName, fName});
                        break;
                    }
                    case BINARY: {
                        this.writer.formatln("dest.writeInt(%s.size());", new Object[]{fName}).formatln("for (Binary item : %s) {", new Object[]{fName}).begin().appendln((CharSequence)"dest.writeByteArray(item.get());").end().appendln('}');
                        break;
                    }
                    case MESSAGE: {
                        if (desc.getType().equals((Object)PType.SET)) {
                            this.writer.formatln("dest.writeTypedList(new ArrayList<>(%s));", new Object[]{fName, iTypeName, fName});
                            break;
                        }
                        this.writer.formatln("dest.writeTypedList(%s);", new Object[]{fName, iTypeName, fName});
                        break;
                    }
                    case ENUM: {
                        this.appendParcelableArrayConverter(iTypeName, fName, "int", "item.getValue()");
                        this.writer.appendln((CharSequence)"dest.writeIntArray(arr);");
                        break;
                    }
                    case LIST: 
                    case SET: 
                    case MAP: {
                        this.writer.formatln("// %s is too complex to parse.", new Object[]{this.helper.getFieldType((PDescriptor)cType)});
                    }
                }
                break;
            }
            case MAP: {
                PMap mType = (PMap)desc;
                switch (mType.itemDescriptor().getType()) {
                    case LIST: 
                    case SET: 
                    case MAP: {
                        this.writer.formatln("// %s is to complext to parse.", new Object[]{this.helper.getFieldType((PDescriptor)mType)});
                        return;
                    }
                }
                this.writer.appendln('{').begin();
                String kTypeName = this.helper.getInstanceClassName(mType.keyDescriptor());
                String iTypeName = this.helper.getInstanceClassName(mType.itemDescriptor());
                String kName = fName + ".keySet()";
                switch (mType.keyDescriptor().getType()) {
                    case BOOL: {
                        this.appendParcelableArrayConverter("Boolean", kName, "boolean", "item");
                        this.writer.appendln((CharSequence)"dest.writeBooleanArray(arr);");
                        break;
                    }
                    case BYTE: {
                        this.appendParcelableArrayConverter("Byte", kName, "byte", "item");
                        this.writer.appendln((CharSequence)"dest.writeByteArray(arr);");
                        break;
                    }
                    case I16: {
                        this.appendParcelableArrayConverter("Short", kName, "int", "item");
                        this.writer.appendln((CharSequence)"dest.writeIntArray(arr);");
                        break;
                    }
                    case I32: {
                        this.appendParcelableArrayConverter("Integer", kName, "int", "item");
                        this.writer.appendln((CharSequence)"dest.writeIntArray(arr);");
                        break;
                    }
                    case I64: {
                        this.appendParcelableArrayConverter("Long", kName, "long", "item");
                        this.writer.appendln((CharSequence)"dest.writeLongArray(arr);");
                        break;
                    }
                    case DOUBLE: {
                        this.appendParcelableArrayConverter("Double", kName, "double", "item");
                        this.writer.appendln((CharSequence)"dest.writeDoubleArray(arr);");
                        break;
                    }
                    case STRING: {
                        this.writer.formatln("dest.writeStringArray(%s.toArray(new String[%s.size()]));", new Object[]{kName, kName});
                        break;
                    }
                    case BINARY: {
                        this.writer.formatln("dest.writeInt(%s.size());", new Object[]{kName}).formatln("for (Binary item : %s) {", new Object[]{kName}).begin().appendln((CharSequence)"dest.writeByteArray(item.get());").end().appendln('}');
                        break;
                    }
                    case MESSAGE: {
                        this.writer.formatln("dest.writeParcelableArray(%s.toArray(new %s[%s.size()]), 0);", new Object[]{kName, kTypeName, kName});
                        break;
                    }
                    case ENUM: {
                        this.appendParcelableArrayConverter(kTypeName, kName, "int", "item.getValue()");
                        this.writer.appendln((CharSequence)"dest.writeIntArray(arr);");
                        break;
                    }
                    default: {
                        throw new GeneratorException("Map keys cannot contain containers.");
                    }
                }
                this.writer.end().appendln('}');
                String vName = fName + ".values()";
                switch (mType.itemDescriptor().getType()) {
                    case BOOL: {
                        this.appendParcelableArrayConverter("Boolean", vName, "boolean", "item");
                        this.writer.appendln((CharSequence)"dest.writeBooleanArray(arr);");
                        break block0;
                    }
                    case BYTE: {
                        this.appendParcelableArrayConverter("Byte", vName, "byte", "item");
                        this.writer.appendln((CharSequence)"dest.writeByteArray(arr);");
                        break block0;
                    }
                    case I16: {
                        this.appendParcelableArrayConverter("Short", vName, "int", "item");
                        this.writer.appendln((CharSequence)"dest.writeIntArray(arr);");
                        break block0;
                    }
                    case I32: {
                        this.appendParcelableArrayConverter("Integer", vName, "int", "item");
                        this.writer.appendln((CharSequence)"dest.writeIntArray(arr);");
                        break block0;
                    }
                    case I64: {
                        this.appendParcelableArrayConverter("Long", vName, "long", "item");
                        this.writer.appendln((CharSequence)"dest.writeLongArray(arr);");
                        break block0;
                    }
                    case DOUBLE: {
                        this.appendParcelableArrayConverter("Double", vName, "double", "item");
                        this.writer.appendln((CharSequence)"dest.writeDoubleArray(arr);");
                        break block0;
                    }
                    case STRING: {
                        this.writer.formatln("dest.writeStringArray(%s.toArray(new String[%s.size()]));", new Object[]{vName, vName});
                        break block0;
                    }
                    case BINARY: {
                        this.writer.formatln("dest.writeInt(%s.size());", new Object[]{vName}).formatln("for (Binary item : %s) {", new Object[]{vName}).begin().appendln((CharSequence)"dest.writeByteArray(item.get());").end().appendln('}');
                        break block0;
                    }
                    case MESSAGE: {
                        this.writer.formatln("dest.writeParcelableArray(%s.toArray(new %s[%s.size()]), 0);", new Object[]{vName, iTypeName, vName});
                        break block0;
                    }
                    case ENUM: {
                        this.appendParcelableArrayConverter(iTypeName, vName, "int", "item.getValue()");
                        this.writer.appendln((CharSequence)"dest.writeIntArray(arr);");
                        break block0;
                    }
                }
                throw new GeneratorException("Unknown map value type: " + mType.getName());
            }
        }
    }

    private void appendParcelableArrayReader(String creator, String typeName, String addToF, String cast) {
        this.writer.formatln("%s[] tmp = source.%s();", new Object[]{typeName, creator}).appendln((CharSequence)"for (int i = 0; i < tmp.length; ++i) {").formatln("    builder.%s(%stmp[i]);", new Object[]{addToF, cast}).appendln('}');
    }

    private void appendParcelableReader(String setF, String addToF, PDescriptor<?> desc) throws GeneratorException {
        String classF = this.helper.getInstanceClassName(desc);
        switch (desc.getType()) {
            case BOOL: {
                this.writer.formatln("builder.%s(source.readByte() > 0);", new Object[]{setF});
                break;
            }
            case BYTE: {
                this.writer.formatln("builder.%s(source.readByte());", new Object[]{setF});
                break;
            }
            case I16: {
                this.writer.formatln("builder.%s((short)source.readInt());", new Object[]{setF});
                break;
            }
            case I32: {
                this.writer.formatln("builder.%s(source.readInt());", new Object[]{setF});
                break;
            }
            case I64: {
                this.writer.formatln("builder.%s(source.readLong());", new Object[]{setF});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("builder.%s(source.readDouble());", new Object[]{setF});
                break;
            }
            case STRING: {
                this.writer.formatln("builder.%s(source.readString());", new Object[]{setF});
                break;
            }
            case BINARY: {
                this.writer.formatln("builder.%s(Binary.wrap(source.createByteArray()));", new Object[]{setF});
                break;
            }
            case ENUM: {
                this.writer.formatln("builder.%s(%s.forValue(source.readInt()));", new Object[]{setF, classF});
                break;
            }
            case MESSAGE: {
                this.writer.formatln("builder.%s((%s) source.readTypedObject(%s.CREATOR));", new Object[]{setF, classF, classF});
                break;
            }
            case LIST: 
            case SET: {
                PContainer cType = (PContainer)desc;
                String cItemClass = this.helper.getInstanceClassName(cType.itemDescriptor());
                switch (cType.itemDescriptor().getType()) {
                    case BOOL: {
                        this.writer.formatln("builder.%s(source.createBooleanArray());", new Object[]{addToF});
                        break;
                    }
                    case BYTE: {
                        this.writer.formatln("builder.%s(source.createByteArray());", new Object[]{addToF});
                        break;
                    }
                    case I16: {
                        this.appendParcelableArrayReader("createIntArray", "int", addToF, "(short)");
                        break;
                    }
                    case I32: {
                        this.writer.formatln("builder.%s(source.createIntArray());", new Object[]{addToF});
                        break;
                    }
                    case I64: {
                        this.writer.formatln("builder.%s(source.createLongArray());", new Object[]{addToF});
                        break;
                    }
                    case DOUBLE: {
                        this.writer.formatln("builder.%s(source.createDoubleArray());", new Object[]{addToF});
                        break;
                    }
                    case STRING: {
                        this.writer.formatln("builder.%s(source.createStringArray());", new Object[]{addToF});
                        break;
                    }
                    case BINARY: {
                        this.writer.formatln("final int len = source.readInt();", new Object[0]).appendln((CharSequence)"for (int i = 0; i < len; ++i) {").begin().formatln("builder.%s(Binary.wrap(source.createByteArray()));", new Object[]{addToF}).end().appendln('}');
                        break;
                    }
                    case MESSAGE: {
                        this.writer.formatln("builder.%s(source.createTypedArrayList(%s.CREATOR));", new Object[]{setF, cItemClass, cItemClass});
                        break;
                    }
                    case ENUM: {
                        this.writer.appendln((CharSequence)"int[] tmp = source.createIntArray();").formatln("%s[] values = new %s[tmp.length];", new Object[]{cItemClass, cItemClass}).appendln((CharSequence)"for (int i = 0; i < tmp.length; ++i) {").formatln("    values[i] = %s.forValue(tmp[i]);", new Object[]{cItemClass}).appendln('}').formatln("builder.%s(values);", new Object[]{addToF});
                        break;
                    }
                    case LIST: 
                    case SET: 
                    case MAP: {
                        this.writer.formatln("// %s is too complex to parse.", new Object[]{this.helper.getFieldType((PDescriptor)cType)});
                    }
                }
                break;
            }
            case MAP: {
                PMap mType = (PMap)desc;
                switch (mType.itemDescriptor().getType()) {
                    case LIST: 
                    case SET: 
                    case MAP: {
                        this.writer.formatln("// %s is to complext to parse.", new Object[]{this.helper.getFieldType((PDescriptor)mType)});
                        return;
                    }
                }
                String mkClass = this.helper.getInstanceClassName(mType.keyDescriptor());
                String miClass = this.helper.getInstanceClassName(mType.itemDescriptor());
                switch (mType.keyDescriptor().getType()) {
                    case BOOL: {
                        this.writer.appendln((CharSequence)"boolean[] keys = source.createBooleanArray();");
                        break;
                    }
                    case BYTE: {
                        this.writer.appendln((CharSequence)"byte[] keys = source.createByteArray();");
                        break;
                    }
                    case I16: {
                        this.writer.appendln((CharSequence)"int[] key_tmp = source.createIntArray();").appendln((CharSequence)"short[] keys = new short[key_tmp.length];").appendln((CharSequence)"for (int i = 0; i < key_tmp.length; ++i) {").appendln((CharSequence)"    keys[i] = (short) key_tmp[i];").appendln((CharSequence)"}");
                        break;
                    }
                    case I32: {
                        this.writer.appendln((CharSequence)"int[] keys = source.createIntArray();");
                        break;
                    }
                    case I64: {
                        this.writer.appendln((CharSequence)"long[] keys = source.createLongArray();");
                        break;
                    }
                    case DOUBLE: {
                        this.writer.appendln((CharSequence)"double[] keys = source.createDoubleArray();");
                        break;
                    }
                    case STRING: {
                        this.writer.appendln((CharSequence)"String[] keys = source.createStringArray();");
                        break;
                    }
                    case BINARY: {
                        this.writer.appendln((CharSequence)"final int len = source.readInt();").appendln((CharSequence)"Binary[] keys = new Binary[len];").appendln((CharSequence)"for (int i = 0; i < len; ++i) {").formatln("    keys[i] = Binary.wrap(source.createByteArray());", new Object[0]).appendln('}');
                        break;
                    }
                    case MESSAGE: {
                        this.writer.formatln("%s[] keys = source.createTypedArray(%s.CREATOR);", new Object[]{mkClass, mkClass});
                        break;
                    }
                    case ENUM: {
                        this.writer.appendln((CharSequence)"int[] key_tmp = source.createIntArray();").formatln("%s[] keys = new %s[key_tmp.length];", new Object[]{mkClass, mkClass}).appendln((CharSequence)"for (int i = 0; i < key_tmp.length; ++i) {").formatln("    keys[i] = %s.forValue(key_tmp[i]);", new Object[]{mkClass}).appendln('}');
                        break;
                    }
                    default: {
                        throw new GeneratorException("Containers not allowed in map key.");
                    }
                }
                switch (mType.itemDescriptor().getType()) {
                    case BOOL: {
                        this.writer.appendln((CharSequence)"boolean[] values = source.createBooleanArray();");
                        break;
                    }
                    case BYTE: {
                        this.writer.appendln((CharSequence)"byte[] values = source.createByteArray();");
                        break;
                    }
                    case I16: {
                        this.writer.appendln((CharSequence)"int[] val_tmp = source.createIntArray();").appendln((CharSequence)"short[] values = new short[val_tmp.length];").appendln((CharSequence)"for (int i = 0; i < val_tmp.length; ++i) {").appendln((CharSequence)"    values[i] = (short) val_tmp[i];").appendln((CharSequence)"}");
                        break;
                    }
                    case I32: {
                        this.writer.appendln((CharSequence)"int[] values = source.createIntArray();");
                        break;
                    }
                    case I64: {
                        this.writer.appendln((CharSequence)"long[] values = source.createLongArray();");
                        break;
                    }
                    case DOUBLE: {
                        this.writer.appendln((CharSequence)"double[] values = source.createDoubleArray();");
                        break;
                    }
                    case STRING: {
                        this.writer.appendln((CharSequence)"String[] values = source.createStringArray();");
                        break;
                    }
                    case BINARY: {
                        this.writer.appendln((CharSequence)"Binary[] values = new Binary[keys.length];").appendln((CharSequence)"for (int i = 0; i < keys.length; ++i) {").formatln("    values[i] = Binary.wrap(source.createByteArray());", new Object[0]).appendln('}');
                        break;
                    }
                    case MESSAGE: {
                        this.writer.formatln("%s[] values = source.createTypedArray(%s.CREATOR);", new Object[]{miClass, miClass});
                        break;
                    }
                    case ENUM: {
                        this.writer.appendln((CharSequence)"int[] val_tmp = source.createIntArray();").formatln("%s[] values = new %s[val_tmp.length];", new Object[]{miClass, miClass}).appendln((CharSequence)"for (int i = 0; i < val_tmp.length; ++i) {").formatln("    values[i] = %s.forValue(val_tmp[i]);", new Object[]{miClass}).appendln('}');
                        break;
                    }
                }
                this.writer.formatln("for (int i = 0; i < keys.length; ++i) {", new Object[0]).begin().formatln("builder.%s(keys[i], values[i]);", new Object[]{addToF}).end().appendln('}');
            }
        }
    }

    public void appendParcelable(JMessage message) throws GeneratorException {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int describeContents() {").begin().appendln((CharSequence)"return 0;").end().appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public void writeToParcel(Parcel dest, int flags) {").begin();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"if (tUnionField != null) {").begin().appendln((CharSequence)"switch (tUnionField) {").begin();
            for (JField field : message.fields()) {
                this.writer.formatln("case %s:", new Object[]{field.fieldEnum()}).begin().formatln("dest.writeInt(%d);", new Object[]{field.id()});
                this.appendParcelableWriter(field.member(), field.getPField().getDescriptor());
                this.writer.appendln((CharSequence)"break;").end();
            }
            this.writer.end().appendln((CharSequence)"}").end().appendln((CharSequence)"}");
        } else {
            for (JField field : message.fields()) {
                if (!field.alwaysPresent()) {
                    switch (field.type()) {
                        case LIST: 
                        case SET: 
                        case MAP: {
                            this.writer.formatln("if (%s() > 0) {", new Object[]{field.counter()});
                            break;
                        }
                        default: {
                            this.writer.formatln("if (%s()) {", new Object[]{field.presence()});
                        }
                    }
                    this.writer.begin();
                }
                this.writer.formatln("dest.writeInt(%d);", new Object[]{field.id()});
                this.appendParcelableWriter(field.member(), field.getPField().getDescriptor());
                if (field.alwaysPresent()) continue;
                this.writer.end().appendln('}');
            }
        }
        this.writer.appendln((CharSequence)"dest.writeInt(0);").end().appendln('}').newline();
        this.writer.formatln("public static final Parcelable.Creator<%s> CREATOR = new Parcelable.Creator<%s>() {", new Object[]{message.instanceType(), message.instanceType()}).begin();
        this.writer.appendln((CharSequence)"@Override").formatln("public %s createFromParcel(Parcel source) {", new Object[]{message.instanceType()}).begin().appendln((CharSequence)"_Builder builder = new _Builder();").appendln((CharSequence)"loop: while (source.dataAvail() > 0) {").begin().appendln((CharSequence)"int field = source.readInt();").appendln((CharSequence)"switch (field) {").begin().appendln((CharSequence)"case 0: break loop;");
        for (JField field : message.fields()) {
            this.writer.formatln("case %d: {", new Object[]{field.id()}).begin();
            this.appendParcelableReader(field.setter(), field.adder(), field.getPField().getDescriptor());
            this.writer.appendln((CharSequence)"break;").end().appendln('}');
        }
        this.writer.appendln((CharSequence)"default: throw new IllegalArgumentException(\"Unknown field ID: \" + field);").end().appendln('}').end().appendln('}').newline().appendln((CharSequence)"return builder.build();").end().appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").formatln("public %s[] newArray(int size) {", new Object[]{message.instanceType()}).begin().formatln("return new %s[size];", new Object[]{message.instanceType()}).end().appendln('}');
        this.writer.end().appendln((CharSequence)"};").newline();
    }
}

