/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import net.morimekta.util.io.IndentedPrintWriter;

public class JHeader {
    private final TreeSet<String> mIncludes;
    private final String mJavaPackage;

    public JHeader(String javaPackage) {
        this.mJavaPackage = javaPackage;
        this.mIncludes = new TreeSet();
    }

    public boolean hasIncluded(String javaClass) {
        return this.mIncludes.contains(javaClass);
    }

    public void include(String javaClass) {
        String pkg;
        if (javaClass == null) {
            return;
        }
        int pos = javaClass.lastIndexOf(46);
        if (pos > 0 && !(pkg = javaClass.substring(0, pos)).equals(this.mJavaPackage) && !pkg.equals("java.lang")) {
            this.mIncludes.add(javaClass);
        }
    }

    public void format(IndentedPrintWriter writer) {
        TreeSet<String> includes = new TreeSet<String>((SortedSet<String>)this.mIncludes);
        HashSet<String> done = new HashSet<String>();
        writer.format("package %s;", new Object[]{this.mJavaPackage}).newline();
        for (String include : includes) {
            if (!include.startsWith("java.")) continue;
            writer.formatln("import %s;", new Object[]{include});
            done.add(include);
        }
        if (done.size() > 0) {
            writer.newline();
            includes.removeAll(done);
            done.clear();
        }
        for (String include : includes) {
            if (!include.startsWith("android.")) continue;
            writer.formatln("import %s;", new Object[]{include});
            done.add(include);
        }
        if (done.size() > 0) {
            writer.newline();
            includes.removeAll(done);
            done.clear();
        }
        for (String include : includes) {
            if (!include.startsWith("net.morimekta.providence.")) continue;
            writer.formatln("import %s;", new Object[]{include});
            done.add(include);
        }
        if (done.size() > 0) {
            writer.append('\n');
            includes.removeAll(done);
            done.clear();
        }
        for (String include : includes) {
            writer.formatln("import %s;", new Object[]{include});
        }
        if (includes.size() > 0) {
            writer.newline();
        }
    }
}

