/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.io.IOException;
import java.io.OutputStream;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.generator.Generator;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JConstantsFormat;
import net.morimekta.providence.generator.format.java.JEnumFormat;
import net.morimekta.providence.generator.format.java.JHelper;
import net.morimekta.providence.generator.format.java.JMessageFormat;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.providence.generator.format.java.JUtils;
import net.morimekta.providence.generator.util.FileManager;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.providence.reflect.util.TypeRegistry;
import net.morimekta.util.io.IndentedPrintWriter;

public class JGenerator
extends Generator {
    private final JOptions mOptions;
    TypeRegistry mRegistry;
    JHelper mTypeHelper;

    public JGenerator(FileManager manager, TypeRegistry registry, JOptions options) {
        super(manager);
        this.mRegistry = registry;
        this.mOptions = options;
        this.mTypeHelper = new JHelper(this.mRegistry, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(CDocument document) throws IOException, GeneratorException {
        String javaPackage = JUtils.getJavaPackage(document);
        JMessageFormat messageFormatter = new JMessageFormat(this.mTypeHelper, this.mOptions);
        JEnumFormat enumFormatter = new JEnumFormat(this.mTypeHelper, this.mOptions);
        String path = JUtils.getPackageClassPath(javaPackage);
        if (document.getConstants().size() > 0) {
            String file = this.mTypeHelper.getConstantsClassName(document) + ".java";
            OutputStream out = this.getFileManager().create(path, file);
            try {
                JConstantsFormat constFormat = new JConstantsFormat(this.mTypeHelper, this.mOptions);
                IndentedPrintWriter writer = new IndentedPrintWriter(out);
                constFormat.format(writer, document);
                writer.flush();
            }
            finally {
                try {
                    this.getFileManager().finalize(out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (PDeclaredDescriptor type : document.getDeclaredTypes()) {
            String file = this.mTypeHelper.getInstanceClassName((PDescriptor)type) + ".java";
            OutputStream out = this.getFileManager().create(path, file);
            try {
                IndentedPrintWriter writer = new IndentedPrintWriter(out);
                switch (type.getType()) {
                    case MESSAGE: {
                        messageFormatter.format(writer, (PStructDescriptor)type);
                        break;
                    }
                    case ENUM: {
                        enumFormatter.format(writer, (PEnumDescriptor)type);
                        break;
                    }
                    default: {
                        throw new GeneratorException("Unhandled declaration type.");
                    }
                }
                writer.flush();
            }
            finally {
                this.getFileManager().finalize(out);
            }
        }
    }
}

