/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.generator.format.java.JHelper;
import net.morimekta.util.Strings;

public class JField {
    private final PField<?> field;
    private final JHelper helper;
    private final int index;

    public JField(PField<?> field, JHelper helper, int index) {
        this.field = field;
        this.helper = helper;
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public PField<?> getPField() {
        return this.field;
    }

    public PType type() {
        return this.field.getType();
    }

    public boolean binary() {
        return this.field.getType() == PType.BINARY;
    }

    public int id() {
        return this.field.getKey();
    }

    public String name() {
        return this.field.getName();
    }

    public String param() {
        return Strings.camelCase((String)"p", (String)this.field.getName());
    }

    public String member() {
        return Strings.camelCase((String)"m", (String)this.field.getName());
    }

    public String getter() {
        if (this.field.getType() == PType.BOOL) {
            return Strings.camelCase((String)"is", (String)this.field.getName());
        }
        return Strings.camelCase((String)"get", (String)this.field.getName());
    }

    public String presence() {
        return Strings.camelCase((String)"has", (String)this.field.getName());
    }

    public String counter() {
        return Strings.camelCase((String)"num", (String)this.field.getName());
    }

    public String setter() {
        return Strings.camelCase((String)"set", (String)this.field.getName());
    }

    public String adder() {
        if (this.field.getType() == PType.MAP) {
            return Strings.camelCase((String)"putIn", (String)this.field.getName());
        }
        return Strings.camelCase((String)"addTo", (String)this.field.getName());
    }

    public String resetter() {
        return Strings.camelCase((String)"clear", (String)this.field.getName());
    }

    public String fieldEnum() {
        return Strings.c_case((String)"", (String)this.field.getName()).toUpperCase();
    }

    public String kDefault() {
        return Strings.camelCase((String)"kDefault", (String)this.field.getName());
    }

    public boolean hasDefault() {
        return this.alwaysPresent() || this.field.hasDefaultValue();
    }

    public boolean isRequired() {
        return this.field.getRequirement() == PRequirement.REQUIRED;
    }

    public boolean container() {
        switch (this.field.getType()) {
            case MAP: 
            case SET: 
            case LIST: {
                return true;
            }
        }
        return false;
    }

    public boolean alwaysPresent() {
        return this.field.getRequirement() != PRequirement.OPTIONAL && this.field.getDescriptor() instanceof PPrimitive && ((PPrimitive)this.field.getDescriptor()).getDefaultValue() != null;
    }

    public String valueType() {
        return this.helper.getValueType(this.field.getDescriptor());
    }

    public String fieldType() {
        if (this.alwaysPresent()) {
            return this.valueType();
        }
        return this.helper.getFieldType(this.field.getDescriptor());
    }

    public String instanceType() {
        return this.helper.getInstanceClassName(this.field.getDescriptor());
    }

    public boolean hasComment() {
        return this.field.getComment() != null;
    }

    public String comment() {
        return this.field.getComment();
    }
}

