/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumBuilderFactory;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptorProvider;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JAnnotation;
import net.morimekta.providence.generator.format.java.JHeader;
import net.morimekta.providence.generator.format.java.JHelper;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.providence.generator.format.java.JUtils;
import net.morimekta.util.io.IndentedPrintWriter;

public class JEnumFormat {
    private final JHelper helper;
    private final JOptions options;

    public JEnumFormat(JHelper helper, JOptions options) {
        this.helper = helper;
        this.options = options;
    }

    public void format(IndentedPrintWriter writer, PEnumDescriptor<?> type) throws GeneratorException {
        JHeader header = new JHeader(this.helper.getJavaPackage((PDeclaredDescriptor<?>)type));
        header.include(PEnumBuilder.class.getName());
        header.include(PEnumBuilderFactory.class.getName());
        header.include(PEnumValue.class.getName());
        header.include(PEnumDescriptor.class.getName());
        header.include(PEnumDescriptorProvider.class.getName());
        if (this.options.jackson) {
            header.include("com.fasterxml.jackson.annotation.JsonCreator");
            header.include("com.fasterxml.jackson.annotation.JsonValue");
        }
        header.format(writer);
        String simpleClass = this.helper.getInstanceClassName((PDescriptor)type);
        if (type.getComment() != null) {
            JUtils.appendBlockComment(writer, type.getComment());
            if (JAnnotation.isDeprecated(type)) {
                writer.appendln((CharSequence)"@Deprecated");
            }
        }
        writer.formatln("public enum %s implements PEnumValue<%s> {", new Object[]{simpleClass, simpleClass}).begin();
        for (PEnumValue v : type.getValues()) {
            writer.formatln("%s(%d, \"%s\"),", new Object[]{v.getName().toUpperCase(), v.getValue(), v.getName()});
        }
        writer.appendln(';').newline();
        writer.appendln((CharSequence)"private final int mValue;").appendln((CharSequence)"private final String mName;").newline().formatln("%s(int value, String name) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"mValue = value;").appendln((CharSequence)"mName = name;").end().appendln((CharSequence)"}").newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String getComment() {").begin().appendln((CharSequence)"return null;").end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int getValue() {").begin().appendln((CharSequence)"return mValue;").end().appendln('}').newline();
        if (this.options.jackson) {
            writer.appendln((CharSequence)"@JsonValue");
        }
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String getName() {").begin().appendln((CharSequence)"return mName;").end().appendln('}').newline();
        writer.formatln("public static %s forValue(int value) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"switch (value) {").begin();
        for (PEnumValue value : type.getValues()) {
            writer.formatln("case %d: return %s.%s;", new Object[]{value.getValue(), simpleClass, value.getName().toUpperCase()});
        }
        writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
        if (this.options.jackson) {
            writer.appendln((CharSequence)"@JsonCreator");
        }
        writer.formatln("public static %s forName(String name) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"switch (name) {").begin();
        for (PEnumValue value : type.getValues()) {
            writer.formatln("case \"%s\": return %s.%s;", new Object[]{value.getName(), simpleClass, value.getName().toUpperCase()});
        }
        writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
        this.appendBuilder(writer, type);
        this.appendDescriptor(writer, type);
        writer.end().appendln('}').newline();
    }

    private void appendDescriptor(IndentedPrintWriter writer, PEnumDescriptor<?> type) {
        String simpleClass = this.helper.getInstanceClassName((PDescriptor)type);
        writer.formatln("public static final PEnumDescriptor<%s> kDescriptor;", new Object[]{simpleClass}).newline();
        writer.appendln((CharSequence)"@Override").formatln("public PEnumDescriptor<%s> descriptor() {", new Object[]{simpleClass}).begin().appendln((CharSequence)"return kDescriptor;").end().appendln('}').newline();
        writer.formatln("public static PEnumDescriptorProvider<%s> provider() {", new Object[]{simpleClass}).begin().formatln("return new PEnumDescriptorProvider<%s>(kDescriptor);", new Object[]{simpleClass}).end().appendln('}').newline();
        writer.appendln((CharSequence)"private static class _Factory").begin().formatln("    extends PEnumBuilderFactory<%s> {", new Object[]{simpleClass}).appendln((CharSequence)"@Override").formatln("public %s._Builder builder() {", new Object[]{simpleClass}).begin().formatln("return new %s._Builder();", new Object[]{simpleClass}).end().appendln('}').end().appendln('}').newline();
        writer.appendln((CharSequence)"private static class _Descriptor").formatln("        extends PEnumDescriptor<%s> {", new Object[]{simpleClass}).begin().appendln((CharSequence)"public _Descriptor() {").begin().formatln("super(null, \"%s\", \"%s\", new _Factory());", new Object[]{type.getPackageName(), type.getName(), simpleClass}).end().appendln('}').newline().appendln((CharSequence)"@Override").formatln("public %s[] getValues() {", new Object[]{simpleClass}).begin().formatln("return %s.values();", new Object[]{simpleClass}).end().appendln('}').newline().appendln((CharSequence)"@Override").formatln("public %s getValueById(int id) {", new Object[]{simpleClass}).begin().formatln("return %s.forValue(id);", new Object[]{simpleClass}).end().appendln('}').newline().appendln((CharSequence)"@Override").formatln("public %s getValueByName(String name) {", new Object[]{simpleClass}).begin().formatln("return %s.forName(name);", new Object[]{simpleClass}).end().appendln('}').end().appendln('}').newline();
        writer.formatln("static {", new Object[]{simpleClass}).begin();
        writer.appendln((CharSequence)"kDescriptor = new _Descriptor();").end().appendln('}');
    }

    protected void appendBuilder(IndentedPrintWriter writer, PEnumDescriptor<?> type) {
        String simpleClass = this.helper.getInstanceClassName((PDescriptor)type);
        writer.formatln("public static class _Builder extends PEnumBuilder<%s> {", new Object[]{simpleClass}).begin().formatln("%s mValue;", new Object[]{simpleClass}).newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder setByValue(int value) {").begin().formatln("mValue = %s.forValue(value);", new Object[]{simpleClass}).appendln((CharSequence)"return this;").end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder setByName(String name) {").begin().formatln("mValue = %s.forName(name);", new Object[]{simpleClass}).appendln((CharSequence)"return this;").end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean isValid() {").begin().appendln((CharSequence)"return mValue != null;").end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").formatln("public %s build() {", new Object[]{simpleClass}).begin().appendln((CharSequence)"return mValue;").end().appendln('}');
        writer.end().appendln('}').newline();
    }
}

