/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.util.Collection;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JField;
import net.morimekta.providence.generator.format.java.JHeader;
import net.morimekta.providence.generator.format.java.JHelper;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.providence.generator.format.java.JUtils;
import net.morimekta.providence.generator.format.java.JValueFormat;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.util.io.IndentedPrintWriter;

public class JConstantsFormat {
    private static final String DBL_INDENT = "        ";
    private final JOptions options;
    private final JHelper helper;

    public JConstantsFormat(JHelper helper, JOptions options) {
        this.helper = helper;
        this.options = options;
    }

    public void format(IndentedPrintWriter writer, CDocument document) throws GeneratorException {
        JValueFormat value = new JValueFormat(writer, this.options, this.helper);
        this.appendHeader(writer, value, document);
        if (document.getComment() != null) {
            JUtils.appendBlockComment(writer, document.getComment());
        }
        writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")").formatln("public class %s {", new Object[]{this.helper.getConstantsClassName(document)}).begin().formatln("private %s() {}", new Object[]{this.helper.getConstantsClassName(document)}).newline();
        for (PField c : document.getConstants()) {
            switch (c.getType()) {
                case MESSAGE: {
                    String name = c.getName();
                    String instance = this.helper.getValueType(c.getDescriptor());
                    writer.formatln("public static final %s %s;", new Object[]{this.helper.getValueType(c.getDescriptor()), name}).appendln((CharSequence)"static {").begin().formatln("%s._Builder builder = %s.builder();", new Object[]{instance, instance});
                    PMessage message = (PMessage)c.getDefaultValue();
                    int i = 0;
                    for (PField f : message.descriptor().getFields()) {
                        JField field = new JField(f, this.helper, i++);
                        if (!message.has(f.getKey())) continue;
                        writer.formatln("builder.%s(", new Object[]{field.setter()});
                        value.appendTypedValue(message.get(f.getKey()), f.getDescriptor());
                        writer.append((CharSequence)");");
                    }
                    writer.formatln("%s = builder.build();", new Object[]{name}).end().appendln('}');
                    break;
                }
                case LIST: 
                case SET: {
                    String name = c.getName();
                    String instance = this.helper.getInstanceClassName(c.getDescriptor());
                    PContainer lDesc = (PContainer)c.getDescriptor();
                    PDescriptor itemDesc = lDesc.itemDescriptor();
                    writer.formatln("public static final %s %s;", new Object[]{this.helper.getValueType(c.getDescriptor()), name}).appendln((CharSequence)"static {").begin().formatln("%s builder = new %s<>();", new Object[]{instance, instance});
                    Collection items = (Collection)c.getDefaultValue();
                    for (Object item : items) {
                        writer.appendln((CharSequence)"builder.add(").begin(DBL_INDENT);
                        value.appendTypedValue(item, itemDesc);
                        writer.end().append((CharSequence)");");
                    }
                    if (c.getType() == PType.LIST) {
                        writer.formatln("%s = Collections.unmodifiableList(builder);", new Object[]{name});
                    } else {
                        writer.formatln("%s = Collections.unmodifiableSet(builder);", new Object[]{name});
                    }
                    writer.end().appendln('}');
                    break;
                }
                case MAP: {
                    break;
                }
                default: {
                    writer.formatln("public static final %s %s = ", new Object[]{this.helper.getValueType(c.getDescriptor()), c.getName()}).begin(DBL_INDENT);
                    value.appendTypedValue(c.getDefaultValue(), c.getDescriptor());
                    writer.append(';').end();
                }
            }
            writer.newline();
        }
        writer.end().appendln('}');
    }

    private void appendHeader(IndentedPrintWriter writer, JValueFormat value, CDocument document) throws GeneratorException {
        JHeader header = new JHeader(this.helper.getJavaPackage(document));
        for (PField field : document.getConstants()) {
            value.addTypeImports(header, field.getDescriptor());
        }
        header.format(writer);
    }
}

