/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.util.regex.Pattern;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.generator.format.java.JField;

public class JAnnotation {
    public static final String DEPRECATED = "@Deprecated";
    private static final Pattern DEPRECATED_RE = Pattern.compile("[@][Dd]eprecated\\b", 8);
    private static final Pattern COMPACT_RE = Pattern.compile("[@][Cc]ompact\\b", 8);

    public static boolean isDeprecated(PField<?> field) {
        return field.getComment() != null && DEPRECATED_RE.matcher(field.getComment()).find();
    }

    public static boolean isDeprecated(JField field) {
        return field.hasComment() && DEPRECATED_RE.matcher(field.comment()).find();
    }

    public static boolean isDeprecated(PDeclaredDescriptor<?> type) {
        return type.getComment() != null && DEPRECATED_RE.matcher(type.getComment()).find();
    }

    public static boolean isDeprecated(PEnumValue<?> value) {
        return value.getComment() != null && DEPRECATED_RE.matcher(value.getComment()).find();
    }

    public static boolean isCompact(PDeclaredDescriptor<?> type) {
        return type instanceof PStructDescriptor && type.getComment() != null && COMPACT_RE.matcher(type.getComment()).find();
    }
}

