/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.json;

import java.io.IOException;
import java.io.OutputStream;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.generator.Generator;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.util.FileManager;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.reflect.TypeLoader;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.providence.serializer.SerializerException;

public class JsonGenerator
extends Generator {
    private final TypeLoader typeLoader;
    private final JsonSerializer serializer;

    public JsonGenerator(FileManager fileManager, TypeLoader loader) {
        super(fileManager);
        this.typeLoader = loader;
        this.serializer = new JsonSerializer().pretty();
    }

    public void generate(CProgram document) throws IOException, GeneratorException {
        for (ProgramType doc : this.typeLoader.loadedPrograms()) {
            if (!doc.getProgramName().equals(document.getProgramName())) continue;
            OutputStream out = this.getFileManager().create(null, doc.getProgramName() + ".json");
            try {
                this.serializer.serialize(out, (PMessage)doc);
                out.write(10);
            }
            catch (SerializerException e) {
                throw new GeneratorException("Unable to serialize document.", (Throwable)e);
            }
            this.getFileManager().finalize(out);
        }
    }
}

