/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.json;

import java.io.IOException;
import java.io.OutputStream;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.generator.Generator;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.util.FileManager;
import net.morimekta.providence.model.ThriftDocument;
import net.morimekta.providence.reflect.TypeLoader;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.providence.serializer.SerializerException;

public class JsonGenerator
extends Generator {
    private final TypeLoader typeLoader;
    private final JsonSerializer serializer;

    public JsonGenerator(FileManager fileManager, TypeLoader loader) {
        super(fileManager);
        this.typeLoader = loader;
        this.serializer = new JsonSerializer(false, JsonSerializer.IdType.NAME, JsonSerializer.IdType.NAME, true);
    }

    public void generate(CDocument document) throws IOException, GeneratorException {
        for (ThriftDocument doc : this.typeLoader.loadedDocuments()) {
            if (!doc.getPackage().equals(document.getPackageName())) continue;
            OutputStream out = this.getFileManager().create(null, doc.getPackage() + ".json");
            try {
                this.serializer.serialize(out, (PMessage)doc);
                out.write(10);
            }
            catch (SerializerException e) {
                throw new GeneratorException("Unable to serialize document.", (Throwable)e);
            }
            this.getFileManager().finalize(out);
        }
    }
}

