/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import java.io.IOException;
import java.util.ArrayList;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JServiceMethod;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.reflect.contained.CServiceMethod;
import net.morimekta.providence.reflect.contained.CStructDescriptor;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;

public class JService {
    private final CService service;
    private final JHelper helper;

    public JService(CService service, JHelper helper) {
        this.service = service;
        this.helper = helper;
    }

    public String className() {
        return JUtils.getClassName(this.service);
    }

    public JServiceMethod[] methods() {
        ArrayList methods = new ArrayList(this.service.getMethodsIncludingExtended());
        CServiceMethod[] ma = methods.toArray(new CServiceMethod[methods.size()]);
        JServiceMethod[] ret = new JServiceMethod[ma.length];
        for (int i = 0; i < methods.size(); ++i) {
            ret[i] = new JServiceMethod(this.service, ma[i], this.helper);
        }
        return ret;
    }

    public JServiceMethod[] declaredMethods() {
        ArrayList methods = new ArrayList(this.service.getMethods());
        CServiceMethod[] ma = methods.toArray(new CServiceMethod[methods.size()]);
        JServiceMethod[] ret = new JServiceMethod[ma.length];
        for (int i = 0; i < methods.size(); ++i) {
            ret[i] = new JServiceMethod(this.service, ma[i], this.helper);
        }
        return ret;
    }

    public String getRequestClassRef(JServiceMethod method) {
        if (!this.isDeclaredMethod(method)) {
            if (this.service.getExtendsService() == null) {
                throw new GeneratorException("Unable to find source service of method: " + method.name() + " context: " + this.service.getQualifiedName());
            }
            return new JService(this.service.getExtendsService(), this.helper).getRequestClassRef(method);
        }
        CStructDescriptor rq = method.getMethod().getRequestType();
        if (rq.isInnerType() && rq.isAutoType()) {
            return this.helper.getJavaPackage((PDeclaredDescriptor<?>)this.service) + "." + this.className() + "." + JUtils.getClassName(rq);
        }
        return this.helper.getValueType((PDescriptor)rq);
    }

    public String getResponseClassRef(JServiceMethod method) {
        if (!this.isDeclaredMethod(method)) {
            if (this.service.getExtendsService() == null) {
                throw new GeneratorException("Unable to find source service of method: " + method.name() + " context: " + this.service.getQualifiedName());
            }
            return new JService(this.service.getExtendsService(), this.helper).getResponseClassRef(method);
        }
        CUnionDescriptor rs = method.getMethod().getResponseType();
        if (rs == null) {
            return null;
        }
        return this.helper.getJavaPackage((PDeclaredDescriptor<?>)this.service) + "." + this.className() + "." + JUtils.getClassName(rs);
    }

    public boolean isDeclaredMethod(JServiceMethod ref) {
        for (PServiceMethod method : this.service.getMethods()) {
            if (!method.getName().equals(ref.name())) continue;
            return true;
        }
        return false;
    }

    public String methodsThrows(JServiceMethod method) {
        if (!this.isDeclaredMethod(method)) {
            if (this.service.getExtendsService() == null) {
                throw new GeneratorException("Unable to find source service of method: " + method.name() + " context: " + this.service.getQualifiedName());
            }
            return new JService(this.service.getExtendsService(), this.helper).methodsThrows(method);
        }
        if (this.service.hasAnnotation(PAnnotation.JAVA_SERVICE_METHOD_THROWS)) {
            String doThrow = this.service.getAnnotationValue(PAnnotation.JAVA_SERVICE_METHOD_THROWS);
            if (!IOException.class.getName().equals(doThrow)) {
                if (Exception.class.getName().equals(doThrow) || Exception.class.getSimpleName().equals(doThrow)) {
                    throw new GeneratorException("Not allowed to declare '" + doThrow + "' as the service thrown exception. Annotation: " + PAnnotation.JAVA_SERVICE_METHOD_THROWS.tag);
                }
                return doThrow;
            }
        }
        return null;
    }

    public CService getService() {
        return this.service;
    }
}

