/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.shared;

import java.util.LinkedHashSet;
import java.util.List;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.EnumMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CEnumValue;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.io.IndentedPrintWriter;

public class BaseEnumFormatter {
    private final IndentedPrintWriter writer;
    private final List<EnumMemberFormatter> formatters;

    public BaseEnumFormatter(IndentedPrintWriter writer, List<EnumMemberFormatter> formatters) {
        this.writer = writer;
        this.formatters = UnmodifiableList.copyOf(formatters);
    }

    public void appendEnumClass(CEnumDescriptor type) throws GeneratorException {
        String deprecatedReason;
        String simpleClass = JUtils.getClassName(type);
        BlockCommentBuilder classComment = null;
        if (type.getDocumentation() != null) {
            classComment = new BlockCommentBuilder(this.writer);
            classComment.comment(type.getDocumentation());
        }
        if ((deprecatedReason = type.getAnnotationValue(PAnnotation.DEPRECATED)) != null && deprecatedReason.trim().length() > 0) {
            if (classComment == null) {
                classComment = new BlockCommentBuilder(this.writer);
            } else {
                classComment.newline();
            }
            classComment.deprecated_(deprecatedReason);
        }
        if (classComment != null) {
            classComment.finish();
        }
        this.formatters.forEach(f -> f.appendClassAnnotations(type));
        this.writer.formatln("public enum %s", new Object[]{simpleClass}).begin();
        LinkedHashSet impl = new LinkedHashSet();
        this.formatters.forEach(f -> impl.addAll(f.getExtraImplements(type)));
        if (impl.size() > 0) {
            this.writer.formatln("    implements ", new Object[0]).begin("               ");
            boolean first = true;
            for (String i : impl) {
                if (first) {
                    first = false;
                } else {
                    this.writer.append(',').appendln();
                }
                this.writer.append((CharSequence)i);
            }
            this.writer.end();
        }
        this.writer.append((CharSequence)" {");
        this.appendEnumValues(type);
        this.appendEnumFields(type);
        this.appendEnumConstructor(type);
        this.formatters.forEach(f -> f.appendMethods(type));
        this.formatters.forEach(f -> f.appendExtraProperties(type));
        this.writer.end().appendln('}').newline();
    }

    private void appendEnumValues(CEnumDescriptor type) {
        for (CEnumValue v : type.getValues()) {
            if (v.getDocumentation() != null) {
                new BlockCommentBuilder(this.writer).comment(v.getDocumentation()).finish();
            }
            if (JAnnotation.isDeprecated((CAnnotatedDescriptor)v)) {
                this.writer.appendln((CharSequence)"@Deprecated");
            }
            String pojoName = v.asString();
            if (v.hasAnnotation(PAnnotation.JSON_NAME)) {
                pojoName = v.getAnnotationValue(PAnnotation.JSON_NAME);
            }
            this.writer.formatln("%s(%d, \"%s\", \"%s\"),", new Object[]{JUtils.enumConst((PEnumValue)v), v.asInteger(), v.asString(), pojoName});
        }
        this.writer.appendln(';').newline();
    }

    private void appendEnumFields(CEnumDescriptor type) {
        this.writer.appendln((CharSequence)"private final int    mId;").appendln((CharSequence)"private final String mName;").appendln((CharSequence)"private final String mPojoName;").newline();
    }

    private void appendEnumConstructor(CEnumDescriptor type) {
        this.writer.formatln("%s(int id, String name, String pojoName) {", new Object[]{JUtils.getClassName(type)}).begin().appendln((CharSequence)"mId = id;").appendln((CharSequence)"mName = name;").appendln((CharSequence)"mPojoName = pojoName;").end().appendln((CharSequence)"}").newline();
    }
}

