/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;

public class JConst {
    private final PDescriptor type;
    private final JHelper helper;

    public JConst(PDescriptor type, JHelper helper) {
        this.type = type;
        this.helper = helper;
    }

    private PContainer.Type containerType() {
        return this.type instanceof CAnnotatedDescriptor ? JAnnotation.containerType((CAnnotatedDescriptor)this.type) : null;
    }

    public String valueType() throws GeneratorException {
        return this.helper.getValueType(this.type);
    }

    private String fieldType() throws GeneratorException {
        return this.valueType();
    }

    public String wrappedBuilderInstanceType() throws GeneratorException {
        switch (this.type.getType()) {
            case MAP: {
                if (this.containerType() == PContainer.Type.SORTED) {
                    return PMap.SortedBuilder.class.getName().replace('$', '.');
                }
                return PMap.DefaultBuilder.class.getName().replace('$', '.');
            }
            case SET: {
                if (this.containerType() == PContainer.Type.SORTED) {
                    return PSet.SortedBuilder.class.getName().replace('$', '.');
                }
                return PSet.DefaultBuilder.class.getName().replace('$', '.');
            }
            case LIST: {
                return PList.DefaultBuilder.class.getName().replace('$', '.');
            }
        }
        return this.fieldType();
    }
}

