/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages.extras;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.util.ArrayUtil;
import net.morimekta.util.Binary;
import net.morimekta.util.BinaryUtil;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;
import net.morimekta.util.io.IndentedPrintWriter;

public class HazelcastPortableMessageFormatter
implements MessageMemberFormatter {
    public static final String PORTABLE_CLASS = "com.hazelcast.nio.serialization.Portable";
    public static final String PORTABLE_READER_CLASS = "com.hazelcast.nio.serialization.PortableReader";
    public static final String PORTABLE_WRITER_CLASS = "com.hazelcast.nio.serialization.PortableWriter";
    public static final String WRAPPER_CLASS_NAME = "_Builder";
    private static final String PORTABLE_WRITER = "portableWriter";
    private static final String PORTABLE_READER = "portableReader";
    private final IndentedPrintWriter writer;
    private final JHelper helper;
    private Integer uniqueVariable;

    public HazelcastPortableMessageFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
        this.uniqueVariable = 0;
    }

    private String tempVariable(String name) {
        this.uniqueVariable = this.uniqueVariable + 1;
        return "tmp_" + name + "_" + this.uniqueVariable;
    }

    @Override
    public Collection<String> getExtraImplements(JMessage<?> message) throws GeneratorException {
        if (message.hasAnnotation(PAnnotation.JAVA_HAZELCAST_CLASS_ID)) {
            return UnmodifiableList.listOf((Object)PORTABLE_CLASS);
        }
        return UnmodifiableList.listOf();
    }

    @Override
    public void appendMethods(JMessage<?> message) throws GeneratorException {
        if (message.hasAnnotation(PAnnotation.JAVA_HAZELCAST_CLASS_ID)) {
            this.appendFactoryId(message);
            this.appendClassId(message);
            this.appendPortableWriter(message);
            this.appendPortableReader(message);
        }
    }

    private void appendFactoryId(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int getFactoryId() {").begin().formatln("return %s.%s;", new Object[]{JUtils.getHazelcastFactory(message.descriptor()), "FACTORY_ID"}).end().appendln((CharSequence)"}").newline();
    }

    private void appendClassId(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int getClassId() {").begin().formatln("return %s.%s;", new Object[]{JUtils.getHazelcastFactory(message.descriptor()), JUtils.getHazelcastClassId(message.descriptor())}).end().appendln((CharSequence)"}").newline();
    }

    private void appendPortableWriter(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").formatln("public void writePortable(%s %s) throws %s {", new Object[]{PORTABLE_WRITER_CLASS, PORTABLE_WRITER, IOException.class.getName()}).begin();
        this.writer.appendln((CharSequence)"int[] setFields = presentFields().stream()").formatln("                                 .mapToInt(%s::getId)", new Object[]{PField.class.getName()}).appendln((CharSequence)"                                 .toArray();").appendln((CharSequence)"portableWriter.writeIntArray(\"__fields__\", setFields);");
        for (JField field : message.declaredOrderFields()) {
            if (!field.alwaysPresent()) {
                this.writer.formatln("if( %s() ) {", new Object[]{field.isSet()}).begin();
            }
            this.writePortableField(field);
            if (field.alwaysPresent()) continue;
            this.writer.end().appendln((CharSequence)"} else {").begin();
            this.writeDefaultPortableField(field);
            this.writer.end().appendln((CharSequence)"}");
        }
        this.writer.end().appendln((CharSequence)"}").newline();
    }

    private void appendPortableReader(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").formatln("public void readPortable(%s %s) throws %s {", new Object[]{PORTABLE_READER_CLASS, PORTABLE_READER, IOException.class.getName()}).begin();
        this.writer.formatln("int[] field_ids = %s.readIntArray(\"__fields__\");", new Object[]{PORTABLE_READER}).appendln().appendln((CharSequence)"for (int id : field_ids) {").begin().appendln((CharSequence)"switch (id) {").begin();
        for (JField field : message.declaredOrderFields()) {
            this.writer.formatln("case %d: {", new Object[]{field.id()}).begin();
            this.readPortableField(field);
            this.writer.appendln((CharSequence)"break;").end().appendln((CharSequence)"}");
        }
        this.writer.end().appendln((CharSequence)"}").end().appendln((CharSequence)"}").end().appendln((CharSequence)"}").newline();
    }

    private void writePortableField(JField field) throws GeneratorException {
        if (field.portableRequiresBinarySerialization()) {
            String baosTemp = this.tempVariable("baos");
            String bebwTemp = this.tempVariable("bebw");
            this.writer.formatln("try (%s %s = new %s();", new Object[]{ByteArrayOutputStream.class.getName(), baosTemp, ByteArrayOutputStream.class.getName()}).formatln("     %s %s = new %s(%s) ) {", new Object[]{BigEndianBinaryWriter.class.getName(), bebwTemp, BigEndianBinaryWriter.class.getName(), baosTemp}).begin();
            if (field.type() == PType.MESSAGE) {
                String tempVar = this.tempVariable("message");
                this.writer.formatln("%s %s = %s_builder != null ? %s_builder.build() : %s;", new Object[]{field.fieldType(), tempVar, field.member(), field.member(), field.member()});
                this.writePortableBinary(bebwTemp, tempVar, field.field().getDescriptor());
            } else {
                this.writePortableBinary(bebwTemp, field.member(), field.field().getDescriptor());
            }
            this.writer.formatln("%s.writeByteArray(\"%s\", %s.toByteArray());", new Object[]{PORTABLE_WRITER, field.name(), baosTemp}).end().println("}");
            return;
        }
        switch (field.type()) {
            case BINARY: {
                this.writer.formatln("%s.writeByteArray(\"%s\", %s.get());", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s.writeBoolean(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case BYTE: {
                this.writer.formatln("%s.writeByte(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s.writeDouble(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s.writeInt(\"%s\", %s.asInteger());", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case I16: {
                this.writer.formatln("%s.writeShort(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case I32: {
                this.writer.formatln("%s.writeInt(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case I64: {
                this.writer.formatln("%s.writeLong(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case STRING: {
                this.writer.formatln("%s.writeUTF(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case LIST: {
                this.writePortableFieldList(field, field.toPList().itemDescriptor());
                break;
            }
            case SET: {
                this.writePortableFieldList(field, field.toPSet().itemDescriptor());
                break;
            }
            case MESSAGE: {
                this.writer.formatln("if (%s_builder != null) {", new Object[]{field.member()}).formatln("    %s.writePortable(\"%s\", %s_builder);", new Object[]{PORTABLE_WRITER, field.name(), field.member()}).appendln((CharSequence)"} else {").formatln("    %s.writePortable(\"%s\", %s.mutate());", new Object[]{PORTABLE_WRITER, field.name(), field.member()}).appendln((CharSequence)"}");
                break;
            }
            default: {
                throw new GeneratorException("Not implemented writePortableField for type: " + field.type() + " in " + this.getClass().getSimpleName());
            }
        }
    }

    private void writePortableBinary(String bebw, String getter, PDescriptor descriptor) {
        switch (descriptor.getType()) {
            case BINARY: {
                this.writer.formatln("%s.%s(%s.length());", new Object[]{bebw, "writeInt", getter}).formatln("%s.%s(%s.get());", new Object[]{bebw, "write", getter});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s.%s(%s ? (byte)1 : 0);", new Object[]{bebw, "writeByte", getter});
                break;
            }
            case BYTE: {
                this.writer.formatln("%s.%s(%s);", new Object[]{bebw, "writeByte", getter});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s.%s(%s);", new Object[]{bebw, "writeDouble", getter});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s.%s(%s.asInteger());", new Object[]{bebw, "writeInt", getter});
                break;
            }
            case I16: {
                this.writer.formatln("%s.%s(%s);", new Object[]{bebw, "writeShort", getter});
                break;
            }
            case I32: {
                this.writer.formatln("%s.%s(%s);", new Object[]{bebw, "writeInt", getter});
                break;
            }
            case I64: {
                this.writer.formatln("%s.%s(%s);", new Object[]{bebw, "writeLong", getter});
                break;
            }
            case STRING: {
                String tempBinary = this.tempVariable("bin");
                this.writer.formatln("%s[] %s = %s.getBytes(%s.UTF_8);", new Object[]{Byte.TYPE.getName(), tempBinary, getter, StandardCharsets.class.getName()}).formatln("%s.%s(%s.length);", new Object[]{bebw, "writeInt", tempBinary}).formatln("%s.%s(%s);", new Object[]{bebw, "write", tempBinary});
                break;
            }
            case LIST: {
                PDescriptor innerList = ((PList)descriptor).itemDescriptor();
                String iteratorList = this.tempVariable("it");
                this.writer.formatln("%s.%s(%s.size());", new Object[]{bebw, "writeInt", getter});
                this.writer.formatln("for( %s %s : %s ) {", new Object[]{this.helper.getFieldType(innerList), iteratorList, getter}).begin();
                this.writePortableBinary(bebw, iteratorList, innerList);
                this.writer.end().println("}");
                break;
            }
            case SET: {
                PDescriptor innerSet = ((PSet)descriptor).itemDescriptor();
                String iteratorSet = this.tempVariable("it");
                this.writer.formatln("%s.%s(%s.size());", new Object[]{bebw, "writeInt", getter});
                this.writer.formatln("for( %s %s : %s ) {", new Object[]{this.helper.getFieldType(innerSet), iteratorSet, getter}).begin();
                this.writePortableBinary(bebw, iteratorSet, innerSet);
                this.writer.end().println("}");
                break;
            }
            case MAP: {
                PMap pMap = (PMap)descriptor;
                String iterator = "entry";
                this.writer.formatln("%s.writeInt(%s.size());", new Object[]{bebw, getter}).formatln("for( %s.Entry<%s,%s> %s : %s.entrySet() ) {", new Object[]{Map.class.getName(), this.helper.getFieldType(pMap.keyDescriptor()), this.helper.getFieldType(pMap.itemDescriptor()), iterator, getter}).begin();
                this.writePortableBinary(bebw, iterator + ".getKey()", pMap.keyDescriptor());
                this.writePortableBinary(bebw, iterator + ".getValue()", pMap.itemDescriptor());
                this.writer.end().println("}");
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s.writeBinary(%s);", new Object[]{getter, bebw});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented writePortableBinary for type: " + this.helper.getFieldType(descriptor) + " in " + this.getClass().getSimpleName());
            }
        }
    }

    private void readPortableBinary(String bebr, String variable, PDescriptor descriptor) {
        switch (descriptor.getType()) {
            case BINARY: {
                this.writer.formatln("%s = %s.%s(%s.%s());", new Object[]{variable, bebr, "expectBinary", bebr, "expectInt"});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s = (%s.%s() > 0 ? true : false);", new Object[]{variable, bebr, "expectByte"});
                break;
            }
            case BYTE: {
                this.writer.formatln("%s = %s.%s();", new Object[]{variable, bebr, "expectByte"});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s = %s.%s();", new Object[]{variable, bebr, "expectDouble"});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s = %s.findById(%s.%s());", new Object[]{variable, this.helper.getFieldType(descriptor), bebr, "expectInt"});
                break;
            }
            case I16: {
                this.writer.formatln("%s = %s.%s();", new Object[]{variable, bebr, "expectShort"});
                break;
            }
            case I32: {
                this.writer.formatln("%s = %s.%s();", new Object[]{variable, bebr, "expectInt"});
                break;
            }
            case I64: {
                this.writer.formatln("%s = %s.%s();", new Object[]{variable, bebr, "expectLong"});
                break;
            }
            case STRING: {
                this.writer.formatln("%s = new %s(%s.%s(%s.%s()), %s.UTF_8);", new Object[]{variable, this.helper.getFieldType(descriptor), bebr, "expectBytes", bebr, "expectInt", StandardCharsets.class.getName()});
                break;
            }
            case LIST: {
                PDescriptor itemType = ((PList)descriptor).itemDescriptor();
                String size = this.tempVariable("size");
                String iterator = this.tempVariable("it");
                String var = this.tempVariable("var");
                this.writer.formatln("int %s = %s.%s();", new Object[]{size, bebr, "expectInt"});
                this.writer.formatln("%s = new %s<>(%s);", new Object[]{variable, ArrayList.class.getName(), size});
                this.writer.formatln("%s %s;", new Object[]{this.helper.getFieldType(itemType), var});
                this.writer.formatln("for( int %s = 0; %s < %s; %s++ ) {", new Object[]{iterator, iterator, size, iterator}).begin();
                this.readPortableBinary(bebr, var, itemType);
                this.writer.formatln("%s.add(%s);", new Object[]{variable, var});
                this.writer.end().println("}");
                break;
            }
            case SET: {
                PDescriptor itemType = ((PSet)descriptor).itemDescriptor();
                String size = this.tempVariable("size");
                String iterator = this.tempVariable("it");
                String tmpVar = this.tempVariable("var");
                this.writer.formatln("%s = new %s<>();", new Object[]{variable, LinkedHashSet.class.getName()});
                this.writer.formatln("int %s = %s.%s();", new Object[]{size, bebr, "expectInt"});
                this.writer.formatln("%s %s;", new Object[]{this.helper.getFieldType(itemType), tmpVar});
                this.writer.formatln("for( int %s = 0; %s < %s; %s++ ) {", new Object[]{iterator, iterator, size, iterator}).begin();
                this.readPortableBinary(bebr, tmpVar, itemType);
                this.writer.formatln("%s.add(%s);", new Object[]{variable, tmpVar});
                this.writer.end().println("}");
                break;
            }
            case MAP: {
                PMap pMap = (PMap)descriptor;
                String mapSize = this.tempVariable("size");
                String keyVariable = this.tempVariable("key");
                String valueVariable = this.tempVariable("value");
                String tempIterator = this.tempVariable("it");
                this.writer.formatln("%s = new %s<>();", new Object[]{variable, LinkedHashMap.class.getName()}).formatln("%s %s = %s.%s();", new Object[]{Integer.TYPE.getName(), mapSize, bebr, "expectInt"}).formatln("%s %s;", new Object[]{this.helper.getFieldType(pMap.keyDescriptor()), keyVariable}).formatln("%s %s;", new Object[]{this.helper.getFieldType(pMap.itemDescriptor()), valueVariable}).appendln().formatln("for( %s %s = 0; %s < %s; %s++) {", new Object[]{Integer.TYPE.getName(), tempIterator, tempIterator, mapSize, tempIterator}).begin();
                this.readPortableBinary(bebr, keyVariable, pMap.keyDescriptor());
                this.readPortableBinary(bebr, valueVariable, pMap.itemDescriptor());
                this.writer.formatln("%s.put(%s, %s);", new Object[]{variable, keyVariable, valueVariable}).end().println("}");
                break;
            }
            case MESSAGE: {
                String tempMessage = this.tempVariable("message");
                this.writer.formatln("%s._Builder %s = %s.builder();", new Object[]{this.helper.getFieldType(descriptor), tempMessage, this.helper.getFieldType(descriptor)}).formatln("%s.readBinary(%s, false);", new Object[]{tempMessage, bebr}).formatln("%s = %s.build();", new Object[]{variable, tempMessage});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented readPortableBinary for type: " + this.helper.getFieldType(descriptor) + " in " + this.getClass().getSimpleName());
            }
        }
    }

    private void writeDefaultPortableField(JField field) throws GeneratorException {
        if (field.portableRequiresBinarySerialization()) {
            this.writer.formatln("%s.writeByteArray(\"%s\", new byte[0]);", new Object[]{PORTABLE_WRITER, field.name()});
            return;
        }
        switch (field.type()) {
            case BINARY: {
                this.writer.formatln("%s.writeByteArray(\"%s\", new byte[0]);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s.writeBoolean(\"%s\", false);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case BYTE: {
                this.writer.formatln("%s.writeByte(\"%s\", (byte) 0);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s.writeDouble(\"%s\", 0.0);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s.writeInt(\"%s\", 0);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case I16: {
                this.writer.formatln("%s.writeShort(\"%s\", (short) 0);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case I32: {
                this.writer.formatln("%s.writeInt(\"%s\", 0);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case I64: {
                this.writer.formatln("%s.writeLong(\"%s\", 0L);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case STRING: {
                this.writer.formatln("%s.writeUTF(\"%s\", \"\");", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case LIST: {
                this.writeDefaultPortableFieldList(field, field.toPList().itemDescriptor());
                break;
            }
            case SET: {
                this.writeDefaultPortableFieldList(field, field.toPSet().itemDescriptor());
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s.writeNullPortable(\"%s\", %s.%s, %s.%s);", new Object[]{PORTABLE_WRITER, field.name(), JUtils.getHazelcastFactory((PMessageDescriptor)field.field().getDescriptor()), "FACTORY_ID", JUtils.getHazelcastFactory((PMessageDescriptor)field.field().getDescriptor()), JUtils.getHazelcastClassId((PMessageDescriptor)field.field().getDescriptor())});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented writeDefaultPortableField for type: " + field.type() + " in " + this.getClass().getSimpleName());
            }
        }
    }

    private void writePortableFieldList(JField field, PDescriptor descriptor) throws GeneratorException {
        switch (descriptor.getType()) {
            case BYTE: {
                this.writer.formatln("%s.writeByteArray(\"%s\", %s.bytePrimitives(%s));", new Object[]{PORTABLE_WRITER, field.name(), ArrayUtil.class.getName(), field.member()});
                break;
            }
            case BINARY: {
                this.writer.formatln("%s.writeByteArray(\"%s\", %s.%s(%s));", new Object[]{PORTABLE_WRITER, field.name(), BinaryUtil.class.getName(), "fromBinaryCollection", field.member()});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s.writeBooleanArray(\"%s\", %s.booleanPrimitives(%s));", new Object[]{PORTABLE_WRITER, field.name(), ArrayUtil.class.getName(), field.member()});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s.writeDoubleArray(\"%s\", %s.doublePrimitives(%s));", new Object[]{PORTABLE_WRITER, field.name(), ArrayUtil.class.getName(), field.member()});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s.writeIntArray(\"%s\", %s.stream().mapToInt(%s::asInteger).toArray());", new Object[]{PORTABLE_WRITER, field.name(), field.member(), PEnumValue.class.getName()});
                break;
            }
            case I16: {
                this.writer.formatln("%s.writeShortArray(\"%s\", %s.shortPrimitives(%s));", new Object[]{PORTABLE_WRITER, field.name(), ArrayUtil.class.getName(), field.member()});
                break;
            }
            case I32: {
                this.writer.formatln("%s.writeIntArray(\"%s\", %s.intPrimitives(%s));", new Object[]{PORTABLE_WRITER, field.name(), ArrayUtil.class.getName(), field.member()});
                break;
            }
            case I64: {
                this.writer.formatln("%s.writeLongArray(\"%s\", %s.longPrimitives(%s));", new Object[]{PORTABLE_WRITER, field.name(), ArrayUtil.class.getName(), field.member()});
                break;
            }
            case STRING: {
                this.writer.formatln("%s.writeUTFArray(\"%s\", %s.toArray(new String[0]));", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s<%s.%s> %sList = %s.stream().map(i -> i.mutate()).collect(%s.toList());", new Object[]{List.class.getName(), this.helper.getValueType(descriptor), WRAPPER_CLASS_NAME, JUtils.camelCase("temp", field.name()), field.member(), Collectors.class.getName()});
                this.writer.formatln("%s.writePortableArray(\"%s\", %sList.toArray(new %s.%s[%sList.size()]));", new Object[]{PORTABLE_WRITER, field.name(), JUtils.camelCase("temp", field.name()), this.helper.getValueType(descriptor), WRAPPER_CLASS_NAME, JUtils.camelCase("temp", field.name())});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented writePortableFieldList for list with type: " + descriptor.getType() + " in " + this.getClass().getSimpleName());
            }
        }
    }

    private void writeDefaultPortableFieldList(JField field, PDescriptor descriptor) throws GeneratorException {
        switch (descriptor.getType()) {
            case BYTE: {
                this.writer.formatln("%s.writeByteArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case BINARY: {
                this.writer.formatln("%s.writeByteArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), "byte"});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s.writeBooleanArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s.writeDoubleArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s.writeIntArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), Integer.TYPE.getName()});
                break;
            }
            case I16: {
                this.writer.formatln("%s.writeShortArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case I32: {
                this.writer.formatln("%s.writeIntArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case I64: {
                this.writer.formatln("%s.writeLongArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case STRING: {
                this.writer.formatln("%s.writeUTFArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s.writePortableArray(\"%s\", new %s._Builder[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented writeDefaultPortableFieldList for list with type: " + descriptor.getType() + " in " + this.getClass().getSimpleName());
            }
        }
    }

    private void readPortableField(JField field) {
        if (field.portableRequiresBinarySerialization()) {
            String baisTemp = this.tempVariable("bais");
            String bebrTemp = this.tempVariable("bebr");
            String valueVariable = this.tempVariable("val");
            this.writer.formatln("try ( %s %s = new %s(%s.readByteArray(\"%s\"));", new Object[]{ByteArrayInputStream.class.getName(), baisTemp, ByteArrayInputStream.class.getName(), PORTABLE_READER, field.name()}).formatln("      %s %s = new %s(%s) ) {", new Object[]{BigEndianBinaryReader.class.getName(), bebrTemp, BigEndianBinaryReader.class.getName(), baisTemp}).begin().formatln("%s %s;", new Object[]{this.helper.getFieldType(field.field().getDescriptor()), valueVariable});
            this.readPortableBinary(bebrTemp, valueVariable, field.field().getDescriptor());
            this.writer.formatln("%s(%s);", new Object[]{field.setter(), valueVariable}).end().println("}");
            return;
        }
        switch (field.type()) {
            case BINARY: {
                this.writer.formatln("%s(new %s(%s.readByteArray(\"%s\")));", new Object[]{field.setter(), Binary.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s(%s.readBoolean(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case BYTE: {
                this.writer.formatln("%s(%s.readByte(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s(%s.readDouble(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s(%s.findById(%s.readInt(\"%s\")));", new Object[]{field.setter(), field.instanceType(), PORTABLE_READER, field.name()});
                break;
            }
            case I16: {
                this.writer.formatln("%s(%s.readShort(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case I32: {
                this.writer.formatln("%s(%s.readInt(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case I64: {
                this.writer.formatln("%s(%s.readLong(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case STRING: {
                this.writer.formatln("%s(%s.readUTF(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case LIST: {
                this.readPortableFieldList(field, field.toPList().itemDescriptor());
                break;
            }
            case SET: {
                this.readPortableFieldList(field, field.toPSet().itemDescriptor());
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s(((%s.%s)%s.readPortable(\"%s\")).%s());", new Object[]{field.setter(), field.instanceType(), WRAPPER_CLASS_NAME, PORTABLE_READER, field.name(), "build"});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented readPortableField for '" + field.name() + "' type: " + field.type() + " in " + this.getClass().getSimpleName());
            }
        }
    }

    private void readPortableFieldList(JField field, PDescriptor descriptor) throws GeneratorException {
        switch (descriptor.getType()) {
            case BYTE: {
                this.writer.formatln("%s(%s.listPrimitives(%s.readByteArray(\"%s\")));", new Object[]{field.setter(), ArrayUtil.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case BINARY: {
                this.writer.formatln("%s(%s.%s(%s.readByteArray(\"%s\")));", new Object[]{field.setter(), BinaryUtil.class.getName(), "toBinaryCollection", PORTABLE_READER, field.name()});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s(%s.listPrimitives(%s.readBooleanArray(\"%s\")));", new Object[]{field.setter(), ArrayUtil.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s(%s.listPrimitives(%s.readDoubleArray(\"%s\")));", new Object[]{field.setter(), ArrayUtil.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s(%s.listPrimitives(%s.readIntArray(\"%s\")).stream().map(t -> %s.%s(t.intValue())).collect(%s.toList()));", new Object[]{field.setter(), ArrayUtil.class.getName(), PORTABLE_READER, field.name(), descriptor.getName(), "findById", Collectors.class.getName()});
                break;
            }
            case I16: {
                this.writer.formatln("%s(%s.listPrimitives(%s.readShortArray(\"%s\")));", new Object[]{field.setter(), ArrayUtil.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case I32: {
                this.writer.formatln("%s(%s.listPrimitives(%s.readIntArray(\"%s\")));", new Object[]{field.setter(), ArrayUtil.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case I64: {
                this.writer.formatln("%s(%s.listPrimitives(%s.readLongArray(\"%s\")));", new Object[]{field.setter(), ArrayUtil.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case STRING: {
                this.writer.formatln("%s(%s.asList(%s.readUTFArray(\"%s\")));", new Object[]{field.setter(), Arrays.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s(%s.asList(%s.readPortableArray(\"%s\")).stream().map(i -> ((%s.%s)i).build()).collect(%s.toList()));", new Object[]{field.setter(), Arrays.class.getName(), PORTABLE_READER, field.name(), descriptor.getName(), WRAPPER_CLASS_NAME, Collectors.class.getName()});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented readPortableField for list with type: " + descriptor.getType() + " in " + this.getClass().getSimpleName());
            }
        }
    }
}

