/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.TreeMap;
import java.util.TreeSet;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessageDescriptor;
import net.morimekta.providence.types.TypeReference;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableMap;
import net.morimekta.util.collect.UnmodifiableSet;
import net.morimekta.util.collect.UnmodifiableSortedMap;
import net.morimekta.util.collect.UnmodifiableSortedSet;

public class JField {
    private final CField field;
    private final JHelper helper;
    private final int index;

    public JField(CField field, JHelper helper, int index) {
        this.field = field;
        this.helper = helper;
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public CField field() {
        return this.field;
    }

    public PType type() {
        return this.field.getType();
    }

    public boolean binary() {
        return this.field.getType() == PType.BINARY;
    }

    public int id() {
        return this.field.getId();
    }

    public String name() {
        return this.field.getName();
    }

    public String param() {
        return JUtils.camelCase("p", this.field.getName());
    }

    public String member() {
        return JUtils.camelCase("m", this.field.getName());
    }

    public String mutable() {
        return JUtils.camelCase("mutable", this.field.getName());
    }

    public String isSet() {
        return JUtils.camelCase("isSet", this.field.getName());
    }

    public String isModified() {
        return JUtils.camelCase("isModified", this.field.getName());
    }

    public String getter() {
        if (this.field.getType() == PType.BOOL) {
            return JUtils.camelCase("is", this.field.getName());
        }
        return JUtils.camelCase("get", this.field.getName());
    }

    public String optional() {
        return JUtils.camelCase("optional", this.field.getName());
    }

    public String presence() {
        return JUtils.camelCase("has", this.field.getName());
    }

    public String counter() {
        return JUtils.camelCase("num", this.field.getName());
    }

    public String setter() {
        return JUtils.camelCase("set", this.field.getName());
    }

    public String ref() {
        return JUtils.camelCase("ref", this.field.getName());
    }

    public PEnumDescriptor refEnum(PMessageDescriptor descriptor, JHelper helper) {
        if (this.type() == PType.I32 || this.type() == PType.I16 || this.type() == PType.BYTE || this.type() == PType.STRING) {
            PField overridden;
            String enumTypeName = this.field().getAnnotationValue(PAnnotation.REF_ENUM);
            if (Strings.isNotEmpty((String)enumTypeName)) {
                try {
                    return helper.getRegistry().requireEnumType(TypeReference.parseType((String)helper.getRegistry().getProgramContext(), (String)enumTypeName));
                }
                catch (Exception e) {
                    System.err.format("[ERROR] ref.enum = \"%s\" is unknown from %s%n", enumTypeName, descriptor.getQualifiedName() + "." + this.field.getName());
                }
            } else if (descriptor.getImplementing() != null && (overridden = descriptor.getImplementing().findFieldByName(this.field.getName())) instanceof CField) {
                JField jfo = new JField((CField)overridden, helper, -1);
                return jfo.refEnum((PMessageDescriptor)descriptor.getImplementing(), helper);
            }
        }
        return null;
    }

    public String adder() {
        if (this.field.getType() == PType.MAP) {
            return JUtils.camelCase("putIn", this.field.getName());
        }
        return JUtils.camelCase("addTo", this.field.getName());
    }

    public String resetter() {
        return JUtils.camelCase("clear", this.field.getName());
    }

    public String fieldEnum() {
        return Strings.c_case((String)this.field.getName()).toUpperCase(Locale.US);
    }

    public String kDefault() {
        return JUtils.camelCase("kDefault", this.field.getName());
    }

    public boolean hasDefaultConstant() {
        return this.isPrimitiveJavaValue() || this.alwaysPresent() || this.field.hasDefaultValue();
    }

    public boolean isRequired() {
        return this.field.getRequirement() == PRequirement.REQUIRED;
    }

    public boolean container() {
        switch (this.field.getType()) {
            case MAP: 
            case SET: 
            case LIST: {
                return true;
            }
        }
        return false;
    }

    public PContainer.Type containerType() {
        return JAnnotation.containerType(this);
    }

    public boolean alwaysPresent() {
        return this.field.getRequirement() != PRequirement.OPTIONAL && this.helper.getDefaultValue((PField)this.field) != null;
    }

    public boolean isPrimitiveJavaValue() {
        return this.field.getDescriptor() instanceof PPrimitive && ((PPrimitive)this.field.getDescriptor()).isNativePrimitive();
    }

    public String valueType() throws GeneratorException {
        return this.helper.getValueType(this.field.getDescriptor());
    }

    public String fieldType() throws GeneratorException {
        if (this.alwaysPresent()) {
            return this.valueType();
        }
        return this.helper.getFieldType(this.field.getDescriptor());
    }

    public String paramType() throws GeneratorException {
        if (this.alwaysPresent() && this.isRequired()) {
            return this.valueType();
        }
        return this.helper.getFieldType(this.field.getDescriptor());
    }

    public String instanceType() throws GeneratorException {
        return this.helper.getInstanceClassName(this.field);
    }

    public String builderFieldType() throws GeneratorException {
        switch (this.field.getType()) {
            case MAP: {
                PMap mType = (PMap)this.field.getDescriptor();
                String kType = this.helper.getFieldType(mType.keyDescriptor());
                String iType = this.helper.getFieldType(mType.itemDescriptor());
                return String.format(Locale.US, "%s<%s,%s>", PMap.Builder.class.getName().replace('$', '.'), kType, iType);
            }
            case SET: {
                PSet sType = (PSet)this.field.getDescriptor();
                String iType = this.helper.getFieldType(sType.itemDescriptor());
                return String.format(Locale.US, "%s<%s>", PSet.Builder.class.getName().replace('$', '.'), iType);
            }
            case LIST: {
                PList lType = (PList)this.field.getDescriptor();
                String iType = this.helper.getFieldType(lType.itemDescriptor());
                return String.format(Locale.US, "%s<%s>", PList.Builder.class.getName().replace('$', '.'), iType);
            }
        }
        return this.fieldType();
    }

    public String builderMutableType() throws GeneratorException {
        switch (this.field.getType()) {
            case LIST: {
                return ArrayList.class.getName();
            }
            case MAP: {
                switch (this.containerType()) {
                    case DEFAULT: {
                        return HashMap.class.getName();
                    }
                    case SORTED: {
                        return TreeMap.class.getName();
                    }
                    case ORDERED: {
                        return LinkedHashMap.class.getName();
                    }
                }
            }
            case SET: {
                switch (this.containerType()) {
                    case DEFAULT: {
                        return HashSet.class.getName();
                    }
                    case SORTED: {
                        return TreeSet.class.getName();
                    }
                    case ORDERED: {
                        return LinkedHashSet.class.getName();
                    }
                }
            }
            case MESSAGE: {
                return this.fieldType() + "._Builder";
            }
        }
        return this.fieldType();
    }

    public String fieldInstanceCopy(String var) throws GeneratorException {
        switch (this.field.getType()) {
            case LIST: {
                return UnmodifiableList.class.getName().replace('$', '.') + ".copyOf(" + var + ")";
            }
            case MAP: {
                switch (this.containerType()) {
                    case SORTED: {
                        return UnmodifiableSortedMap.class.getName().replace('$', '.') + ".copyOf(" + var + ")";
                    }
                }
                return UnmodifiableMap.class.getName().replace('$', '.') + ".copyOf(" + var + ")";
            }
            case SET: {
                switch (this.containerType()) {
                    case SORTED: {
                        return UnmodifiableSortedSet.class.getName().replace('$', '.') + ".copyOf(" + var + ")";
                    }
                }
                return UnmodifiableSet.class.getName().replace('$', '.') + ".copyOf(" + var + ")";
            }
        }
        throw new GeneratorException("Unable to instance copy " + this.field.getType());
    }

    public String wrappedBuilderInstanceType() throws GeneratorException {
        switch (this.field.getType()) {
            case MAP: {
                if (this.containerType() == PContainer.Type.SORTED) {
                    return PMap.SortedBuilder.class.getName().replace('$', '.');
                }
                return PMap.DefaultBuilder.class.getName().replace('$', '.');
            }
            case SET: {
                if (this.containerType() == PContainer.Type.SORTED) {
                    return PSet.SortedBuilder.class.getName().replace('$', '.');
                }
                return PSet.DefaultBuilder.class.getName().replace('$', '.');
            }
            case LIST: {
                return PList.DefaultBuilder.class.getName().replace('$', '.');
            }
        }
        return this.fieldType();
    }

    public String builderInstanceType() throws GeneratorException {
        switch (this.field.getType()) {
            case MAP: {
                if (this.containerType() == PContainer.Type.SORTED) {
                    return UnmodifiableSortedMap.Builder.class.getName().replace('$', '.');
                }
                return UnmodifiableMap.Builder.class.getName().replace('$', '.');
            }
            case SET: {
                if (this.containerType() == PContainer.Type.SORTED) {
                    return UnmodifiableSortedSet.Builder.class.getName().replace('$', '.');
                }
                return UnmodifiableSet.Builder.class.getName().replace('$', '.');
            }
            case LIST: {
                return UnmodifiableList.Builder.class.getName().replace('$', '.');
            }
        }
        return this.fieldType();
    }

    public String makeBuilderInstance() throws GeneratorException {
        switch (this.field.getType()) {
            case MAP: {
                if (this.containerType() == PContainer.Type.SORTED) {
                    return UnmodifiableSortedMap.class.getName() + ".builderNaturalOrder";
                }
                return UnmodifiableMap.class.getName() + ".builder";
            }
            case SET: {
                if (this.containerType() == PContainer.Type.SORTED) {
                    return UnmodifiableSortedSet.class.getName() + ".builderNaturalOrder";
                }
                return UnmodifiableSet.class.getName() + ".builder";
            }
            case LIST: {
                return UnmodifiableList.class.getName() + ".builder";
            }
        }
        return this.fieldType();
    }

    public String getProvider() throws GeneratorException {
        String container = this.field.getAnnotationValue("container");
        String containerProvider = "provider";
        if (container != null) {
            PContainer.Type containerType = PContainer.typeForName((String)container);
            switch (containerType) {
                case DEFAULT: {
                    containerProvider = "provider";
                    break;
                }
                case SORTED: {
                    containerProvider = "sortedProvider";
                    break;
                }
                case ORDERED: {
                    containerProvider = "orderedProvider";
                    break;
                }
            }
        }
        switch (this.field.getType()) {
            case MESSAGE: 
            case ENUM: {
                return String.format(Locale.US, "%s.provider()", this.helper.getFieldType(this.field.getDescriptor()));
            }
            case LIST: {
                PList lType = (PList)this.field.getDescriptor();
                return String.format(Locale.US, "%s.provider(%s)", PList.class.getName(), this.helper.getProviderName(lType.itemDescriptor()));
            }
            case SET: {
                PSet sType = (PSet)this.field.getDescriptor();
                return String.format(Locale.US, "%s.%s(%s)", PSet.class.getName(), containerProvider, this.helper.getProviderName(sType.itemDescriptor()));
            }
            case MAP: {
                PMap mType = (PMap)this.field.getDescriptor();
                return String.format(Locale.US, "%s.%s(%s,%s)", PMap.class.getName(), containerProvider, this.helper.getProviderName(mType.keyDescriptor()), this.helper.getProviderName(mType.itemDescriptor()));
            }
        }
        if (!(this.field.getDescriptor() instanceof PPrimitive)) {
            throw new IllegalArgumentException("Unhandled type group " + this.field.getType());
        }
        return String.format(Locale.US, "%s.%s.provider()", PPrimitive.class.getName(), this.field.getDescriptor().getName().toUpperCase(Locale.US));
    }

    public boolean hasComment() {
        return this.field.getDocumentation() != null;
    }

    public String comment() {
        return this.field.getDocumentation();
    }

    public boolean isVoid() {
        return this.field.getType() == PType.VOID;
    }

    public PList toPList() {
        return (PList)this.field().getDescriptor();
    }

    public PSet toPSet() {
        return (PSet)this.field().getDescriptor();
    }

    public PMap toPMap() {
        return (PMap)this.field().getDescriptor();
    }

    public boolean portableRequiresBinarySerialization() {
        switch (this.type()) {
            case MESSAGE: {
                return !((CMessageDescriptor)this.field().getDescriptor()).hasAnnotation(PAnnotation.JAVA_HAZELCAST_CLASS_ID);
            }
            case MAP: {
                return true;
            }
            case SET: 
            case LIST: {
                PDescriptor descriptor = this.extractItemDescriptor(this.field().getDescriptor());
                if (descriptor.getType().equals((Object)PType.MESSAGE)) {
                    return !((CMessageDescriptor)descriptor).hasAnnotation(PAnnotation.JAVA_HAZELCAST_CLASS_ID);
                }
                if (descriptor.getType() != PType.MAP && descriptor.getType() != PType.SET && descriptor.getType() != PType.LIST) break;
                return true;
            }
        }
        return false;
    }

    private PDescriptor extractItemDescriptor(PDescriptor descriptor) {
        PDescriptor result;
        switch (descriptor.getType()) {
            case SET: {
                result = this.extractItemDescriptor(((PSet)descriptor).itemDescriptor());
                break;
            }
            case LIST: {
                result = this.extractItemDescriptor(((PList)descriptor).itemDescriptor());
                break;
            }
            default: {
                result = descriptor;
            }
        }
        return result;
    }
}

