/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages.extras;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JavaOptions;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.io.IndentedPrintWriter;

public class SerializableMessageFormatter
implements MessageMemberFormatter {
    public static final String T_SERIALIZE_INSTANCE = "tSerializeInstance";
    private final IndentedPrintWriter writer;
    private final JavaOptions options;

    public SerializableMessageFormatter(IndentedPrintWriter writer, JavaOptions options) {
        this.writer = writer;
        this.options = options;
    }

    @Override
    public Collection<String> getExtraImplements(JMessage<?> message) throws GeneratorException {
        if (this.disabled(message)) {
            return UnmodifiableList.listOf();
        }
        if (message.isException()) {
            return UnmodifiableList.listOf();
        }
        return UnmodifiableList.listOf((Object)Serializable.class.getName());
    }

    @Override
    public void appendConstants(JMessage<?> message) throws GeneratorException {
        if (this.disabled(message)) {
            return;
        }
        this.writer.formatln("private final static long serialVersionUID = %dL;", new Object[]{JUtils.generateSerialVersionUID(message.descriptor())}).newline();
    }

    @Override
    public void appendFields(JMessage<?> message) throws GeneratorException {
        if (this.disabled(message)) {
            return;
        }
        this.writer.appendln((CharSequence)"// Transient object used during java deserialization.").formatln("private transient %s tSerializeInstance;", new Object[]{message.instanceType()}).newline();
    }

    @Override
    public void appendMethods(JMessage<?> message) {
        if (this.disabled(message)) {
            return;
        }
        this.appendWriteObject();
        this.appendReadObject(message);
        this.appendReadResolve();
    }

    private boolean disabled(JMessage<?> message) {
        return !message.isException() && !this.options.serializable;
    }

    private void appendWriteObject() {
        this.writer.formatln("private void writeObject(%s oos) throws %s {", new Object[]{ObjectOutputStream.class.getName(), IOException.class.getName()}).appendln((CharSequence)"    oos.defaultWriteObject();").formatln("    %s.INSTANCE.serialize(oos, this);", new Object[]{BinarySerializer.class.getName()}).appendln((CharSequence)"}").newline();
    }

    private void appendReadObject(JMessage<?> message) {
        this.writer.formatln("private void readObject(%s ois)", new Object[]{ObjectInputStream.class.getName()}).formatln("        throws %s, %s {", new Object[]{IOException.class.getName(), ClassNotFoundException.class.getSimpleName()}).begin().formatln("ois.defaultReadObject();", new Object[0]).formatln("tSerializeInstance = %s.INSTANCE.deserialize(ois, kDescriptor);", new Object[]{BinarySerializer.class.getName()});
        if (message.isException()) {
            this.writer.appendln((CharSequence)"if (getCause() != null) {").formatln("    tSerializeInstance.initCause(getCause());", new Object[0]).appendln((CharSequence)"}").appendln((CharSequence)"tSerializeInstance.setStackTrace(getStackTrace());");
        }
        this.writer.end().appendln((CharSequence)"}").newline();
    }

    private void appendReadResolve() {
        this.writer.formatln("private Object readResolve() throws %s {", new Object[]{ObjectStreamException.class.getName()}).appendln((CharSequence)"    return tSerializeInstance;").appendln((CharSequence)"}").newline();
    }
}

