/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CField;

public class JAnnotation {
    public static final String DEPRECATED = "@Deprecated";
    public static final String OVERRIDE = "@Override";
    public static final String NON_NULL = "@javax.annotation.Nonnull";
    public static final String NULLABLE = "@javax.annotation.Nullable";
    public static final String SUPPRESS_WARNINGS_UNCHECKED = "@SuppressWarnings(\"unchecked\")";
    public static final String SUPPRESS_WARNINGS_UNUSED = "@SuppressWarnings(\"unused\")";

    public static boolean isDeprecated(JField field) {
        return JAnnotation.isDeprecated((CAnnotatedDescriptor)field.field());
    }

    public static boolean isDeprecated(CAnnotatedDescriptor value) {
        return value.hasAnnotation(PAnnotation.DEPRECATED);
    }

    public static boolean isDeprecated(PDescriptor descriptor) {
        return descriptor instanceof CAnnotatedDescriptor && JAnnotation.isDeprecated((CAnnotatedDescriptor)descriptor);
    }

    static PContainer.Type containerType(CField field) {
        return JAnnotation.containerType((CAnnotatedDescriptor)field);
    }

    static PContainer.Type containerType(JField field) {
        return JAnnotation.containerType((CAnnotatedDescriptor)field.field());
    }

    public static PContainer.Type containerType(CAnnotatedDescriptor descriptor) {
        if (descriptor.hasAnnotation(PAnnotation.CONTAINER)) {
            return PContainer.typeForName((String)descriptor.getAnnotationValue(PAnnotation.CONTAINER));
        }
        return PContainer.Type.DEFAULT;
    }
}

