/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.Generated;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PInterfaceDescriptor;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.GeneratorOptions;
import net.morimekta.providence.generator.format.java.JavaOptions;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.generator.format.java.utils.ValueBuilder;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.types.TypeReference;
import net.morimekta.util.io.IndentedPrintWriter;

public class BaseInterfaceFormatter {
    protected final IndentedPrintWriter writer;
    private final JHelper helper;
    private final JavaOptions javaOptions;
    private final GeneratorOptions generatorOptions;

    public BaseInterfaceFormatter(IndentedPrintWriter writer, JHelper helper, JavaOptions javaOptions, GeneratorOptions generatorOptions) {
        this.writer = writer;
        this.helper = helper;
        this.javaOptions = javaOptions;
        this.generatorOptions = generatorOptions;
    }

    public void appendInterface(PMessageDescriptor<?> descriptor) throws GeneratorException {
        JMessage message = new JMessage(descriptor, this.helper);
        BlockCommentBuilder ifComment = null;
        if (message.descriptor() instanceof CAnnotatedDescriptor) {
            String deprecatedReason;
            CAnnotatedDescriptor annotatedDescriptor = (CAnnotatedDescriptor)message.descriptor();
            if (annotatedDescriptor.getDocumentation() != null) {
                ifComment = new BlockCommentBuilder(this.writer);
                ifComment.comment(annotatedDescriptor.getDocumentation());
            }
            if ((deprecatedReason = annotatedDescriptor.getAnnotationValue(PAnnotation.DEPRECATED)) != null && deprecatedReason.trim().length() > 0) {
                if (ifComment == null) {
                    ifComment = new BlockCommentBuilder(this.writer);
                } else {
                    ifComment.newline();
                }
                ifComment.deprecated_(deprecatedReason);
            }
        }
        if (ifComment != null) {
            ifComment.finish();
        }
        if (message.hasAnnotation(PAnnotation.DEPRECATED)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        if (!message.descriptor().getName().contains(".")) {
            this.writer.formatln("@%s(", new Object[]{Generated.class.getName()}).begin("        ").formatln("value = \"net.morimekta.providence:providence-generator-java%s\",", new Object[]{this.javaOptions.generated_annotation_version ? ":" + this.generatorOptions.program_version : ""});
            if (this.javaOptions.generated_annotation_date) {
                this.writer.formatln("date = \"%s\",", new Object[]{DateTimeFormatter.ISO_DATE_TIME.format(ZonedDateTime.now(Clock.systemUTC()).withNano(0))});
            }
            this.writer.formatln("comments = \"%s\")", new Object[]{this.javaOptions.toString()}).end();
        }
        String ext = "";
        HashSet<String> skipFields = new HashSet<String>();
        if (descriptor.getImplementing() != null && !message.isUnion()) {
            ext = "extends " + this.helper.getJavaPackage((PDeclaredDescriptor<?>)descriptor.getImplementing()) + "." + JUtils.getInterfaceName(descriptor.getImplementing()) + " ";
            for (PField field : descriptor.getImplementing().getFields()) {
                skipFields.add(field.getName());
            }
        }
        if (descriptor.getVariant() != PMessageVariant.INTERFACE) {
            ext = ext.isEmpty() ? "extends " : ext + ", ";
            ext = ext + PMessageOrBuilder.class.getName() + "<" + JUtils.getClassName(descriptor) + "> ";
        }
        this.writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")");
        this.writer.formatln("public interface %s %s{", new Object[]{JUtils.getInterfaceName(descriptor), ext}).begin();
        for (JField field : message.declaredOrderFields()) {
            if (skipFields.contains(field.name())) continue;
            boolean isDeprecated = false;
            String deprecatedReason = field.field().getAnnotationValue(PAnnotation.DEPRECATED);
            if (deprecatedReason != null) {
                if (deprecatedReason.trim().isEmpty()) {
                    deprecatedReason = null;
                }
                isDeprecated = true;
            }
            if (!field.isVoid()) {
                BlockCommentBuilder getComment = new BlockCommentBuilder(this.writer);
                if (field.hasComment()) {
                    getComment.comment(field.comment());
                    getComment.newline();
                }
                getComment.return_("The " + field.name() + " value.");
                if (deprecatedReason != null) {
                    getComment.deprecated_(deprecatedReason);
                }
                getComment.finish();
                if (isDeprecated) {
                    this.writer.appendln((CharSequence)"@Deprecated");
                }
                if (field.alwaysPresent() && !field.isPrimitiveJavaValue()) {
                    this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
                }
                this.writer.formatln("%s %s();", new Object[]{field.valueType(), field.getter()});
                this.writer.newline();
                PEnumDescriptor enumType = field.refEnum(message.descriptor(), this.helper);
                if (enumType != null) {
                    String reason;
                    BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
                    if (field.hasComment()) {
                        comment.comment(field.comment()).newline();
                    }
                    comment.return_("The <code>" + enumType.getName() + "</code> ref for the <code>" + field.name() + "</code> field, if it has a known value.");
                    if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
                        comment.deprecated_(reason);
                    }
                    comment.finish();
                    if (JAnnotation.isDeprecated(message.descriptor())) {
                        this.writer.appendln((CharSequence)"@Deprecated");
                    }
                    this.writer.appendln((CharSequence)"@javax.annotation.Nullable");
                    this.writer.formatln("%s %s();", new Object[]{this.helper.getValueType((PDescriptor)enumType), field.ref()}).newline();
                }
                if (!field.alwaysPresent()) {
                    BlockCommentBuilder optionalComment = new BlockCommentBuilder(this.writer);
                    if (field.hasComment()) {
                        optionalComment.comment(field.comment());
                        optionalComment.newline();
                    }
                    optionalComment.return_("Optional " + field.name() + " value.");
                    if (deprecatedReason != null) {
                        optionalComment.deprecated_(deprecatedReason);
                    }
                    optionalComment.finish();
                    if (isDeprecated) {
                        this.writer.appendln((CharSequence)"@Deprecated");
                    }
                    this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
                    this.writer.formatln("%s<%s> %s();", new Object[]{Optional.class.getName(), field.fieldType(), field.optional()});
                    this.writer.newline();
                }
            }
            BlockCommentBuilder hasComment = new BlockCommentBuilder(this.writer);
            hasComment.return_("If " + field.name() + " is present.");
            if (deprecatedReason != null) {
                hasComment.deprecated_(deprecatedReason);
            }
            hasComment.finish();
            if (isDeprecated) {
                this.writer.appendln((CharSequence)"@Deprecated");
            }
            this.writer.formatln("boolean %s();", new Object[]{field.presence()});
            if (field.container()) {
                this.writer.newline();
                BlockCommentBuilder numComment = new BlockCommentBuilder(this.writer);
                numComment.return_("Number of entries in " + field.name() + ".");
                if (deprecatedReason != null) {
                    numComment.deprecated_(deprecatedReason);
                }
                numComment.finish();
                if (isDeprecated) {
                    this.writer.appendln((CharSequence)"@Deprecated");
                }
                this.writer.formatln("int %s();", new Object[]{field.counter()});
            }
            this.writer.newline();
        }
        if (message.variant() == PMessageVariant.INTERFACE) {
            this.appendFieldEnum(message);
            this.appendDescriptor(message);
            this.appendBuilder(message);
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendBuilder(JMessage<?> message) {
        this.writer.newline().formatln("interface _Builder extends %s {", new Object[]{message.instanceType()}).begin();
        for (JField field : message.declaredOrderFields()) {
            this.appendBuilderSetter(field);
            if (field.container()) {
                this.appendBuilderAdder(field);
            }
            this.appendBuilderResetter(field);
        }
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.return_("The built instance");
        comment.finish();
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
        this.writer.formatln("%s build();", new Object[]{message.instanceType()});
        this.writer.end().appendln((CharSequence)"}");
    }

    private void appendBuilderAdder(JField field) {
        String reason;
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        if (field.type() == PType.MAP) {
            comment.commentRaw("Adds a mapping to the <code>" + field.name() + "</code> map.");
        } else if (field.type() == PType.SET) {
            comment.commentRaw("Adds entries to the <code>" + field.name() + "</code> set.");
        } else {
            comment.commentRaw("Adds entries to the <code>" + field.name() + "</code> list.");
        }
        if (field.hasComment()) {
            comment.paragraph().comment(field.comment());
        }
        comment.newline();
        if (field.type() == PType.MAP) {
            comment.param_("key", "The inserted key").param_("value", "The inserted value");
        } else {
            comment.param_("values", "The added value");
        }
        comment.return_("The builder");
        if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
            comment.deprecated_(reason);
        }
        comment.finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
        switch (field.type()) {
            case MAP: {
                PMap mType = (PMap)field.field().getDescriptor();
                String mkType = this.helper.getValueType(mType.keyDescriptor());
                String miType = this.helper.getValueType(mType.itemDescriptor());
                this.writer.formatln("public _Builder %s(%s key, %s value);", new Object[]{field.adder(), mkType, miType});
                this.writer.newline();
                break;
            }
            case SET: 
            case LIST: {
                PContainer lType = (PContainer)field.field().getDescriptor();
                String liType = this.helper.getValueType(lType.itemDescriptor());
                if (lType.itemDescriptor().getType() == PType.LIST || lType.itemDescriptor().getType() == PType.SET || lType.itemDescriptor().getType() == PType.MAP) {
                    this.writer.formatln("public _Builder %s(%s... values);", new Object[]{field.adder(), liType});
                } else {
                    this.writer.formatln("public _Builder %s(%s... values);", new Object[]{field.adder(), liType});
                }
                this.writer.newline();
                break;
            }
            default: {
                throw new GeneratorException("Unexpected field type: " + field.type());
            }
        }
    }

    private void appendBuilderSetter(JField field) {
        String reason;
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.commentRaw("Set the <code>" + field.name() + "</code> field value.");
        if (field.hasComment()) {
            comment.paragraph().comment(field.comment());
        }
        comment.newline();
        if (!field.isVoid()) {
            comment.param_("value", "The new value");
        }
        comment.return_("The builder");
        if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
            comment.deprecated_(reason);
        }
        comment.finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
        if (field.isVoid()) {
            this.writer.formatln("public _Builder %s();", new Object[]{field.setter()});
        } else {
            this.writer.formatln("public _Builder %s(%s value);", new Object[]{field.setter(), this.helper.getSetterParamType(field.field().getDescriptor())});
        }
        this.writer.newline();
        if (field.isPrimitiveJavaValue() && !field.isVoid()) {
            comment = new BlockCommentBuilder(this.writer);
            comment.commentRaw("Set the <code>" + field.name() + "</code> field value.");
            if (field.hasComment()) {
                comment.paragraph().comment(field.comment());
            }
            comment.newline();
            if (!field.isVoid()) {
                comment.param_("value", "The new value");
            }
            comment.return_("The builder");
            if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
                comment.deprecated_(reason);
            }
            comment.finish();
            if (JAnnotation.isDeprecated(field)) {
                this.writer.appendln((CharSequence)"@Deprecated");
            }
            this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
            this.writer.formatln("public _Builder %s(%s value);", new Object[]{field.setter(), field.valueType()}).newline();
        }
    }

    private void appendBuilderResetter(JField field) {
        String reason;
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.commentRaw("Clear the <code>" + field.name() + "</code> field value.");
        if (field.hasComment()) {
            comment.paragraph().comment(field.comment());
        }
        comment.newline();
        comment.return_("The builder");
        if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
            comment.deprecated_(reason);
        }
        comment.finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
        this.writer.formatln("public _Builder %s();", new Object[]{field.resetter()});
        this.writer.newline();
    }

    private void appendDescriptor(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@SuppressWarnings(\"unchecked\")").formatln("%s<?> kDescriptor =", new Object[]{PInterfaceDescriptor.class.getName()}).formatln("        new %s<>(\"%s\", \"%s\", _Field.values()", new Object[]{PInterfaceDescriptor.class.getName(), message.descriptor().getProgramName(), message.descriptor().getName()});
        this.writer.begin("                ");
        for (PMessageDescriptor possibleType : ((PInterfaceDescriptor)message.descriptor()).getPossibleTypes()) {
            this.writer.append((CharSequence)",").appendln();
            this.writer.append((CharSequence)this.helper.getProviderName((PDescriptor)possibleType));
        }
        this.writer.end().append((CharSequence)");");
    }

    private void appendFieldEnum(JMessage<?> message) {
        this.writer.formatln("enum _Field implements %s {", new Object[]{PField.class.getName()}).begin();
        for (JField field : message.declaredOrderFields()) {
            String arguments = "null";
            String argsType = field.field().getAnnotationValue(PAnnotation.ARGUMENTS_TYPE);
            if (argsType != null) {
                try {
                    PMessageDescriptor descriptor = this.helper.getRegistry().requireMessageType(TypeReference.parseType((String)message.descriptor().getProgramName(), (String)argsType));
                    if (descriptor.getVariant() != PMessageVariant.STRUCT) {
                        throw new GeneratorException("Bad arguments type " + descriptor.getQualifiedName() + " for field " + field.name() + " in " + message.descriptor().getQualifiedName() + ", not a struct.");
                    }
                    arguments = this.helper.getProviderName((PDescriptor)descriptor);
                }
                catch (IllegalArgumentException e) {
                    throw new GeneratorException("No such arguments type available " + field.field().getAnnotationValue(PAnnotation.ARGUMENTS_TYPE) + " for field " + field.name() + " in " + message.descriptor().getQualifiedName());
                }
            }
            this.writer.formatln("%s(%d, %s.%s, \"%s\", \"%s\", %s, %s, ", new Object[]{field.fieldEnum(), field.id(), PRequirement.class.getName(), field.field().getRequirement().toString(), field.name(), field.field().getPojoName(), field.getProvider(), arguments});
            if (field.field().hasDefaultValue()) {
                this.writer.format("new %s<>(", new Object[]{PDefaultValueProvider.class.getName()});
                ValueBuilder values = new ValueBuilder(this.writer, this.helper);
                values.appendTypedValue(field.field().getDefaultValue(), field.field().getDescriptor());
                this.writer.append((CharSequence)")");
            } else {
                this.writer.append((CharSequence)"null");
            }
            this.writer.append((CharSequence)"),");
        }
        this.writer.appendln((CharSequence)";").newline();
        this.writer.appendln((CharSequence)"private final int mId;").formatln("private final %s mRequired;", new Object[]{PRequirement.class.getName()}).appendln((CharSequence)"private final String mName;").appendln((CharSequence)"private final String mPojoName;").formatln("private final %s mTypeProvider;", new Object[]{PDescriptorProvider.class.getName()}).formatln("private final %s mArgumentsProvider;", new Object[]{PStructDescriptorProvider.class.getName()}).formatln("private final %s<?> mDefaultValue;", new Object[]{PValueProvider.class.getName()}).newline();
        this.writer.formatln("_Field(int id, %s required, String name, String pojoName, %s typeProvider, %s argumentsProvider, %s<?> defaultValue) {", new Object[]{PRequirement.class.getName(), PDescriptorProvider.class.getName(), PStructDescriptorProvider.class.getName(), PValueProvider.class.getName()}).begin().appendln((CharSequence)"mId = id;").appendln((CharSequence)"mRequired = required;").appendln((CharSequence)"mName = name;").appendln((CharSequence)"mPojoName = pojoName;").appendln((CharSequence)"mTypeProvider = typeProvider;").appendln((CharSequence)"mArgumentsProvider = argumentsProvider;").appendln((CharSequence)"mDefaultValue = defaultValue;").end().appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int getId() { return mId; }").newline();
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull").appendln((CharSequence)"@Override").formatln("public %s getRequirement() { return mRequired; }", new Object[]{PRequirement.class.getName()}).newline();
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull").appendln((CharSequence)"@Override").formatln("public %s getDescriptor() { return mTypeProvider.descriptor(); }", new Object[]{PDescriptor.class.getName()}).newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"@javax.annotation.Nullable").formatln("public %s getArgumentsType() { return mArgumentsProvider == null ? null : mArgumentsProvider.descriptor(); }", new Object[]{PStructDescriptor.class.getName()}).newline();
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull").appendln((CharSequence)"@Override").appendln((CharSequence)"public String getName() { return mName; }").newline();
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull").appendln((CharSequence)"@Override").appendln((CharSequence)"public String getPojoName() { return mPojoName; }").newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean hasDefaultValue() { return mDefaultValue != null; }").newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"@javax.annotation.Nullable").appendln((CharSequence)"public Object getDefaultValue() {").appendln((CharSequence)"    return hasDefaultValue() ? mDefaultValue.get() : null;").appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"@javax.annotation.Nonnull").appendln((CharSequence)"@SuppressWarnings(\"unchecked\")").formatln("public %s onMessageType() {", new Object[]{PMessageDescriptor.class.getName()}).appendln((CharSequence)"    return kDescriptor;").appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String toString() {").formatln("    return %s.asString(this);", new Object[]{PField.class.getName()}).appendln('}').newline();
        new BlockCommentBuilder(this.writer).param_("id", "Field name").return_("The identified field or null").finish();
        this.writer.appendln((CharSequence)"public static _Field findById(int id) {").begin().appendln((CharSequence)"switch (id) {").begin();
        for (JField field : message.declaredOrderFields()) {
            this.writer.formatln("case %d: return _Field.%s;", new Object[]{field.id(), field.fieldEnum()});
        }
        this.writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}').newline();
        new BlockCommentBuilder(this.writer).param_("name", "Field name").return_("The named field or null").finish();
        this.writer.appendln((CharSequence)"public static _Field findByName(String name) {").begin().appendln((CharSequence)"if (name == null) return null;").appendln((CharSequence)"switch (name) {").begin();
        for (JField field : message.declaredOrderFields()) {
            this.writer.formatln("case \"%s\": return _Field.%s;", new Object[]{field.name(), field.fieldEnum()});
        }
        this.writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}').newline();
        new BlockCommentBuilder(this.writer).param_("name", "Field POJO name").return_("The named field or null").finish();
        this.writer.appendln((CharSequence)"public static _Field findByPojoName(String name) {").begin().appendln((CharSequence)"if (name == null) return null;").appendln((CharSequence)"switch (name) {").begin();
        for (JField field : message.declaredOrderFields()) {
            this.writer.formatln("case \"%s\": return _Field.%s;", new Object[]{field.field().getPojoName(), field.fieldEnum()});
        }
        this.writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}').newline();
        new BlockCommentBuilder(this.writer).param_("id", "Field name").return_("The identified field").throws_("IllegalArgumentException", "If no such field").finish();
        this.writer.appendln((CharSequence)"public static _Field fieldForId(int id) {").begin().appendln((CharSequence)"_Field field = findById(id);").appendln((CharSequence)"if (field == null) {").formatln("    throw new IllegalArgumentException(\"No such field id \" + id + \" in %s\");", new Object[]{message.descriptor().getQualifiedName()}).appendln((CharSequence)"}").appendln((CharSequence)"return field;").end().appendln('}').newline();
        new BlockCommentBuilder(this.writer).param_("name", "Field name").return_("The named field").throws_("IllegalArgumentException", "If no such field").finish();
        this.writer.appendln((CharSequence)"public static _Field fieldForName(String name) {").begin().appendln((CharSequence)"if (name == null) {").appendln((CharSequence)"    throw new IllegalArgumentException(\"Null name argument\");").appendln((CharSequence)"}").appendln((CharSequence)"_Field field = findByName(name);").appendln((CharSequence)"if (field == null) {").formatln("    throw new IllegalArgumentException(\"No such field \\\"\" + name + \"\\\" in %s\");", new Object[]{message.descriptor().getQualifiedName()}).appendln((CharSequence)"}").appendln((CharSequence)"return field;").end().appendln('}').newline();
        new BlockCommentBuilder(this.writer).param_("name", "Field POJO name").return_("The named field").throws_("IllegalArgumentException", "If no such field").finish();
        this.writer.appendln((CharSequence)"public static _Field fieldForPojoName(String name) {").begin().appendln((CharSequence)"if (name == null) {").appendln((CharSequence)"    throw new IllegalArgumentException(\"Null name argument\");").appendln((CharSequence)"}").appendln((CharSequence)"_Field field = findByPojoName(name);").appendln((CharSequence)"if (field == null) {").formatln("    throw new IllegalArgumentException(\"No such field \\\"\" + name + \"\\\" in %s\");", new Object[]{message.descriptor().getQualifiedName()}).appendln((CharSequence)"}").appendln((CharSequence)"return field;").end().appendln('}');
        this.writer.end().appendln((CharSequence)"}").newline();
    }
}

