/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages.extras;

import java.util.Optional;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CInterfaceDescriptor;
import net.morimekta.providence.reflect.contained.CMessageDescriptor;
import net.morimekta.util.io.IndentedPrintWriter;

public class UnionOfFormatter
implements MessageMemberFormatter {
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public UnionOfFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    @Override
    public void appendMethods(JMessage<?> message) throws GeneratorException {
        CInterfaceDescriptor implementing;
        if (!message.isUnion()) {
            return;
        }
        CMessageDescriptor cmd = (CMessageDescriptor)message.descriptor();
        try {
            implementing = cmd.getImplementing();
        }
        catch (Exception e) {
            throw new GeneratorException("Implementing class for " + message.descriptor().getQualifiedName() + " does not exist: " + e.getMessage(), (Throwable)e);
        }
        if (implementing != null) {
            JMessage impl = new JMessage(implementing, this.helper);
            String implName = JUtils.getClassName(implementing);
            String implType = this.helper.getFieldType((PDescriptor)implementing);
            BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
            comment.return_("The union field as implemented type.");
            comment.finish();
            this.writer.formatln("public %s as%s() {", new Object[]{implType, implName}).begin().appendln((CharSequence)"switch (unionField()) {").begin();
            for (JField field : message.numericalOrderFields()) {
                this.writer.formatln("case %s: return %s();", new Object[]{field.fieldEnum(), field.getter()});
            }
            this.writer.appendln((CharSequence)"default: throw new IllegalStateException(\"Impossible\");").end().appendln((CharSequence)"}").end().appendln((CharSequence)"}");
            for (JField field : impl.declaredOrderFields()) {
                this.writer.newline();
                boolean isDeprecated = false;
                BlockCommentBuilder getComment = new BlockCommentBuilder(this.writer);
                if (field.hasComment()) {
                    getComment.comment(field.comment());
                    getComment.newline();
                }
                getComment.return_("The " + field.name() + " value.");
                String deprecatedReason = field.field().getAnnotationValue(PAnnotation.DEPRECATED);
                if (deprecatedReason != null) {
                    if (deprecatedReason.trim().length() > 0) {
                        getComment.deprecated_(deprecatedReason);
                    } else {
                        deprecatedReason = null;
                    }
                    isDeprecated = true;
                }
                getComment.finish();
                if (isDeprecated) {
                    this.writer.appendln((CharSequence)"@Deprecated");
                }
                if (field.alwaysPresent() && !field.isPrimitiveJavaValue()) {
                    this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
                }
                this.writer.formatln("public %s %s() {", new Object[]{field.valueType(), field.getter()}).formatln("    return as%s().%s();", new Object[]{implName, field.getter()}).appendln((CharSequence)"}");
                this.writer.newline();
                if (!field.alwaysPresent()) {
                    getComment = new BlockCommentBuilder(this.writer);
                    if (field.hasComment()) {
                        getComment.comment(field.comment());
                        getComment.newline();
                    }
                    getComment.return_("Optional " + field.name() + " value.");
                    deprecatedReason = field.field().getAnnotationValue(PAnnotation.DEPRECATED);
                    if (deprecatedReason != null) {
                        if (deprecatedReason.trim().length() > 0) {
                            getComment.deprecated_(deprecatedReason);
                        } else {
                            deprecatedReason = null;
                        }
                        isDeprecated = true;
                    }
                    getComment.finish();
                    this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
                    this.writer.formatln("public %s<%s> %s() {", new Object[]{Optional.class.getName(), field.fieldType(), field.optional()}).formatln("    return as%s().%s();", new Object[]{implName, field.optional()}).appendln((CharSequence)"}");
                    this.writer.newline();
                }
                BlockCommentBuilder hasComment = new BlockCommentBuilder(this.writer);
                hasComment.return_("If " + field.name() + " is present.");
                if (deprecatedReason != null) {
                    hasComment.deprecated_(deprecatedReason);
                }
                hasComment.finish();
                if (isDeprecated) {
                    this.writer.appendln((CharSequence)"@Deprecated");
                }
                this.writer.formatln("public boolean %s() {", new Object[]{field.presence()}).formatln("    return as%s().%s();", new Object[]{implName, field.presence()}).appendln((CharSequence)"}");
                if (!field.container()) continue;
                this.writer.newline();
                BlockCommentBuilder numComment = new BlockCommentBuilder(this.writer);
                numComment.return_("Number of entries in " + field.name() + ".");
                if (deprecatedReason != null) {
                    numComment.deprecated_(deprecatedReason);
                }
                numComment.finish();
                if (isDeprecated) {
                    this.writer.appendln((CharSequence)"@Deprecated");
                }
                this.writer.formatln("public int %s() {", new Object[]{field.counter()}).formatln("    return as%s().%s();", new Object[]{implName, field.counter()}).appendln((CharSequence)"}");
            }
            this.writer.newline();
        }
    }
}

