/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.ProgramRegistry;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.util.Binary;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableMap;
import net.morimekta.util.collect.UnmodifiableSet;
import net.morimekta.util.collect.UnmodifiableSortedMap;
import net.morimekta.util.collect.UnmodifiableSortedSet;

public class JHelper {
    public static final String packageSeparator = ".";
    private final ProgramRegistry mRegistry;

    public JHelper(ProgramRegistry registry) {
        this.mRegistry = registry;
    }

    public ProgramRegistry getRegistry() {
        return this.mRegistry;
    }

    public String getJavaPackage(PDeclaredDescriptor<?> type) throws GeneratorException {
        CProgram document = ((ProgramRegistry)this.mRegistry.getRegistry(type.getProgramName()).orElseThrow(() -> new IllegalStateException("No registry for program " + type.getProgramName()))).getProgram();
        return JUtils.getJavaPackage(document);
    }

    public String getJavaPackage(PService type) throws GeneratorException {
        CProgram document = ((ProgramRegistry)this.mRegistry.getRegistry(type.getProgramName()).orElseThrow(() -> new IllegalStateException("No registry for program " + type.getProgramName()))).getProgram();
        return JUtils.getJavaPackage(document);
    }

    public String getJavaPackage(CProgram document) throws GeneratorException {
        return JUtils.getJavaPackage(document);
    }

    public String getInstanceClassName(CField field) throws GeneratorException {
        switch (field.getType()) {
            case VOID: {
                return Void.class.getSimpleName();
            }
            case BOOL: {
                return Boolean.class.getSimpleName();
            }
            case BYTE: {
                return Byte.class.getSimpleName();
            }
            case I16: {
                return Short.class.getSimpleName();
            }
            case I32: {
                return Integer.class.getSimpleName();
            }
            case I64: {
                return Long.class.getSimpleName();
            }
            case DOUBLE: {
                return Double.class.getSimpleName();
            }
            case STRING: {
                return String.class.getSimpleName();
            }
            case BINARY: {
                return Binary.class.getName();
            }
            case MAP: {
                PContainer.Type ct = JAnnotation.containerType(field);
                if (ct == PContainer.Type.SORTED) {
                    return UnmodifiableSortedMap.class.getName();
                }
                return UnmodifiableMap.class.getName();
            }
            case SET: {
                PContainer.Type ct = JAnnotation.containerType(field);
                if (ct == PContainer.Type.SORTED) {
                    return UnmodifiableSortedSet.class.getName();
                }
                return UnmodifiableSet.class.getName();
            }
            case LIST: {
                return UnmodifiableList.class.getName();
            }
            case ENUM: 
            case MESSAGE: {
                PDeclaredDescriptor dt = (PDeclaredDescriptor)field.getDescriptor();
                return this.getJavaPackage(dt) + packageSeparator + JUtils.getClassName(dt);
            }
        }
        throw new IllegalArgumentException("Unhandled type group" + field.getType());
    }

    public String getConstantsClassName(CProgram document) {
        return JUtils.camelCase(document.getProgramName()) + "_Constants";
    }

    public String getHazelcastFactoryClassName(CProgram document) {
        return JUtils.camelCase(document.getProgramName()) + "_Factory";
    }

    public String getValueType(PDescriptor type) throws GeneratorException {
        switch (type.getType()) {
            case VOID: {
                return Void.TYPE.getSimpleName();
            }
            case BOOL: {
                return Boolean.TYPE.getSimpleName();
            }
            case BYTE: {
                return Byte.TYPE.getSimpleName();
            }
            case I16: {
                return Short.TYPE.getSimpleName();
            }
            case I32: {
                return Integer.TYPE.getSimpleName();
            }
            case I64: {
                return Long.TYPE.getSimpleName();
            }
            case DOUBLE: {
                return Double.TYPE.getSimpleName();
            }
            case STRING: {
                return String.class.getSimpleName();
            }
            case BINARY: {
                return Binary.class.getName();
            }
            case MAP: {
                PMap mType = (PMap)type;
                return String.format(Locale.US, "%s<%s,%s>", Map.class.getName(), this.getFieldType(mType.keyDescriptor()), this.getFieldType(mType.itemDescriptor()));
            }
            case SET: {
                PSet sType = (PSet)type;
                return String.format(Locale.US, "%s<%s>", Set.class.getName(), this.getFieldType(sType.itemDescriptor()));
            }
            case LIST: {
                PList lType = (PList)type;
                return String.format(Locale.US, "%s<%s>", List.class.getName(), this.getFieldType(lType.itemDescriptor()));
            }
            case ENUM: 
            case MESSAGE: {
                PDeclaredDescriptor dt = (PDeclaredDescriptor)type;
                return this.getJavaPackage(dt) + packageSeparator + JUtils.getClassName((PDeclaredDescriptor)type);
            }
        }
        throw new IllegalArgumentException("Unhandled type group" + type.getType());
    }

    public String getSetterParamType(PDescriptor descriptor) {
        if (descriptor.getType() == PType.MESSAGE) {
            return this.getJavaPackage((PDeclaredDescriptor<?>)((PMessageDescriptor)descriptor)) + packageSeparator + JUtils.getInterfaceName((PMessageDescriptor)descriptor);
        }
        if (descriptor.getType() == PType.LIST || descriptor.getType() == PType.SET) {
            PContainer container = (PContainer)descriptor;
            PDescriptor iType = container.itemDescriptor();
            return Collection.class.getName() + "<" + this.getFieldType(iType) + ">";
        }
        return this.getFieldType(descriptor);
    }

    public String getFieldType(PDescriptor type) throws GeneratorException {
        switch (type.getType()) {
            case BOOL: {
                return Boolean.class.getSimpleName();
            }
            case BYTE: {
                return Byte.class.getSimpleName();
            }
            case I16: {
                return Short.class.getSimpleName();
            }
            case I32: {
                return Integer.class.getSimpleName();
            }
            case I64: {
                return Long.class.getSimpleName();
            }
            case DOUBLE: {
                return Double.class.getSimpleName();
            }
            case STRING: {
                return String.class.getSimpleName();
            }
            case BINARY: {
                return Binary.class.getName();
            }
            case MAP: {
                PMap mType = (PMap)type;
                return String.format(Locale.US, "%s<%s,%s>", Map.class.getName(), this.getFieldType(mType.keyDescriptor()), this.getFieldType(mType.itemDescriptor()));
            }
            case SET: {
                PSet sType = (PSet)type;
                return String.format(Locale.US, "%s<%s>", Set.class.getName(), this.getFieldType(sType.itemDescriptor()));
            }
            case LIST: {
                PList lType = (PList)type;
                return String.format(Locale.US, "%s<%s>", List.class.getName(), this.getFieldType(lType.itemDescriptor()));
            }
            case ENUM: 
            case MESSAGE: {
                PDeclaredDescriptor dt = (PDeclaredDescriptor)type;
                return this.getJavaPackage(dt) + packageSeparator + JUtils.getClassName(dt);
            }
        }
        throw new IllegalArgumentException("Unhandled field type group " + type.getType());
    }

    public Object getDefaultValue(PField field) {
        if (field.hasDefaultValue()) {
            return field.getDefaultValue();
        }
        return field.getDescriptor().getDefaultValue();
    }

    public String getProviderName(PDescriptor type) throws GeneratorException {
        switch (type.getType()) {
            case ENUM: 
            case MESSAGE: {
                return String.format(Locale.US, "%s.provider()", this.getFieldType(type));
            }
            case LIST: {
                PList lType = (PList)type;
                return String.format(Locale.US, "%s.provider(%s)", PList.class.getName(), this.getProviderName(lType.itemDescriptor()));
            }
            case SET: {
                PSet sType = (PSet)type;
                return String.format(Locale.US, "%s.provider(%s)", PSet.class.getName(), this.getProviderName(sType.itemDescriptor()));
            }
            case MAP: {
                PMap mType = (PMap)type;
                return String.format(Locale.US, "%s.provider(%s,%s)", PMap.class.getName(), this.getProviderName(mType.keyDescriptor()), this.getProviderName(mType.itemDescriptor()));
            }
        }
        if (!(type instanceof PPrimitive)) {
            throw new IllegalArgumentException("Unhandled type group " + type.getType());
        }
        return String.format(Locale.US, "%s.%s.provider()", PPrimitive.class.getName(), type.getName().toUpperCase(Locale.US));
    }
}

