/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages;

import java.util.Collection;
import java.util.Locale;
import net.morimekta.providence.PException;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PInterfaceDescriptor;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.serializer.json.JsonCompactible;
import net.morimekta.providence.serializer.json.JsonCompactibleDescriptor;
import net.morimekta.providence.types.TypeReference;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.io.IndentedPrintWriter;

public class CoreOverridesFormatter
implements MessageMemberFormatter {
    public static final String UNION_FIELD = "tUnionField";
    protected final IndentedPrintWriter writer;
    private final JHelper helper;

    public CoreOverridesFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.helper = helper;
        this.writer = writer;
    }

    @Override
    public Collection<String> getExtraImplements(JMessage<?> message) throws GeneratorException {
        UnmodifiableList.Builder builder = UnmodifiableList.builder();
        builder.add((Object)String.format(Locale.US, "%s<%s>", message.isUnion() ? PUnion.class.getName() : PMessage.class.getName(), message.instanceType()));
        if (message.isException()) {
            builder.add((Object)PException.class.getName());
        }
        if (message.jsonCompactible()) {
            builder.add((Object)JsonCompactible.class.getName());
        }
        return builder.build();
    }

    @Override
    public void appendFields(JMessage<?> message) throws GeneratorException {
        if (message.isUnion()) {
            this.writer.formatln("private transient final _Field %s;", new Object[]{UNION_FIELD}).newline();
        }
    }

    public void appendMethods(JMessage message) {
        this.appendPresence(message);
        this.appendGetter(message);
        this.appendJsonCompact(message);
        if (message.isException()) {
            this.appendPExceptionOverrides();
            this.appendExceptionOverrides(message);
        }
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean unionFieldIsSet() {").formatln("    return %s != null;", new Object[]{UNION_FIELD}).appendln('}').newline();
            this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"@javax.annotation.Nonnull").appendln((CharSequence)"public _Field unionField() {").formatln("    if (%s == null) throw new IllegalStateException(\"No union field set in %s\");", new Object[]{UNION_FIELD, message.descriptor().getQualifiedName()}).formatln("    return %s;", new Object[]{UNION_FIELD}).appendln('}').newline();
        }
    }

    @Override
    public void appendExtraProperties(JMessage<?> message) throws GeneratorException {
        this.appendFieldEnum(message);
        this.appendDescriptor(message);
    }

    private void appendPExceptionOverrides() {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String origGetMessage() {").appendln((CharSequence)"    return super.getMessage();").appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String origGetLocalizedMessage() {").appendln((CharSequence)"    return super.getLocalizedMessage();").appendln('}').newline();
    }

    private void appendExceptionOverrides(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").formatln("public %s initCause(Throwable cause) {", new Object[]{message.instanceType()}).formatln("    return (%s) super.initCause(cause);", new Object[]{message.instanceType()}).appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").formatln("public %s fillInStackTrace() {", new Object[]{message.instanceType()}).formatln("    return (%s) super.fillInStackTrace();", new Object[]{message.instanceType()}).appendln('}').newline();
    }

    private void appendDescriptor(JMessage<?> message) throws GeneratorException {
        String typeClass = message.getDescriptorClass();
        String providerClass = message.getProviderClass();
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull").formatln("public static %s<%s> provider() {", new Object[]{providerClass, message.instanceType()}).begin().formatln("return new _Provider();", new Object[0]).end().appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"@javax.annotation.Nonnull").formatln("public %s<%s> descriptor() {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"return kDescriptor;").end().appendln('}').newline();
        this.writer.formatln("public static final %s<%s> kDescriptor;", new Object[]{typeClass, message.instanceType()}).newline();
        String jsonCompactibleDescriptor = "";
        if (message.jsonCompactible()) {
            jsonCompactibleDescriptor = " implements " + JsonCompactibleDescriptor.class.getName();
        }
        this.writer.formatln("private static final class _Descriptor", new Object[0]).formatln("        extends %s<%s>%s {", new Object[]{typeClass, message.instanceType(), jsonCompactibleDescriptor}).begin().appendln((CharSequence)"public _Descriptor() {").begin();
        this.writer.formatln("super(\"%s\", \"%s\", _Builder::new, %b);", new Object[]{message.descriptor().getProgramName(), message.descriptor().getName(), message.descriptor().isSimple()});
        this.writer.end().appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"@javax.annotation.Nonnull").appendln((CharSequence)"public _Field[] getFields() {").appendln((CharSequence)"    return _Field.values();").appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"@javax.annotation.Nullable").appendln((CharSequence)"public _Field findFieldByName(String name) {").appendln((CharSequence)"    return _Field.findByName(name);").appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"@javax.annotation.Nullable").appendln((CharSequence)"public _Field findFieldById(int id) {").appendln((CharSequence)"    return _Field.findById(id);").appendln('}');
        if (message.descriptor().getImplementing() != null) {
            String ifName = this.helper.getValueType((PDescriptor)message.descriptor().getImplementing());
            this.writer.newline().appendln((CharSequence)"@Override").formatln("public %s getImplementing() {", new Object[]{PInterfaceDescriptor.class.getName()}).formatln("    return %s.kDescriptor;", new Object[]{ifName}).appendln('}');
        }
        this.writer.end().appendln('}').newline();
        this.writer.formatln("static {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"kDescriptor = new _Descriptor();").end().appendln('}').newline();
        this.writer.formatln("private static final class _Provider extends %s<%s> {", new Object[]{providerClass, message.instanceType()}).begin().appendln((CharSequence)"@Override").formatln("public %s<%s> descriptor() {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"return kDescriptor;").end().appendln('}').end().appendln((CharSequence)"}").newline();
    }

    private void appendFieldEnum(JMessage<?> message) throws GeneratorException {
        this.writer.formatln("public enum _Field implements %s<%s> {", new Object[]{PField.class.getName(), message.instanceType()}).begin();
        for (JField field : message.numericalOrderFields()) {
            String defValue = "null";
            if (field.field().hasDefaultValue()) {
                defValue = String.format(Locale.US, "new %s<>(%s)", PDefaultValueProvider.class.getName(), field.kDefault());
            }
            String arguments = "null";
            String argsType = field.field().getAnnotationValue(PAnnotation.ARGUMENTS_TYPE);
            if (argsType != null) {
                try {
                    PMessageDescriptor descriptor = this.helper.getRegistry().requireMessageType(TypeReference.parseType((String)message.descriptor().getProgramName(), (String)argsType));
                    if (descriptor.getVariant() != PMessageVariant.STRUCT) {
                        throw new GeneratorException("Bad arguments type " + descriptor.getQualifiedName() + " for field " + field.name() + " in " + message.descriptor().getQualifiedName() + ", not a struct.");
                    }
                    arguments = this.helper.getProviderName((PDescriptor)descriptor);
                }
                catch (IllegalArgumentException e) {
                    throw new GeneratorException("No such arguments type available " + field.field().getAnnotationValue(PAnnotation.ARGUMENTS_TYPE) + " for field " + field.name() + " in " + message.descriptor().getQualifiedName());
                }
            }
            this.writer.formatln("%s(%d, %s.%s, \"%s\", %s, %s, %s),", new Object[]{field.fieldEnum(), field.id(), PRequirement.class.getName(), field.field().getRequirement().name(), field.name(), field.getProvider(), arguments, defValue});
        }
        this.writer.appendln(';').newline();
        this.writer.appendln((CharSequence)"private final int mId;").formatln("private final %s mRequired;", new Object[]{PRequirement.class.getName()}).appendln((CharSequence)"private final String mName;").formatln("private final %s mTypeProvider;", new Object[]{PDescriptorProvider.class.getName()}).formatln("private final %s mArgumentsProvider;", new Object[]{PStructDescriptorProvider.class.getName()}).formatln("private final %s<?> mDefaultValue;", new Object[]{PValueProvider.class.getName()}).newline();
        this.writer.formatln("_Field(int id, %s required, String name, %s typeProvider, %s argumentsProvider, %s<?> defaultValue) {", new Object[]{PRequirement.class.getName(), PDescriptorProvider.class.getName(), PStructDescriptorProvider.class.getName(), PValueProvider.class.getName()}).begin().appendln((CharSequence)"mId = id;").appendln((CharSequence)"mRequired = required;").appendln((CharSequence)"mName = name;").appendln((CharSequence)"mTypeProvider = typeProvider;").appendln((CharSequence)"mArgumentsProvider = argumentsProvider;").appendln((CharSequence)"mDefaultValue = defaultValue;").end().appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int getId() { return mId; }").newline();
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull").appendln((CharSequence)"@Override").formatln("public %s getRequirement() { return mRequired; }", new Object[]{PRequirement.class.getName()}).newline();
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull").appendln((CharSequence)"@Override").formatln("public %s getDescriptor() { return mTypeProvider.descriptor(); }", new Object[]{PDescriptor.class.getName()}).newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"@javax.annotation.Nullable").formatln("public %s getArgumentsType() { return mArgumentsProvider == null ? null : mArgumentsProvider.descriptor(); }", new Object[]{PStructDescriptor.class.getName()}).newline();
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull").appendln((CharSequence)"@Override").appendln((CharSequence)"public String getName() { return mName; }").newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean hasDefaultValue() { return mDefaultValue != null; }").newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"@javax.annotation.Nullable").appendln((CharSequence)"public Object getDefaultValue() {").appendln((CharSequence)"    return hasDefaultValue() ? mDefaultValue.get() : null;").appendln('}').newline();
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String toString() {").formatln("    return %s.asString(this);", new Object[]{PField.class.getName()}).appendln('}').newline();
        new BlockCommentBuilder(this.writer).param_("id", "Field name").return_("The identified field or null").finish();
        this.writer.appendln((CharSequence)"public static _Field findById(int id) {").begin().appendln((CharSequence)"switch (id) {").begin();
        for (JField field : message.declaredOrderFields()) {
            this.writer.formatln("case %d: return _Field.%s;", new Object[]{field.id(), field.fieldEnum()});
        }
        this.writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}').newline();
        new BlockCommentBuilder(this.writer).param_("name", "Field name").return_("The named field or null").finish();
        this.writer.appendln((CharSequence)"public static _Field findByName(String name) {").begin().appendln((CharSequence)"if (name == null) return null;").appendln((CharSequence)"switch (name) {").begin();
        for (JField field : message.declaredOrderFields()) {
            this.writer.formatln("case \"%s\": return _Field.%s;", new Object[]{field.name(), field.fieldEnum()});
        }
        this.writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}').newline();
        new BlockCommentBuilder(this.writer).param_("id", "Field name").return_("The identified field").throws_("IllegalArgumentException", "If no such field").finish();
        this.writer.appendln((CharSequence)"public static _Field fieldForId(int id) {").begin().appendln((CharSequence)"_Field field = findById(id);").appendln((CharSequence)"if (field == null) {").formatln("    throw new IllegalArgumentException(\"No such field id \" + id + \" in %s\");", new Object[]{message.descriptor().getQualifiedName()}).appendln((CharSequence)"}").appendln((CharSequence)"return field;").end().appendln('}').newline();
        new BlockCommentBuilder(this.writer).param_("name", "Field name").return_("The named field").throws_("IllegalArgumentException", "If no such field").finish();
        this.writer.appendln((CharSequence)"public static _Field fieldForName(String name) {").begin().appendln((CharSequence)"if (name == null) {").appendln((CharSequence)"    throw new IllegalArgumentException(\"Null name argument\");").appendln((CharSequence)"}").appendln((CharSequence)"_Field field = findByName(name);").appendln((CharSequence)"if (field == null) {").formatln("    throw new IllegalArgumentException(\"No such field \\\"\" + name + \"\\\" in %s\");", new Object[]{message.descriptor().getQualifiedName()}).appendln((CharSequence)"}").appendln((CharSequence)"return field;").end().appendln('}').newline();
        this.writer.end().appendln('}').newline();
    }

    private void appendJsonCompact(JMessage<?> message) {
        if (!message.jsonCompactible()) {
            return;
        }
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean jsonCompact() {").begin();
        boolean hasCheck = false;
        boolean hasMissingVar = false;
        for (JField field : message.numericalOrderFields()) {
            if (!field.alwaysPresent()) {
                if (!hasMissingVar) {
                    this.writer.appendln((CharSequence)"boolean missing = false;");
                }
                hasMissingVar = true;
                hasCheck = true;
                this.writer.formatln("if (%s()) {", new Object[]{field.presence()}).appendln((CharSequence)"    if (missing) return false;").appendln((CharSequence)"} else {").appendln((CharSequence)"    missing = true;").appendln('}');
                continue;
            }
            if (!hasCheck) continue;
            this.writer.appendln((CharSequence)"if (missing) return false;");
            hasCheck = false;
        }
        this.writer.appendln((CharSequence)"return true;").end().appendln('}').newline();
    }

    private void appendGetter(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"@SuppressWarnings(\"unchecked\")").appendln((CharSequence)"public <T> T get(int key) {").begin().appendln((CharSequence)"switch(key) {").begin();
        for (JField field : message.numericalOrderFields()) {
            if (field.isVoid()) {
                this.writer.formatln("case %d: return %s() ? (T) Boolean.TRUE : null;", new Object[]{field.id(), field.presence()});
                continue;
            }
            if (field.isPrimitiveJavaValue()) {
                if (field.alwaysPresent()) {
                    this.writer.formatln("case %d: return (T) (%s) %s;", new Object[]{field.id(), field.instanceType(), field.member()});
                    continue;
                }
                this.writer.formatln("case %d: return (T) %s;", new Object[]{field.id(), field.member()});
                continue;
            }
            this.writer.formatln("case %d: return (T) %s;", new Object[]{field.id(), field.member()});
        }
        this.writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
    }

    private void appendPresence(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean has(int key) {").begin().appendln((CharSequence)"switch(key) {").begin();
        if (message.isUnion()) {
            for (JField field : message.numericalOrderFields()) {
                this.writer.formatln("case %s: return %s == _Field.%s;", new Object[]{field.id(), UNION_FIELD, field.fieldEnum()});
            }
        } else {
            for (JField field : message.numericalOrderFields()) {
                if (field.alwaysPresent()) {
                    this.writer.formatln("case %d: return true;", new Object[]{field.id()});
                    continue;
                }
                this.writer.formatln("case %d: return %s != null;", new Object[]{field.id(), field.member()});
            }
        }
        this.writer.appendln((CharSequence)"default: return false;").end().appendln('}').end().appendln('}').newline();
    }
}

