/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PInterfaceDescriptor;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.generator.Generator;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.GeneratorOptions;
import net.morimekta.providence.generator.format.java.JavaConstantsFormatter;
import net.morimekta.providence.generator.format.java.JavaEnumFormatter;
import net.morimekta.providence.generator.format.java.JavaMessageFormatter;
import net.morimekta.providence.generator.format.java.JavaOptions;
import net.morimekta.providence.generator.format.java.JavaServiceFormatter;
import net.morimekta.providence.generator.format.java.messages.BaseInterfaceFormatter;
import net.morimekta.providence.generator.format.java.program.extras.HazelcastPortableProgramFormatter;
import net.morimekta.providence.generator.format.java.shared.BaseEnumFormatter;
import net.morimekta.providence.generator.format.java.shared.BaseMessageFormatter;
import net.morimekta.providence.generator.format.java.shared.BaseProgramFormatter;
import net.morimekta.providence.generator.format.java.shared.BaseServiceFormatter;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.generator.util.FileManager;
import net.morimekta.providence.reflect.ProgramRegistry;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.reflect.util.ReflectionUtils;
import net.morimekta.util.io.IndentedPrintWriter;

public class JavaGenerator
extends Generator {
    private final GeneratorOptions generatorOptions;
    private final JavaOptions javaOptions;

    public JavaGenerator(FileManager manager, GeneratorOptions generatorOptions, JavaOptions javaOptions) throws GeneratorException {
        super(manager);
        this.generatorOptions = generatorOptions;
        this.javaOptions = javaOptions;
    }

    private BaseMessageFormatter messageFormatter(IndentedPrintWriter writer, JHelper helper) {
        return new JavaMessageFormatter(writer, helper, this.generatorOptions, this.javaOptions);
    }

    private BaseInterfaceFormatter interfaceFormatter(IndentedPrintWriter writer, JHelper helper) {
        return new BaseInterfaceFormatter(writer, helper, this.javaOptions, this.generatorOptions);
    }

    private BaseEnumFormatter enumFormatter(IndentedPrintWriter writer) {
        return new JavaEnumFormatter(writer, this.generatorOptions, this.javaOptions);
    }

    private BaseProgramFormatter constFomatter(IndentedPrintWriter writer, JHelper helper) {
        return new JavaConstantsFormatter(writer, helper, this.generatorOptions, this.javaOptions);
    }

    private BaseProgramFormatter hazelcastFomatter(IndentedPrintWriter writer, JHelper helper) {
        return new HazelcastPortableProgramFormatter(writer, helper, this.generatorOptions, this.javaOptions);
    }

    private BaseServiceFormatter serviceFormatter(IndentedPrintWriter writer, JHelper helper) {
        return new JavaServiceFormatter(writer, helper, new BaseInterfaceFormatter(writer, helper, this.javaOptions, this.generatorOptions), new JavaMessageFormatter(true, writer, helper, this.generatorOptions, this.javaOptions), this.generatorOptions, this.javaOptions);
    }

    public void generate(@Nonnull ProgramRegistry registry) throws IOException, GeneratorException {
        String file;
        String file2;
        CProgram program = registry.getProgram();
        Path programFile = Paths.get(program.getProgramFilePath(), new String[0]);
        String javaPackage = JUtils.getJavaPackage(program);
        JHelper helper = new JHelper(registry);
        if (!this.javaOptions.generate_providence_core_types && ("net.morimekta.providence".equals(helper.getJavaPackage(program)) || "net.morimekta.providence.model".equals(helper.getJavaPackage(program)))) {
            return;
        }
        String packagePath = JUtils.getPackageClassPath(javaPackage);
        if (program.getConstants().size() > 0) {
            file2 = helper.getConstantsClassName(program) + ".java";
            this.getFileManager().createIfMissingOrOutdated(programFile, packagePath, file2, out -> {
                IndentedPrintWriter writer = new IndentedPrintWriter(out);
                this.appendFileHeader(writer, helper, program);
                this.constFomatter(writer, helper).appendProgramClass(program);
                writer.flush();
            });
        }
        if (this.javaOptions.hazelcast_portable && program.getConstants().stream().anyMatch(t -> t.getName().equals("FACTORY_ID"))) {
            file2 = helper.getHazelcastFactoryClassName(program) + ".java";
            this.getFileManager().createIfMissingOrOutdated(programFile, packagePath, file2, out -> {
                IndentedPrintWriter writer = new IndentedPrintWriter(out);
                this.appendFileHeader(writer, helper, program);
                this.hazelcastFomatter(writer, helper).appendProgramClass(program);
                writer.flush();
            });
        }
        for (PDeclaredDescriptor type : program.getDeclaredTypes()) {
            if (!ReflectionUtils.isDeclaredType((PDeclaredDescriptor)type)) continue;
            file = JUtils.getClassName(type) + ".java";
            this.getFileManager().createIfMissingOrOutdated(programFile, packagePath, file, out -> {
                IndentedPrintWriter writer = new IndentedPrintWriter(out);
                this.appendFileHeader(writer, helper, program);
                switch (type.getType()) {
                    case MESSAGE: {
                        PMessageDescriptor mt = (PMessageDescriptor)type;
                        if (mt.getVariant() == PMessageVariant.INTERFACE) {
                            this.interfaceFormatter(writer, helper).appendInterface(mt);
                            break;
                        }
                        this.messageFormatter(writer, helper).appendMessageClass(mt);
                        break;
                    }
                    case ENUM: {
                        this.enumFormatter(writer).appendEnumClass((CEnumDescriptor)type);
                        break;
                    }
                    default: {
                        throw new GeneratorException("Unhandled declaration type.");
                    }
                }
                writer.flush();
            });
            if (!(type instanceof PMessageDescriptor) || type instanceof PInterfaceDescriptor) continue;
            String ifFile = JUtils.getInterfaceName((PMessageDescriptor)type) + ".java";
            this.getFileManager().createIfMissingOrOutdated(programFile, packagePath, ifFile, out -> {
                IndentedPrintWriter iwriter = new IndentedPrintWriter(out);
                this.appendFileHeader(iwriter, helper, program);
                this.interfaceFormatter(iwriter, helper).appendInterface((PMessageDescriptor)type);
                iwriter.flush();
            });
        }
        for (CService service : program.getServices()) {
            file = JUtils.getClassName((PService)service) + ".java";
            this.getFileManager().createIfMissingOrOutdated(programFile, packagePath, file, out -> {
                IndentedPrintWriter writer = new IndentedPrintWriter(out);
                this.appendFileHeader(writer, helper, program);
                this.serviceFormatter(writer, helper).appendServiceClass(service);
                writer.flush();
            });
        }
    }

    private void appendFileHeader(IndentedPrintWriter writer, JHelper helper, CProgram document) throws GeneratorException {
        writer.format("package %s;", new Object[]{helper.getJavaPackage(document)}).newline();
    }
}

