/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages;

import java.util.BitSet;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PInterfaceDescriptor;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.io.IndentedPrintWriter;

public class BuilderCommonMemberFormatter
implements MessageMemberFormatter {
    protected final IndentedPrintWriter writer;
    protected final JHelper helper;

    public BuilderCommonMemberFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    @Override
    public Collection<String> getExtraImplements(JMessage<?> message) throws GeneratorException {
        PInterfaceDescriptor implementing = message.descriptor().getImplementing();
        if (implementing != null && !message.isUnion()) {
            return UnmodifiableList.listOf((Object)(this.helper.getJavaPackage((PDeclaredDescriptor<?>)implementing) + "." + JUtils.getInterfaceName(implementing) + "._Builder"), (Object)JUtils.getInterfaceName(message.descriptor()));
        }
        return UnmodifiableList.listOf((Object)JUtils.getInterfaceName(message.descriptor()));
    }

    @Override
    public void appendClassAnnotations(JMessage<?> message) throws GeneratorException {
        if (JAnnotation.isDeprecated(message.descriptor())) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
    }

    @Override
    public void appendConstructors(JMessage<?> message) throws GeneratorException {
        this.appendDefaultConstructor(message);
        this.appendMutateConstructor(message);
    }

    @Override
    public void appendFields(JMessage<?> message) throws GeneratorException {
        if (message.isUnion()) {
            this.appendUnionFields(message);
        } else {
            if (message.isException()) {
                this.appendExceptionFields(message);
            }
            this.appendStructFields(message);
        }
        this.appendModifiedFields(message);
        for (JField field : message.declaredOrderFields()) {
            if (field.isVoid()) continue;
            this.writer.formatln("private %s %s;", new Object[]{field.fieldType(), field.member()});
            if (field.type() != PType.MESSAGE) continue;
            this.writer.formatln("private %s._Builder %s_builder;", new Object[]{field.builderFieldType(), field.member()});
        }
        if (message.declaredOrderFields().size() > 0) {
            this.writer.newline();
        }
    }

    @Override
    public void appendMethods(JMessage<?> message) throws GeneratorException {
        for (JField field : message.declaredOrderFields()) {
            this.appendSetter(message, field);
            if (field.container()) {
                this.appendAdder(message, field);
            }
            this.appendIsSet(message, field);
            if (!message.isUnion()) {
                this.appendIsModified(message, field);
            }
            this.appendResetter(message, field);
            this.appendMutableGetters(message, field);
            this.appendGetter(message, field);
        }
        if (message.isUnion()) {
            this.appendIsUnionModified(message);
        }
        if (message.isException()) {
            this.appendInitCause(message);
        }
        this.appendEquals(message);
        this.appendHashCode(message);
    }

    @Override
    public void appendExtraProperties(JMessage<?> message) throws GeneratorException {
        this.appendBuilderBuild(message);
    }

    private void appendBuilderBuild(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"@javax.annotation.Nonnull").formatln("public %s build() {", new Object[]{message.instanceType()}).begin();
        if (message.isException()) {
            this.writer.formatln("%s e = new %s(this);", new Object[]{message.instanceType(), message.instanceType()}).newline();
            this.writer.appendln((CharSequence)"try {").appendln((CharSequence)"    StackTraceElement[] stackTrace = e.getStackTrace();").appendln((CharSequence)"    StackTraceElement[] subTrace = new StackTraceElement[stackTrace.length - 1];").appendln((CharSequence)"    System.arraycopy(stackTrace, 1, subTrace, 0, subTrace.length);").appendln((CharSequence)"    e.setStackTrace(subTrace);").appendln((CharSequence)"} catch (Throwable ignored) {").appendln((CharSequence)"}").newline();
            this.writer.appendln((CharSequence)"if (cause != null) {").appendln((CharSequence)"    e.initCause(cause);").appendln((CharSequence)"}").newline().appendln((CharSequence)"return e;");
        } else {
            this.writer.formatln("return new %s(this);", new Object[]{message.instanceType()});
        }
        this.writer.end().appendln('}');
    }

    private void appendEquals(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean equals(Object o) {").begin().appendln((CharSequence)"if (o == this) return true;").appendln((CharSequence)"if (o == null || !o.getClass().equals(getClass())) return false;");
        if (message.numericalOrderFields().size() > 0) {
            this.writer.formatln("%s._Builder other = (%s._Builder) o;", new Object[]{message.instanceType(), message.instanceType()}).appendln((CharSequence)"return ");
            if (message.isUnion()) {
                this.writer.format("%s.equals(%s, other.%s)", new Object[]{Objects.class.getName(), "tUnionField", "tUnionField"});
            } else {
                this.writer.format("%s.equals(optionals, other.optionals)", new Object[]{Objects.class.getName()});
            }
            for (JField field : message.declaredOrderFields()) {
                if (field.isVoid()) continue;
                this.writer.append((CharSequence)" &&").appendln((CharSequence)"       ");
                if (field.type() == PType.MESSAGE) {
                    this.writer.format("%s.equals(%s(), other.%s())", new Object[]{Objects.class.getName(), field.getter(), field.getter()});
                    continue;
                }
                this.writer.format("%s.equals(%s, other.%s)", new Object[]{Objects.class.getName(), field.member(), field.member()});
            }
            this.writer.append(';');
        } else {
            this.writer.appendln((CharSequence)"return true;");
        }
        this.writer.end().appendln((CharSequence)"}").newline();
    }

    private void appendHashCode(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int hashCode() {").begin().formatln("return %s.hash(", new Object[]{Objects.class.getName()}).begin("        ").formatln("%s.class", new Object[]{message.instanceType()});
        if (!message.isUnion()) {
            this.writer.append((CharSequence)", optionals");
        }
        message.numericalOrderFields().stream().filter(field -> !field.isVoid()).forEach(field -> {
            if (field.type() == PType.MESSAGE) {
                this.writer.append((CharSequence)",");
                this.writer.formatln("%s._Field.%s, %s()", new Object[]{message.instanceType(), field.fieldEnum(), field.getter()});
            } else {
                this.writer.append((CharSequence)",");
                this.writer.formatln("%s._Field.%s, %s", new Object[]{message.instanceType(), field.fieldEnum(), field.member()});
            }
        });
        this.writer.end().append((CharSequence)");").end().appendln((CharSequence)"}").newline();
    }

    private void appendUnionFields(JMessage<?> message) {
        this.writer.formatln("private %s._Field %s;", new Object[]{message.instanceType(), "tUnionField"}).newline();
    }

    private void appendExceptionFields(JMessage<?> message) {
        this.writer.formatln("private Throwable cause;", new Object[0]);
    }

    private void appendStructFields(JMessage<?> message) {
        this.writer.formatln("private %s optionals;", new Object[]{BitSet.class.getName()});
    }

    private void appendModifiedFields(JMessage<?> message) {
        if (!message.isUnion()) {
            this.writer.formatln("private %s modified;", new Object[]{BitSet.class.getName()}).newline();
        } else {
            this.writer.formatln("private %s modified;", new Object[]{Boolean.TYPE.getName()}).newline();
        }
    }

    private void appendDefaultConstructor(JMessage<?> message) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.commentRaw("Make a " + message.descriptor().getQualifiedName() + " builder instance.").finish();
        this.writer.appendln((CharSequence)"public _Builder() {").begin();
        if (!message.isUnion()) {
            this.writer.formatln("optionals = new %s(%d);", new Object[]{BitSet.class.getName(), message.declaredOrderFields().size()});
            this.writer.formatln("modified = new %s(%d);", new Object[]{BitSet.class.getName(), message.declaredOrderFields().size()});
        } else {
            this.writer.appendln((CharSequence)"modified = false;");
        }
        for (JField field : message.declaredOrderFields()) {
            if (!field.alwaysPresent()) continue;
            this.writer.formatln("%s = %s;", new Object[]{field.member(), field.kDefault()});
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendMutateConstructor(JMessage<?> message) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.commentRaw("Make a mutating builder off a base " + message.descriptor().getQualifiedName() + ".").newline().param_("base", "The base " + message.descriptor().getName()).finish();
        this.writer.formatln("public _Builder(%s base) {", new Object[]{message.instanceType()}).begin().appendln((CharSequence)"this();").newline();
        if (message.isUnion()) {
            this.writer.formatln("%s = base.%s;", new Object[]{"tUnionField", "tUnionField"}).newline();
        }
        for (JField field : message.declaredOrderFields()) {
            boolean checkPresence;
            boolean bl = message.isUnion() ? field.container() : (checkPresence = !field.alwaysPresent());
            if (checkPresence) {
                this.writer.formatln("if (base.%s()) {", new Object[]{field.presence()}).begin();
            }
            if (!message.isUnion()) {
                this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
            }
            if (field.type() != PType.VOID) {
                this.writer.formatln("%s = base.%s;", new Object[]{field.member(), field.member()});
            }
            if (!checkPresence) continue;
            this.writer.end().appendln('}');
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendSetter(JMessage message, JField field) throws GeneratorException {
        PEnumDescriptor enumType;
        String reason;
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.commentRaw("Set the <code>" + field.name() + "</code> field value.");
        if (field.hasComment()) {
            comment.paragraph().comment(field.comment());
        }
        comment.newline();
        if (!field.isVoid()) {
            comment.param_("value", "The new value");
        }
        comment.return_("The builder");
        if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
            comment.deprecated_(reason);
        }
        comment.finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
        if (field.isVoid()) {
            this.writer.formatln("public %s._Builder %s() {", new Object[]{message.instanceType(), field.setter()}).begin();
        } else {
            this.writer.formatln("public %s._Builder %s(%s value) {", new Object[]{message.instanceType(), field.setter(), this.helper.getSetterParamType(field.field().getDescriptor())});
            this.writer.begin().formatln("if (value == null) {", new Object[0]).formatln("    return %s();", new Object[]{field.resetter()}).appendln('}').newline();
        }
        if (message.isUnion()) {
            this.writer.formatln("%s = %s._Field.%s;", new Object[]{"tUnionField", message.instanceType(), field.fieldEnum()});
            this.writer.appendln((CharSequence)"modified = true;");
        } else {
            this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
            this.writer.formatln("modified.set(%d);", new Object[]{field.index()});
        }
        switch (field.type()) {
            case VOID: {
                break;
            }
            case SET: 
            case LIST: 
            case MAP: {
                this.writer.formatln("%s = %s;", new Object[]{field.member(), field.fieldInstanceCopy("value")});
                break;
            }
            case MESSAGE: {
                this.writer.formatln("if (value instanceof %s._Builder) {", new Object[]{field.instanceType()});
                this.writer.formatln("    value = ((%s._Builder) value).build();", new Object[]{field.instanceType()});
                this.writer.formatln("} else if (!(value instanceof %s)) {", new Object[]{field.instanceType()});
                this.writer.formatln("    throw new %s(\"Invalid type for %s: \" + value.getClass().getName());", new Object[]{IllegalArgumentException.class.getName(), field.field().getDescriptor().getQualifiedName()});
                this.writer.appendln((CharSequence)"}");
                this.writer.formatln("%s = (%s) value;", new Object[]{field.member(), field.instanceType()});
                this.writer.formatln("%s_builder = null;", new Object[]{field.member()});
                break;
            }
            default: {
                this.writer.formatln("%s = value;", new Object[]{field.member()});
            }
        }
        this.writer.appendln((CharSequence)"return this;").end().appendln('}').newline();
        if (field.isPrimitiveJavaValue() && !field.isVoid()) {
            comment = new BlockCommentBuilder(this.writer);
            comment.commentRaw("Set the <code>" + field.name() + "</code> field value.");
            if (field.hasComment()) {
                comment.paragraph().comment(field.comment());
            }
            comment.newline();
            if (!field.isVoid()) {
                comment.param_("value", "The new value");
            }
            comment.return_("The builder");
            if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
                comment.deprecated_(reason);
            }
            comment.finish();
            if (JAnnotation.isDeprecated(field)) {
                this.writer.appendln((CharSequence)"@Deprecated");
            }
            this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
            this.writer.formatln("public %s._Builder %s(%s value) {", new Object[]{message.instanceType(), field.setter(), field.valueType()});
            this.writer.begin();
            if (message.isUnion()) {
                this.writer.formatln("%s = %s._Field.%s;", new Object[]{"tUnionField", message.instanceType(), field.fieldEnum()});
                this.writer.appendln((CharSequence)"modified = true;");
            } else {
                this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                this.writer.formatln("modified.set(%d);", new Object[]{field.index()});
            }
            this.writer.formatln("%s = value;", new Object[]{field.member()}).appendln((CharSequence)"return this;").end().appendln((CharSequence)"}").newline();
        }
        if ((enumType = field.refEnum(message.descriptor(), this.helper)) != null) {
            String reason2;
            comment = new BlockCommentBuilder(this.writer);
            comment.commentRaw("Set the value of the <code>" + field.name() + "</code> field.");
            if (field.hasComment()) {
                comment.paragraph().comment(field.comment());
            }
            comment.newline();
            if (!field.isVoid()) {
                comment.param_("value", "The new value ref");
            }
            comment.return_("The builder");
            if (JAnnotation.isDeprecated(field) && (reason2 = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason2.trim().length() > 0) {
                comment.deprecated_(reason2);
            }
            comment.finish();
            this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
            this.writer.formatln("public %s._Builder %s(%s value) {", new Object[]{message.instanceType(), field.setter(), this.helper.getValueType((PDescriptor)enumType)}).begin().formatln("if (value == null) return %s();", new Object[]{field.resetter()});
            if (field.type() == PType.STRING) {
                this.writer.formatln("return %s(value.asString());", new Object[]{field.setter()});
            } else {
                String cast = "";
                if (field.isPrimitiveJavaValue() && field.type() != PType.I32) {
                    PPrimitive primitive = (PPrimitive)field.field().getDescriptor();
                    cast = "(" + primitive.getNativeType().getTypeName() + ") ";
                }
                this.writer.formatln("return %s(%svalue.asInteger());", new Object[]{field.setter(), cast});
            }
            this.writer.end().appendln('}').newline();
        }
    }

    private void appendAdder(JMessage message, JField field) throws GeneratorException {
        String reason;
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        if (field.type() == PType.MAP) {
            comment.commentRaw("Adds a mapping to the <code>" + field.name() + "</code> map.");
        } else if (field.type() == PType.SET) {
            comment.commentRaw("Adds entries to the <code>" + field.name() + "</code> set.");
        } else {
            comment.commentRaw("Adds entries to the <code>" + field.name() + "</code> list.");
        }
        if (field.hasComment()) {
            comment.paragraph().comment(field.comment());
        }
        comment.newline();
        if (field.type() == PType.MAP) {
            comment.param_("key", "The inserted key").param_("value", "The inserted value");
        } else {
            comment.param_("values", "The added value");
        }
        comment.return_("The builder");
        if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
            comment.deprecated_(reason);
        }
        comment.finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
        switch (field.type()) {
            case MAP: {
                PMap mType = (PMap)field.field().getDescriptor();
                String mkType = this.helper.getValueType(mType.keyDescriptor());
                String miType = this.helper.getValueType(mType.itemDescriptor());
                this.writer.formatln("public %s._Builder %s(%s key, %s value) {", new Object[]{message.instanceType(), field.adder(), mkType, miType}).begin();
                if (message.isUnion()) {
                    this.writer.formatln("%s = %s._Field.%s;", new Object[]{"tUnionField", message.instanceType(), field.fieldEnum()});
                    this.writer.appendln((CharSequence)"modified = true;");
                } else {
                    this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                    this.writer.formatln("modified.set(%d);", new Object[]{field.index()});
                }
                this.writer.formatln("%s().put(key, value);", new Object[]{field.mutable()}).appendln((CharSequence)"return this;").end().appendln('}').newline();
                break;
            }
            case SET: 
            case LIST: {
                PContainer lType = (PContainer)field.field().getDescriptor();
                String liType = this.helper.getValueType(lType.itemDescriptor());
                if (lType.itemDescriptor().getType() == PType.LIST || lType.itemDescriptor().getType() == PType.SET || lType.itemDescriptor().getType() == PType.MAP) {
                    this.writer.appendln((CharSequence)"@SuppressWarnings(\"unchecked\")");
                    this.writer.appendln((CharSequence)"@SafeVarargs");
                    this.writer.formatln("public final %s._Builder %s(%s... values) {", new Object[]{message.instanceType(), field.adder(), liType}).begin();
                } else {
                    this.writer.formatln("public %s._Builder %s(%s... values) {", new Object[]{message.instanceType(), field.adder(), liType}).begin();
                }
                if (message.isUnion()) {
                    this.writer.formatln("%s = %s._Field.%s;", new Object[]{"tUnionField", message.instanceType(), field.fieldEnum()});
                    this.writer.appendln((CharSequence)"modified = true;");
                } else {
                    this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                    this.writer.formatln("modified.set(%d);", new Object[]{field.index()});
                }
                this.writer.formatln("%s _container = %s();", new Object[]{field.fieldType(), field.mutable()}).formatln("for (%s item : values) {", new Object[]{liType}).begin().appendln((CharSequence)"_container.add(item);").end().appendln('}').appendln((CharSequence)"return this;").end().appendln('}').newline();
                break;
            }
            default: {
                throw new GeneratorException("Unexpected field type: " + field.type());
            }
        }
    }

    private void appendIsSet(JMessage message, JField field) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.commentRaw("Checks for explicit presence of the <code>" + field.name() + "</code> field.");
        comment.newline().return_(String.format(Locale.US, "True if %s has been set.", field.name())).finish();
        this.writer.formatln("public boolean %s() {", new Object[]{field.isSet()}).begin();
        if (message.isUnion()) {
            this.writer.formatln("return %s == %s._Field.%s;", new Object[]{"tUnionField", message.instanceType(), field.fieldEnum()});
        } else {
            this.writer.formatln("return optionals.get(%d);", new Object[]{field.index()});
        }
        this.writer.end().appendln('}').newline();
        comment = new BlockCommentBuilder(this.writer);
        comment.commentRaw("Checks for presence of the <code>" + field.name() + "</code> field.");
        comment.newline().return_(String.format(Locale.US, "True if %s is present.", field.name())).finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        this.writer.formatln("public boolean %s() {", new Object[]{field.presence()}).begin();
        if (message.isUnion()) {
            this.writer.formatln("return %s == %s._Field.%s;", new Object[]{"tUnionField", message.instanceType(), field.fieldEnum()});
        } else if (field.alwaysPresent()) {
            this.writer.formatln("return true;", new Object[0]);
        } else {
            this.writer.formatln("return optionals.get(%d);", new Object[]{field.index()});
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendIsModified(JMessage message, JField field) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.commentRaw("Checks if the <code>" + field.name() + "</code> field has been modified since the \nbuilder was created.");
        comment.newline().return_(String.format(Locale.US, "True if %s has been modified.", field.name())).finish();
        this.writer.formatln("public boolean %s() {", new Object[]{field.isModified()}).begin();
        this.writer.formatln("return modified.get(%d);", new Object[]{field.index()});
        this.writer.end().appendln('}').newline();
    }

    private void appendIsUnionModified(JMessage message) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.commentRaw("Checks if the <code>" + message.descriptor().getName() + "</code> union has been modified since the \nbuilder was created.");
        comment.newline().return_(String.format(Locale.US, "True if %s has been modified.", message.descriptor().getName())).finish();
        this.writer.formatln("public boolean %s() {", new Object[]{"isUnionModified"}).begin();
        this.writer.appendln((CharSequence)"return modified;");
        this.writer.end().appendln('}').newline();
    }

    private void appendResetter(JMessage message, JField field) {
        String reason;
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.commentRaw("Clear the <code>" + field.name() + "</code> field.");
        comment.newline().return_("The builder");
        if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
            comment.deprecated_(reason);
        }
        comment.finish();
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
        this.writer.formatln("public %s._Builder %s() {", new Object[]{message.instanceType(), field.resetter()}).begin();
        if (message.isUnion()) {
            this.writer.formatln("if (%s == %s._Field.%s) %s = null;", new Object[]{"tUnionField", message.instanceType(), field.fieldEnum(), "tUnionField"});
            this.writer.appendln((CharSequence)"modified = true;");
        } else {
            this.writer.formatln("optionals.clear(%d);", new Object[]{field.index()});
            this.writer.formatln("modified.set(%d);", new Object[]{field.index()});
        }
        if (!field.isVoid()) {
            if (field.alwaysPresent()) {
                this.writer.formatln("%s = %s;", new Object[]{field.member(), field.kDefault()});
            } else {
                this.writer.formatln("%s = null;", new Object[]{field.member()});
                if (field.type() == PType.MESSAGE) {
                    this.writer.formatln("%s_builder = null;", new Object[]{field.member()});
                }
            }
        }
        this.writer.appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendMutableGetters(JMessage message, JField field) throws GeneratorException {
        switch (field.type()) {
            case MESSAGE: {
                String reason;
                BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
                comment.commentRaw("Get the builder for the contained <code>" + field.name() + "</code> message field.");
                if (field.hasComment()) {
                    comment.paragraph().comment(field.comment());
                }
                comment.newline().return_("The field message builder");
                if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
                    comment.deprecated_(reason);
                }
                comment.finish();
                if (JAnnotation.isDeprecated(field)) {
                    this.writer.appendln((CharSequence)"@Deprecated");
                }
                this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
                this.writer.formatln("public %s._Builder %s() {", new Object[]{field.instanceType(), field.mutable()}).begin();
                if (message.isUnion()) {
                    this.writer.formatln("if (%s != %s._Field.%s) {", new Object[]{"tUnionField", message.instanceType(), field.fieldEnum()}).formatln("    %s();", new Object[]{field.resetter()}).appendln('}').formatln("%s = %s._Field.%s;", new Object[]{"tUnionField", message.instanceType(), field.fieldEnum()});
                    this.writer.appendln((CharSequence)"modified = true;");
                } else {
                    this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                    this.writer.formatln("modified.set(%d);", new Object[]{field.index()});
                }
                this.writer.newline().formatln("if (%s != null) {", new Object[]{field.member()}).formatln("    %s_builder = %s.mutate();", new Object[]{field.member(), field.member()}).formatln("    %s = null;", new Object[]{field.member()}).formatln("} else if (%s_builder == null) {", new Object[]{field.member()}).formatln("    %s_builder = %s.builder();", new Object[]{field.member(), field.instanceType()}).appendln('}').formatln("return %s_builder;", new Object[]{field.member()});
                this.writer.end().appendln('}').newline();
                break;
            }
            case SET: 
            case LIST: 
            case MAP: {
                String reason;
                BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
                if (field.hasComment()) {
                    comment.comment(field.comment()).newline();
                }
                comment.return_("The mutable <code>" + field.name() + "</code> container");
                if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
                    comment.deprecated_(reason);
                }
                comment.finish();
                if (JAnnotation.isDeprecated(field)) {
                    this.writer.appendln((CharSequence)"@Deprecated");
                }
                this.writer.formatln("public %s %s() {", new Object[]{field.fieldType(), field.mutable()}).begin();
                if (message.isUnion()) {
                    this.writer.formatln("if (%s != %s._Field.%s) {", new Object[]{"tUnionField", message.instanceType(), field.fieldEnum()}).formatln("    %s();", new Object[]{field.resetter()}).appendln('}').formatln("%s = %s._Field.%s;", new Object[]{"tUnionField", message.instanceType(), field.fieldEnum()});
                    this.writer.appendln((CharSequence)"modified = true;");
                } else {
                    this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                    this.writer.formatln("modified.set(%d);", new Object[]{field.index()});
                }
                this.writer.newline().formatln("if (%s == null) {", new Object[]{field.member()}).formatln("    %s = new %s<>();", new Object[]{field.member(), field.builderMutableType()}).formatln("} else if (!(%s instanceof %s)) {", new Object[]{field.member(), field.builderMutableType()}).formatln("    %s = new %s<>(%s);", new Object[]{field.member(), field.builderMutableType(), field.member()}).appendln((CharSequence)"}");
                this.writer.formatln("return %s;", new Object[]{field.member()});
                this.writer.end().appendln('}').newline();
                break;
            }
        }
    }

    private void appendGetter(JMessage message, JField field) {
        String reason;
        if (field.isVoid()) {
            return;
        }
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        comment.return_("The <code>" + field.name() + "</code> field value");
        if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
            comment.deprecated_(reason);
        }
        comment.finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        this.writer.formatln("public %s %s() {", new Object[]{field.valueType(), field.getter()}).begin();
        if (field.type() == PType.MESSAGE) {
            if (field.hasDefaultConstant()) {
                this.writer.formatln("return %s_builder != null ? %s_builder.build() : %s != null ? %s : %s;", new Object[]{field.member(), field.member(), field.member(), field.member(), field.kDefault()});
            } else {
                this.writer.formatln("return %s_builder != null ? %s_builder.build() : %s;", new Object[]{field.member(), field.member(), field.member()});
            }
        } else if (field.hasDefaultConstant()) {
            this.writer.formatln("return %s() ? %s : %s;", new Object[]{field.isSet(), field.member(), field.kDefault()});
        } else {
            this.writer.formatln("return %s;", new Object[]{field.member()});
        }
        this.writer.end().appendln('}').newline();
        if (!field.alwaysPresent()) {
            comment = new BlockCommentBuilder(this.writer);
            if (field.hasComment()) {
                comment.comment(field.comment()).newline();
            }
            comment.return_("Optional <code>" + field.name() + "</code> field value");
            if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
                comment.deprecated_(reason);
            }
            comment.finish();
            if (JAnnotation.isDeprecated(field)) {
                this.writer.appendln((CharSequence)"@Deprecated");
            }
            this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
            this.writer.formatln("public %s<%s> %s() {", new Object[]{Optional.class.getName(), field.fieldType(), field.optional()}).begin();
            if (field.type() == PType.MESSAGE) {
                this.writer.formatln("return %s.ofNullable(%s_builder != null ? %s_builder.build() : %s);", new Object[]{Optional.class.getName(), field.member(), field.member(), field.member()});
            } else {
                this.writer.formatln("return %s.ofNullable(%s);", new Object[]{Optional.class.getName(), field.member()});
            }
            this.writer.end().appendln('}').newline();
        }
        if (field.container()) {
            comment = new BlockCommentBuilder(this.writer);
            if (field.hasComment()) {
                comment.comment(field.comment()).newline();
            }
            comment.return_("Number of entries in <code>" + field.name() + "</code>.");
            if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(PAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
                comment.deprecated_(reason);
            }
            comment.finish();
            if (JAnnotation.isDeprecated(field)) {
                this.writer.appendln((CharSequence)"@Deprecated");
            }
            this.writer.formatln("public int %s() {", new Object[]{field.counter()}).begin();
            this.writer.formatln("return %s != null ? %s.size() : 0;", new Object[]{field.member(), field.member()});
            this.writer.end().appendln('}').newline();
        }
    }

    private void appendInitCause(JMessage<?> message) {
        new BlockCommentBuilder(this.writer).commentRaw("Initializes the cause of the " + message.descriptor().getQualifiedName()).newline().param_("cause", "The cause").return_("Builder instance").finish();
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
        this.writer.formatln("public %s._Builder initCause(Throwable cause) {", new Object[]{message.instanceType()}).appendln((CharSequence)"    this.cause = cause;").appendln((CharSequence)"    return this;").appendln((CharSequence)"}").newline();
    }
}

