/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import javax.annotation.Generated;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.GeneratorOptions;
import net.morimekta.providence.generator.format.java.JavaOptions;
import net.morimekta.providence.generator.format.java.shared.BaseProgramFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.ValueBuilder;
import net.morimekta.providence.reflect.contained.CConst;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.util.io.IndentedPrintWriter;

public class JavaConstantsFormatter
implements BaseProgramFormatter {
    private final JHelper helper;
    private final IndentedPrintWriter writer;
    private final GeneratorOptions generatorOptions;
    private final JavaOptions javaOptions;

    public JavaConstantsFormatter(IndentedPrintWriter writer, JHelper helper, GeneratorOptions generatorOptions, JavaOptions javaOptions) {
        this.writer = writer;
        this.helper = helper;
        this.generatorOptions = generatorOptions;
        this.javaOptions = javaOptions;
    }

    @Override
    public void appendProgramClass(CProgram program) throws GeneratorException {
        ValueBuilder value = new ValueBuilder(this.writer, this.helper);
        if (program.getDocumentation() != null) {
            new BlockCommentBuilder(this.writer).comment(program.getDocumentation()).finish();
        }
        if (this.javaOptions.generated_annotation_version) {
            this.writer.formatln("@%s(\"%s %s\")", new Object[]{Generated.class.getName(), this.generatorOptions.generator_program_name, this.generatorOptions.program_version});
        } else {
            this.writer.formatln("@%s(\"%s\")", new Object[]{Generated.class.getName(), this.generatorOptions.generator_program_name});
        }
        this.writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")").formatln("public class %s {", new Object[]{this.helper.getConstantsClassName(program)}).begin().formatln("private %s() {}", new Object[]{this.helper.getConstantsClassName(program)});
        for (CConst c : program.getConstants()) {
            this.writer.newline();
            try {
                String name = c.getName();
                this.writer.formatln("public static final %s %s = ", new Object[]{this.helper.getValueType(c.getDescriptor()), name}).begin();
                value.appendTypedValue(c.getDefaultValue(), c.getDescriptor());
                this.writer.append(';').end();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new GeneratorException("Unable to generate constant " + program.getProgramName() + "." + c.getName(), (Throwable)e);
            }
        }
        this.writer.end().appendln('}').newline();
    }
}

