/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import javax.annotation.Nonnull;
import net.morimekta.util.io.IndentedPrintWriter;

public class BlockCommentBuilder {
    private static final Escaper HTML = HtmlEscapers.htmlEscaper();
    private final IndentedPrintWriter writer;

    public BlockCommentBuilder(IndentedPrintWriter writer) {
        this.writer = writer;
        writer.appendln((CharSequence)"/**").begin(" *");
    }

    public BlockCommentBuilder comment(String comment) {
        String escaped = HTML.escape(comment).replaceAll("[@]", "&#64;");
        for (String line : escaped.trim().split("\r?\n")) {
            if (line.trim().length() == 0) {
                this.writer.appendln((CharSequence)" <p>");
                continue;
            }
            this.writer.appendln((CharSequence)(" " + line.replaceAll("[ ]*$", "")));
        }
        return this;
    }

    public BlockCommentBuilder commentRaw(String comment) {
        for (String line : comment.trim().split("\r?\n")) {
            if (line.trim().length() == 0) {
                this.writer.appendln((CharSequence)" <p>");
                continue;
            }
            this.writer.appendln((CharSequence)(" " + line.replaceAll("[ ]*$", "")));
        }
        return this;
    }

    public BlockCommentBuilder newline() {
        this.writer.appendln();
        return this;
    }

    public BlockCommentBuilder paragraph() {
        this.writer.appendln((CharSequence)" <p>");
        return this;
    }

    public BlockCommentBuilder param_(String name, String comment) {
        this.writer.formatln(" @param %s %s", new Object[]{name, HTML.escape(comment)});
        return this;
    }

    public BlockCommentBuilder return_(String comment) {
        this.writer.formatln(" @return %s", new Object[]{comment});
        return this;
    }

    public BlockCommentBuilder throws_(Class<?> klass, String comment) {
        return this.throws_(klass.getName().replaceAll("[$]", "."), comment);
    }

    public BlockCommentBuilder throws_(String klass, String comment) {
        this.writer.formatln(" @throws %s %s", new Object[]{klass, comment});
        return this;
    }

    public BlockCommentBuilder deprecated_(@Nonnull String reason) {
        this.writer.formatln(" @deprecated %s", new Object[]{HTML.escape(reason)});
        return this;
    }

    public void finish() {
        this.writer.end().appendln((CharSequence)" */");
    }
}

