/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Generated;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.GeneratorOptions;
import net.morimekta.providence.generator.format.java.JavaOptions;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.generator.format.java.utils.ValueBuilder;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.util.ThriftAnnotation;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class CommonMemberFormatter
implements MessageMemberFormatter {
    protected final IndentedPrintWriter writer;
    private final JHelper helper;
    private final JavaOptions javaOptions;
    private final GeneratorOptions generatorOptions;

    public CommonMemberFormatter(IndentedPrintWriter writer, JHelper helper, GeneratorOptions generatorOptions, JavaOptions javaOptions) {
        this.writer = writer;
        this.helper = helper;
        this.generatorOptions = generatorOptions;
        this.javaOptions = javaOptions;
    }

    @Override
    public void appendClassAnnotations(JMessage<?> message) throws GeneratorException {
        if (JAnnotation.isDeprecated((CAnnotatedDescriptor)message.descriptor())) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        this.writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")");
        if (this.javaOptions.generated_annotation_version) {
            this.writer.formatln("@%s(\"%s %s\")", new Object[]{Generated.class.getName(), this.generatorOptions.generator_program_name, this.generatorOptions.program_version});
        } else {
            this.writer.formatln("@%s(\"%s\")", new Object[]{Generated.class.getName(), this.generatorOptions.generator_program_name});
        }
        this.writer.formatln("@%s", new Object[]{Immutable.class.getName()});
    }

    @Override
    public void appendConstants(JMessage<?> message) throws GeneratorException {
        this.writer.formatln("private final static long serialVersionUID = %dL;", new Object[]{JUtils.generateSerialVersionUID(message.descriptor())}).newline();
        this.appendFieldDefaultValues(message);
    }

    @Override
    public void appendFields(JMessage<?> message) throws GeneratorException {
        this.appendFieldDeclarations(message);
    }

    @Override
    public void appendConstructors(JMessage<?> message) throws GeneratorException {
        this.appendCreateConstructor(message);
    }

    @Override
    public void appendMethods(JMessage<?> message) throws GeneratorException {
        this.appendFieldGetters(message);
        if (message.isException()) {
            this.appendCreateMessage(message);
        }
    }

    private void appendFieldDefaultValues(JMessage<?> message) throws GeneratorException {
        ValueBuilder values = new ValueBuilder(this.writer, this.helper);
        values.appendDefaultConstants(message.declaredOrderFields());
    }

    private void appendFieldGetters(JMessage<?> message) throws GeneratorException {
        for (JField field : message.declaredOrderFields()) {
            String reason;
            String reason2;
            if (message.isUnion()) {
                if (field.container()) {
                    this.writer.formatln("public int %s() {", new Object[]{field.counter()}).formatln("    return %s == _Field.%s ? %s.size() : 0;", new Object[]{"tUnionField", field.fieldEnum(), field.member()}).appendln('}').newline();
                }
                if (field.alwaysPresent() || field.isVoid()) {
                    this.writer.formatln("public boolean %s() {", new Object[]{field.presence()}).formatln("    return %s == _Field.%s;", new Object[]{"tUnionField", field.fieldEnum()}).appendln('}').newline();
                } else {
                    this.writer.formatln("public boolean %s() {", new Object[]{field.presence()}).formatln("    return %s == _Field.%s && %s != null;", new Object[]{"tUnionField", field.fieldEnum(), field.member()}).appendln('}').newline();
                }
            } else {
                if (field.container()) {
                    this.writer.formatln("public int %s() {", new Object[]{field.counter()}).formatln("    return %s != null ? %s.size() : 0;", new Object[]{field.member(), field.member()}).appendln('}').newline();
                }
                if (field.alwaysPresent()) {
                    this.writer.formatln("public boolean %s() {", new Object[]{field.presence()}).begin().formatln("return true;", new Object[0]).end().appendln('}').newline();
                } else {
                    this.writer.formatln("public boolean %s() {", new Object[]{field.presence()}).begin().formatln("return %s != null;", new Object[]{field.member()}).end().appendln('}').newline();
                }
            }
            if (field.isVoid()) continue;
            BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
            if (field.hasComment()) {
                comment.comment(field.comment()).newline();
            }
            comment.return_("The field value");
            if (JAnnotation.isDeprecated(field) && (reason2 = field.field().getAnnotationValue(ThriftAnnotation.DEPRECATED)) != null && reason2.trim().length() > 0) {
                comment.deprecated_(reason2);
            }
            comment.finish();
            if (JAnnotation.isDeprecated(field)) {
                this.writer.appendln((CharSequence)"@Deprecated");
            }
            if (field.alwaysPresent() && !field.isPrimitiveJavaValue()) {
                this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
            }
            this.writer.formatln("public %s %s() {", new Object[]{field.valueType(), field.getter()});
            if ((field.isPrimitiveJavaValue() || field.field().hasDefaultValue()) && !field.alwaysPresent()) {
                this.writer.formatln("    return %s() ? %s : %s;", new Object[]{field.presence(), field.member(), field.kDefault()});
            } else {
                this.writer.formatln("    return %s;", new Object[]{field.member()});
            }
            this.writer.appendln('}').newline();
            String enumTypeName = field.field().getAnnotationValue("ref.enum");
            if (field.type() == PType.I32 && enumTypeName != null) {
                if (!enumTypeName.contains(".")) {
                    enumTypeName = message.descriptor().getProgramName() + "." + enumTypeName;
                }
                PEnumDescriptor enumType = null;
                try {
                    enumType = this.helper.getRegistry().getRegistryForProgramName(message.descriptor().getProgramName()).getEnumType(enumTypeName);
                }
                catch (Exception e) {
                    System.err.format("[ERROR] ref.enum = \"%s\" is unknown from %s%n", enumTypeName, message.descriptor().getQualifiedName());
                    e.printStackTrace();
                }
                if (enumType != null) {
                    this.writer.appendln((CharSequence)"@javax.annotation.Nullable");
                    if (field.alwaysPresent()) {
                        this.writer.formatln("public %s %s() {", new Object[]{this.helper.getValueType((PDescriptor)enumType), field.ref()}).begin().formatln("return %s.findById(%s);", new Object[]{this.helper.getValueType((PDescriptor)enumType), field.member()}).end().appendln('}').newline();
                    } else {
                        this.writer.formatln("public %s %s() {", new Object[]{this.helper.getValueType((PDescriptor)enumType), field.ref()}).begin().formatln("return %s != null ? %s.findById(%s) : null;", new Object[]{field.member(), this.helper.getValueType((PDescriptor)enumType), field.member()}).end().appendln('}').newline();
                    }
                }
            }
            if (field.alwaysPresent()) continue;
            BlockCommentBuilder comment2 = new BlockCommentBuilder(this.writer);
            if (field.hasComment()) {
                comment2.comment(field.comment()).newline();
            }
            comment2.return_("Optional field value");
            if (JAnnotation.isDeprecated(field) && (reason = field.field().getAnnotationValue(ThriftAnnotation.DEPRECATED)) != null && reason.trim().length() > 0) {
                comment2.deprecated_(reason);
            }
            comment2.finish();
            if (JAnnotation.isDeprecated(field)) {
                this.writer.appendln((CharSequence)"@Deprecated");
            }
            this.writer.appendln((CharSequence)"@javax.annotation.Nonnull");
            switch (field.type()) {
                case I32: {
                    this.writer.formatln("public %s %s() {", new Object[]{OptionalInt.class.getName(), field.optional()});
                    this.writer.formatln("    return %s() ? %s.of(%s) : %s.empty();", new Object[]{field.presence(), OptionalInt.class.getName(), field.member(), OptionalInt.class.getName()});
                    this.writer.appendln('}');
                    break;
                }
                case I64: {
                    this.writer.formatln("public %s %s() {", new Object[]{OptionalLong.class.getName(), field.optional()});
                    this.writer.formatln("    return %s() ? %s.of(%s) : %s.empty();", new Object[]{field.presence(), OptionalLong.class.getName(), field.member(), OptionalLong.class.getName()});
                    this.writer.appendln('}');
                    break;
                }
                case DOUBLE: {
                    this.writer.formatln("public %s %s() {", new Object[]{OptionalDouble.class.getName(), field.optional()});
                    this.writer.formatln("    return %s() ? %s.of(%s) : %s.empty();", new Object[]{field.presence(), OptionalDouble.class.getName(), field.member(), OptionalDouble.class.getName()});
                    this.writer.appendln('}');
                    break;
                }
                default: {
                    this.writer.formatln("public %s<%s> %s() {", new Object[]{Optional.class.getName(), field.fieldType(), field.optional()});
                    this.writer.formatln("    return %s.ofNullable(%s);", new Object[]{Optional.class.getName(), field.member()});
                    this.writer.appendln('}');
                }
            }
            this.writer.newline();
        }
    }

    private void appendFieldDeclarations(JMessage<?> message) throws GeneratorException {
        for (JField field : message.declaredOrderFields()) {
            if (field.isVoid()) continue;
            this.writer.formatln("private final transient %s %s;", new Object[]{field.fieldType(), field.member()});
        }
        this.writer.newline();
    }

    private void appendCreateMessage(JMessage<?> message) throws GeneratorException {
        if (message.exceptionMessageField().isPresent()) {
            return;
        }
        this.writer.appendln((CharSequence)"private static String createMessage(").begin("                                    ");
        boolean first = true;
        for (JField fld : message.declaredOrderFields()) {
            if (fld.isVoid()) continue;
            if (first) {
                first = false;
            } else {
                this.writer.append(',').appendln();
            }
            this.writer.format("%s %s", new Object[]{fld.fieldType(), fld.param()});
        }
        this.writer.append((CharSequence)") {").end().begin().appendln((CharSequence)"StringBuilder out = new StringBuilder();").appendln((CharSequence)"out.append('{');");
        boolean firstFirstCheck = true;
        boolean alwaysAfter = false;
        int i = 0;
        int lastPos = message.declaredOrderFields().size() - 1;
        for (JField field : message.declaredOrderFields()) {
            if (field.isVoid()) {
                --lastPos;
                continue;
            }
            boolean last = i == lastPos;
            first = i == 0;
            ++i;
            if (!field.alwaysPresent()) {
                if (!alwaysAfter && firstFirstCheck && !last) {
                    this.writer.appendln((CharSequence)"boolean first = true;");
                }
                if (field.container()) {
                    this.writer.formatln("if (%s != null && %s.size() > 0) {", new Object[]{field.param(), field.param()});
                } else {
                    this.writer.formatln("if (%s != null) {", new Object[]{field.param()});
                }
                this.writer.begin();
            }
            if (alwaysAfter) {
                this.writer.appendln((CharSequence)"out.append(',');");
            } else if (!field.alwaysPresent()) {
                if (firstFirstCheck || first) {
                    if (!last) {
                        this.writer.appendln((CharSequence)"first = false;");
                    }
                } else if (last) {
                    this.writer.appendln((CharSequence)"if (!first) out.append(',');");
                } else {
                    this.writer.appendln((CharSequence)"if (first) first = false;").appendln((CharSequence)"else out.append(',');");
                }
            }
            this.writer.formatln("out.append(\"%s:\")", new Object[]{field.name()});
            switch (field.type()) {
                case I32: 
                case I64: 
                case BOOL: {
                    this.writer.formatln("   .append(%s);", new Object[]{field.param()});
                    break;
                }
                case BYTE: 
                case I16: {
                    this.writer.formatln("   .append((int) %s);", new Object[]{field.param()});
                    break;
                }
                case DOUBLE: 
                case MAP: 
                case SET: 
                case LIST: {
                    this.writer.formatln("   .append(%s.asString(%s));", new Object[]{Strings.class.getName(), field.param()});
                    break;
                }
                case STRING: {
                    this.writer.formatln("   .append('\\\"')", new Object[0]).formatln("   .append(%s.escape(%s))", new Object[]{Strings.class.getName(), field.param()}).appendln((CharSequence)"   .append('\\\"');");
                    break;
                }
                case BINARY: {
                    this.writer.appendln((CharSequence)"   .append(\"b64(\")").formatln("   .append(%s.toBase64())", new Object[]{field.param()}).appendln((CharSequence)"   .append(')');");
                    break;
                }
                case MESSAGE: {
                    this.writer.formatln("   .append(%s.asString());", new Object[]{field.param()});
                    break;
                }
                default: {
                    this.writer.formatln("   .append(%s.asString());", new Object[]{field.param()});
                }
            }
            if (!field.alwaysPresent()) {
                this.writer.end().appendln('}');
                if (alwaysAfter || !firstFirstCheck) continue;
                firstFirstCheck = false;
                continue;
            }
            alwaysAfter = true;
        }
        this.writer.appendln((CharSequence)"out.append('}');").appendln((CharSequence)"return out.toString();").end().appendln('}').newline();
    }

    private void appendCreateConstructorBuilderOverload(JMessage<?> message, JField field) {
        BlockCommentBuilder block = new BlockCommentBuilder(this.writer);
        if (field.hasComment()) {
            block.comment(field.comment());
        }
        block.param_("value", "The union value").return_("The created union.").finish();
        this.writer.formatln("public static %s %s(%s value) {", new Object[]{message.instanceType(), JUtils.camelCase("with", field.name()), field.builderMutableType()}).begin().formatln("return %s(value == null ? null : value.build());", new Object[]{JUtils.camelCase("with", field.name())}).end().appendln('}').newline();
    }

    private void appendCreateConstructor(JMessage<?> message) throws GeneratorException {
        if (message.isUnion()) {
            for (JField field : message.declaredOrderFields()) {
                BlockCommentBuilder block = new BlockCommentBuilder(this.writer);
                if (field.hasComment()) {
                    block.comment(field.comment());
                }
                if (field.isVoid()) {
                    block.return_("The created union.").finish();
                    this.writer.formatln("public static %s %s() {", new Object[]{message.instanceType(), JUtils.camelCase("with", field.name())}).begin().formatln("return new _Builder().%s().build();", new Object[]{field.setter()}).end().appendln('}').newline();
                    continue;
                }
                block.param_("value", "The union value").return_("The created union.").finish();
                this.writer.formatln("public static %s %s(%s value) {", new Object[]{message.instanceType(), JUtils.camelCase("with", field.name()), field.valueType()}).begin().formatln("return new _Builder().%s(value).build();", new Object[]{field.setter()}).end().appendln('}').newline();
                if (field.type() != PType.MESSAGE) continue;
                this.appendCreateConstructorBuilderOverload(message, field);
            }
        } else if (message.hasAnnotation(ThriftAnnotation.JAVA_PUBLIC_CONSTRUCTOR) || this.javaOptions.public_constructors) {
            String spaces = message.instanceType().replaceAll("[\\S]", " ");
            this.writer.formatln("public %s(", new Object[]{message.instanceType()}).begin("        " + spaces);
            boolean first = true;
            for (JField jField : message.declaredOrderFields()) {
                if (jField.isVoid()) continue;
                if (first) {
                    first = false;
                } else {
                    this.writer.append(',').appendln();
                }
                this.writer.format("%s %s", new Object[]{jField.paramType(), jField.param()});
            }
            this.writer.end().append((CharSequence)") {").begin();
            if (message.isException()) {
                Optional<JField> msg = message.exceptionMessageField();
                if (msg.isPresent()) {
                    this.writer.formatln("super(%s);", new Object[]{msg.get().param()}).newline();
                } else {
                    this.writer.appendln((CharSequence)"super(createMessage(").begin("                    ");
                    first = true;
                    for (JField field : message.declaredOrderFields()) {
                        if (field.isVoid()) continue;
                        if (first) {
                            first = false;
                        } else {
                            this.writer.append(',').appendln();
                        }
                        this.writer.format("%s", new Object[]{field.param()});
                    }
                    this.writer.append((CharSequence)"));").end().newline();
                }
            }
            block8: for (JField jField : message.declaredOrderFields()) {
                if (jField.isVoid()) continue;
                switch (jField.type()) {
                    case LIST: {
                        this.writer.formatln("if (%s != null) {", new Object[]{jField.param()}).formatln("    %s = %s;", new Object[]{jField.member(), jField.fieldInstanceCopy(jField.param())}).appendln((CharSequence)"} else {");
                        if (jField.alwaysPresent()) {
                            this.writer.formatln("    %s = %s;", new Object[]{jField.member(), jField.kDefault()});
                        } else {
                            this.writer.formatln("    %s = null;", new Object[]{jField.member()});
                        }
                        this.writer.appendln('}');
                        continue block8;
                    }
                    case SET: {
                        this.writer.formatln("if (%s != null) {", new Object[]{jField.param()}).formatln("    %s = %s;", new Object[]{jField.member(), jField.fieldInstanceCopy(jField.param())}).appendln((CharSequence)"} else {");
                        if (jField.alwaysPresent()) {
                            this.writer.formatln("    %s = %s;", new Object[]{jField.member(), jField.kDefault()});
                        } else {
                            this.writer.formatln("    %s = null;", new Object[]{jField.member()});
                        }
                        this.writer.appendln('}');
                        continue block8;
                    }
                    case MAP: {
                        this.writer.formatln("if (%s != null) {", new Object[]{jField.param()}).formatln("    %s = %s;", new Object[]{jField.member(), jField.fieldInstanceCopy(jField.param())}).appendln((CharSequence)"} else {");
                        if (jField.alwaysPresent()) {
                            this.writer.formatln("    %s = %s;", new Object[]{jField.member(), jField.kDefault()});
                        } else {
                            this.writer.formatln("    %s = null;", new Object[]{jField.member()});
                        }
                        this.writer.appendln('}');
                        continue block8;
                    }
                }
                if (!(!jField.alwaysPresent() || jField.isRequired() && jField.isPrimitiveJavaValue())) {
                    this.writer.formatln("if (%s != null) {", new Object[]{jField.param()}).formatln("    %s = %s;", new Object[]{jField.member(), jField.param()}).appendln((CharSequence)"} else {").formatln("    %s = %s;", new Object[]{jField.member(), jField.kDefault()}).appendln('}');
                    continue;
                }
                this.writer.formatln("%s = %s;", new Object[]{jField.member(), jField.param()});
            }
            this.writer.end().appendln('}').newline();
        }
    }
}

