/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.GeneratorOptions;
import net.morimekta.providence.generator.format.java.JavaOptions;
import net.morimekta.providence.generator.format.java.messages.BuilderCommonMemberFormatter;
import net.morimekta.providence.generator.format.java.messages.BuilderCoreOverridesFormatter;
import net.morimekta.providence.generator.format.java.messages.CommonBuilderFormatter;
import net.morimekta.providence.generator.format.java.messages.CommonMemberFormatter;
import net.morimekta.providence.generator.format.java.messages.CommonOverridesFormatter;
import net.morimekta.providence.generator.format.java.messages.CoreOverridesFormatter;
import net.morimekta.providence.generator.format.java.messages.extras.BinaryReaderBuilderFormatter;
import net.morimekta.providence.generator.format.java.messages.extras.BinarySerializableFormatter;
import net.morimekta.providence.generator.format.java.messages.extras.BinaryWriterFormatter;
import net.morimekta.providence.generator.format.java.messages.extras.HazelcastPortableMessageFormatter;
import net.morimekta.providence.generator.format.java.messages.extras.JacksonMessageFormatter;
import net.morimekta.providence.generator.format.java.shared.BaseMessageFormatter;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.util.io.IndentedPrintWriter;

public class JavaMessageFormatter
extends BaseMessageFormatter {
    public JavaMessageFormatter(IndentedPrintWriter writer, JHelper helper, GeneratorOptions generatorOptions, JavaOptions options) {
        this(false, false, writer, helper, generatorOptions, options);
    }

    public JavaMessageFormatter(boolean inner, boolean makeProtected, IndentedPrintWriter writer, JHelper helper, GeneratorOptions generatorOptions, JavaOptions options) {
        super(inner, makeProtected, writer, helper, JavaMessageFormatter.getFormatters(writer, helper, generatorOptions, options));
    }

    @Override
    public String getClassName(JMessage<?> message) {
        return message.instanceType();
    }

    private static List<MessageMemberFormatter> getFormatters(IndentedPrintWriter writer, JHelper helper, GeneratorOptions generatorOptions, JavaOptions javaOptions) {
        ImmutableList.Builder builderFormatters = ImmutableList.builder();
        builderFormatters.add((Object)new BuilderCommonMemberFormatter(writer, helper)).add((Object)new BuilderCoreOverridesFormatter(writer, helper));
        if (javaOptions.hazelcast_portable) {
            builderFormatters.add((Object)new HazelcastPortableMessageFormatter(writer, helper));
        }
        ImmutableList.Builder formatters = ImmutableList.builder();
        formatters.add((Object)new CommonMemberFormatter(writer, helper, generatorOptions, javaOptions)).add((Object)new CoreOverridesFormatter(writer)).add((Object)new CommonOverridesFormatter(writer)).add((Object)new BinarySerializableFormatter(writer, helper));
        if (javaOptions.jackson) {
            formatters.add((Object)new JacksonMessageFormatter(writer, helper));
        }
        if (javaOptions.rw_binary) {
            formatters.add((Object)new BinaryWriterFormatter(writer, helper));
            builderFormatters.add((Object)new BinaryReaderBuilderFormatter(writer, helper));
        }
        formatters.add((Object)new CommonBuilderFormatter(writer, helper, (List<MessageMemberFormatter>)builderFormatters.build()));
        return formatters.build();
    }

    @Override
    public void appendMessageClass(PMessageDescriptor<?, ?> descriptor) throws GeneratorException {
        super.appendMessageClass(descriptor);
        this.writer.newline();
    }
}

