/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages.extras;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.IndentedPrintWriter;

public class BinaryReaderBuilderFormatter
implements MessageMemberFormatter {
    private final AtomicInteger nextId = new AtomicInteger(1);
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public BinaryReaderBuilderFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    @Override
    public Collection<String> getExtraImplements(JMessage<?> message) throws GeneratorException {
        return ImmutableList.of((Object)BinaryReader.class.getName());
    }

    private void appendReadFieldValue(String member, JMessage message, JField field, PDescriptor descriptor) {
        switch (descriptor.getType()) {
            case VOID: {
                break;
            }
            case BOOL: {
                this.writer.formatln("%s = reader.expectUInt8() == 1;", new Object[]{member});
                break;
            }
            case BYTE: {
                this.writer.formatln("%s = reader.expectByte();", new Object[]{member});
                break;
            }
            case I16: {
                this.writer.formatln("%s = reader.expectShort();", new Object[]{member});
                break;
            }
            case I32: {
                this.writer.formatln("%s = reader.expectInt();", new Object[]{member});
                break;
            }
            case I64: {
                this.writer.formatln("%s = reader.expectLong();", new Object[]{member});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s = reader.expectDouble();", new Object[]{member});
                break;
            }
            case BINARY: {
                String tmp = "len_" + this.nextId.getAndIncrement();
                this.writer.formatln("int %s = reader.expectUInt32();", new Object[]{tmp});
                this.writer.formatln("%s = reader.expectBinary(%s);", new Object[]{member, tmp});
                break;
            }
            case STRING: {
                String tmp = "len_" + this.nextId.getAndIncrement();
                this.writer.formatln("int %s = reader.expectUInt32();", new Object[]{tmp});
                this.writer.formatln("%s = new String(reader.expectBytes(%s), %s.UTF_8);", new Object[]{member, tmp, StandardCharsets.class.getName()});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s = %s.findById(reader.expectInt());", new Object[]{member, this.helper.getFieldType(descriptor)});
                break;
            }
            case MAP: {
                PMap pMap = (PMap)descriptor;
                if (field == null) {
                    throw new GeneratorException("Impossible!");
                }
                if (pMap.keyDescriptor() instanceof PContainer || pMap.itemDescriptor() instanceof PContainer) {
                    this.writer.formatln("%s = (%s) %s.readFieldValue(reader, new %s(field, type), _Field.%s.getDescriptor(), strict);", new Object[]{member, field.fieldType(), BinaryFormatUtils.class.getName(), BinaryFormatUtils.FieldInfo.class.getName().replaceAll("\\$", "."), field.fieldEnum(), this.helper.getFieldType(descriptor)});
                    break;
                }
                String builder = "b_" + this.nextId.getAndIncrement();
                this.writer.formatln("%s<%s,%s> %s = new %s<>();", new Object[]{field.builderInstanceType(), this.helper.getFieldType(pMap.keyDescriptor()), this.helper.getFieldType(pMap.itemDescriptor()), builder, field.builderInstanceType()});
                String len = "len_" + this.nextId.getAndIncrement();
                String keyType = "t_" + this.nextId.getAndIncrement();
                String valueType = "t_" + this.nextId.getAndIncrement();
                this.writer.formatln("byte %s = reader.expectByte();", new Object[]{keyType}).formatln("byte %s = reader.expectByte();", new Object[]{valueType}).formatln("if (%s == %d && %s == %d) {", new Object[]{keyType, BinaryType.forType((PType)pMap.keyDescriptor().getType()), valueType, BinaryType.forType((PType)pMap.itemDescriptor().getType())}).begin().formatln("final int %s = reader.expectUInt32();", new Object[]{len});
                String i = "i_" + this.nextId.getAndIncrement();
                this.writer.formatln("for (int %s = 0; %s < %s; ++%s) {", new Object[]{i, i, len, i}).begin();
                String key = "key_" + this.nextId.getAndIncrement();
                String value = "val_" + this.nextId.getAndIncrement();
                String keyMember = String.format(Locale.US, "%s %s", this.helper.getValueType(pMap.keyDescriptor()), key);
                String valueMember = String.format(Locale.US, "%s %s", this.helper.getValueType(pMap.itemDescriptor()), value);
                this.appendReadFieldValue(keyMember, null, null, pMap.keyDescriptor());
                this.appendReadFieldValue(valueMember, null, null, pMap.itemDescriptor());
                this.writer.formatln("%s.put(%s, %s);", new Object[]{builder, key, value});
                this.writer.end().appendln('}');
                this.writer.formatln("%s = %s.build();", new Object[]{member, builder});
                this.writer.end().appendln((CharSequence)"} else {").formatln("    throw new %s(", new Object[]{SerializerException.class.getName()}).formatln("            \"Wrong key type \" + %s.asString(%s) +", new Object[]{BinaryType.class.getName(), keyType}).formatln("            \" or value type \" + %s.asString(%s) +", new Object[]{BinaryType.class.getName(), valueType}).formatln("            \" for %s.%s, should be %s and %s\");", new Object[]{message.descriptor().getQualifiedName(), field.name(), BinaryType.asString((byte)BinaryType.forType((PType)pMap.keyDescriptor().getType())), BinaryType.asString((byte)BinaryType.forType((PType)pMap.itemDescriptor().getType()))}).appendln('}');
                break;
            }
            case LIST: 
            case SET: {
                if (field == null) {
                    throw new GeneratorException("Impossible!");
                }
                PContainer pCont = (PContainer)descriptor;
                if (pCont.itemDescriptor() instanceof PContainer) {
                    this.writer.formatln("%s = (%s) %s.readFieldValue(reader, new %s(field, type), _Field.%s.getDescriptor(), strict);", new Object[]{member, field.fieldType(), BinaryFormatUtils.class.getName(), BinaryFormatUtils.FieldInfo.class.getName().replaceAll("\\$", "."), field.fieldEnum(), this.helper.getFieldType(descriptor)});
                    break;
                }
                String builder = "b_" + this.nextId.getAndIncrement();
                this.writer.formatln("%s<%s> %s = new %s<>();", new Object[]{field.builderInstanceType(), this.helper.getFieldType(pCont.itemDescriptor()), builder, field.builderInstanceType()});
                String len = "len_" + this.nextId.getAndIncrement();
                String itemType = "t_" + this.nextId.getAndIncrement();
                this.writer.formatln("byte %s = reader.expectByte();", new Object[]{itemType}).formatln("if (%s == %d) {", new Object[]{itemType, BinaryType.forType((PType)pCont.itemDescriptor().getType())}).begin().formatln("final int %s = reader.expectUInt32();", new Object[]{len});
                String i = "i_" + this.nextId.getAndIncrement();
                this.writer.formatln("for (int %s = 0; %s < %s; ++%s) {", new Object[]{i, i, len, i}).begin();
                String item = "key_" + this.nextId.getAndIncrement();
                String itemMember = String.format(Locale.US, "%s %s", this.helper.getValueType(pCont.itemDescriptor()), item);
                this.appendReadFieldValue(itemMember, null, null, pCont.itemDescriptor());
                this.writer.formatln("%s.add(%s);", new Object[]{builder, item});
                this.writer.end().appendln('}');
                this.writer.formatln("%s = %s.build();", new Object[]{member, builder});
                this.writer.end().appendln((CharSequence)"} else {").formatln("    throw new %s(\"Wrong item type \" + %s.asString(%s) + \" for %s.%s, should be %s\");", new Object[]{SerializerException.class.getName(), BinaryType.class.getName(), itemType, message.descriptor().getQualifiedName(), field.name(), BinaryType.asString((byte)BinaryType.forType((PType)pCont.itemDescriptor().getType()))}).appendln('}');
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s = %s.readMessage(reader, %s.kDescriptor, strict);", new Object[]{member, BinaryFormatUtils.class.getName(), this.helper.getFieldType(descriptor)});
                break;
            }
            default: {
                throw new GeneratorException("Unsupported binary writer type: " + descriptor.getQualifiedName());
            }
        }
    }

    @Override
    public void appendMethods(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").formatln("public void readBinary(%s reader, boolean strict) throws %s {", new Object[]{BigEndianBinaryReader.class.getName(), IOException.class.getName()}).begin();
        this.writer.appendln((CharSequence)"byte type = reader.expectByte();").formatln("while (type != %d) {", new Object[]{(byte)0}).begin();
        this.writer.appendln((CharSequence)"int field = reader.expectShort();").appendln((CharSequence)"switch (field) {").begin();
        for (JField field : message.numericalOrderFields()) {
            this.writer.formatln("case %d: {", new Object[]{field.id()}).begin();
            this.writer.formatln("if (type == %d) {", new Object[]{BinaryType.forType((PType)field.type())}).begin();
            this.appendReadFieldValue(field.member(), message, field, field.field().getDescriptor());
            if (message.isUnion()) {
                this.writer.formatln("%s = _Field.%s;", new Object[]{"tUnionField", field.fieldEnum()});
            } else {
                this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
            }
            this.writer.end().appendln((CharSequence)"} else {").formatln("    throw new %s(\"Wrong type \" + %s.asString(type) + \" for %s.%s, should be %s\");", new Object[]{SerializerException.class.getName(), BinaryType.class.getName(), message.descriptor().getQualifiedName(), field.name(), BinaryType.asString((byte)BinaryType.forType((PType)message.descriptor().getType()))}).appendln('}');
            this.writer.appendln((CharSequence)"break;").end().appendln('}');
        }
        this.writer.appendln((CharSequence)"default: {").formatln("    %s.readFieldValue(reader, new %s(field, type), null, false);", new Object[]{BinaryFormatUtils.class.getName(), BinaryFormatUtils.FieldInfo.class.getName().replaceAll("\\$", ".")}).appendln((CharSequence)"    break;").appendln('}');
        this.writer.end().appendln('}');
        this.writer.appendln((CharSequence)"type = reader.expectByte();").end().appendln((CharSequence)"}");
        this.writer.end().appendln('}').newline();
    }
}

