/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.enums;

import javax.annotation.Generated;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.GeneratorOptions;
import net.morimekta.providence.generator.format.java.JavaOptions;
import net.morimekta.providence.generator.format.java.shared.EnumMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CEnumValue;
import net.morimekta.util.io.IndentedPrintWriter;

public class CommonMemberFormatter
implements EnumMemberFormatter {
    private final IndentedPrintWriter writer;
    private final JavaOptions javaOptions;
    private final GeneratorOptions generatorOptions;

    public CommonMemberFormatter(IndentedPrintWriter writer, GeneratorOptions generatorOptions, JavaOptions javaOptions) {
        this.writer = writer;
        this.generatorOptions = generatorOptions;
        this.javaOptions = javaOptions;
    }

    @Override
    public void appendClassAnnotations(CEnumDescriptor type) throws GeneratorException {
        if (JAnnotation.isDeprecated((CAnnotatedDescriptor)type)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        if (this.javaOptions.generated_annotation_version) {
            this.writer.formatln("@%s(\"%s %s\")", new Object[]{Generated.class.getName(), this.generatorOptions.generator_program_name, this.generatorOptions.program_version});
        } else {
            this.writer.formatln("@%s(\"%s\")", new Object[]{Generated.class.getName(), this.generatorOptions.generator_program_name});
        }
    }

    public void appendStaticGetter_FindBy(CEnumDescriptor type, String simpleClass) {
        new BlockCommentBuilder(this.writer).comment("Find a value based in its ID").newline().param_("id", "Id of value").return_("Value found or null").finish();
        this.writer.formatln("public static %s findById(int id) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"switch (id) {").begin();
        for (CEnumValue value : type.getValues()) {
            this.writer.formatln("case %d: return %s.%s;", new Object[]{value.asInteger(), simpleClass, JUtils.enumConst((PEnumValue)value)});
        }
        this.writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
        new BlockCommentBuilder(this.writer).comment("Find a value based in its name").newline().param_("name", "Name of value").return_("Value found or null").finish();
        this.writer.formatln("public static %s findByName(String name) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"if (name == null) {").formatln("    throw new IllegalArgumentException(\"Null name given\");", new Object[]{type.getQualifiedName()}).appendln((CharSequence)"}").appendln((CharSequence)"switch (name) {").begin();
        for (CEnumValue value : type.getValues()) {
            this.writer.formatln("case \"%s\": return %s.%s;", new Object[]{value.asString(), simpleClass, JUtils.enumConst((PEnumValue)value)});
        }
        this.writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
    }

    public void appendStaticGetter_ValueFor(CEnumDescriptor type, String simpleClass) {
        new BlockCommentBuilder(this.writer).comment("Get a value based in its ID").newline().param_("id", "Id of value").return_("Value found").throws_(IllegalArgumentException.class.getSimpleName(), "If no value for id is found").finish();
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull").formatln("public static %s valueForId(int id) {", new Object[]{simpleClass}).formatln("    %s value = findById(id);", new Object[]{simpleClass}).appendln((CharSequence)"    if (value == null) {").formatln("        throw new IllegalArgumentException(\"No %s for id \" + id);", new Object[]{type.getQualifiedName()}).appendln((CharSequence)"    }").appendln((CharSequence)"    return value;").appendln('}').newline();
        new BlockCommentBuilder(this.writer).comment("Get a value based in its name").newline().param_("name", "Name of value").return_("Value found").throws_(IllegalArgumentException.class.getSimpleName(), "If no value for name is found, or null name").finish();
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull").formatln("public static %s valueForName(String name) {", new Object[]{simpleClass}).formatln("    %s value = findByName(name);", new Object[]{simpleClass}).appendln((CharSequence)"    if (value == null) {").formatln("        throw new IllegalArgumentException(\"No %s for name \\\"\" + name + \"\\\"\");", new Object[]{type.getQualifiedName()}).appendln((CharSequence)"    }").appendln((CharSequence)"    return value;").appendln('}').newline();
    }

    @Override
    public void appendExtraProperties(CEnumDescriptor type) throws GeneratorException {
        String simpleClass = JUtils.getClassName(type);
        this.appendStaticGetter_FindBy(type, simpleClass);
        this.appendStaticGetter_ValueFor(type, simpleClass);
    }
}

