/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import java.io.IOException;
import java.util.ArrayList;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JServiceMethod;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.reflect.contained.CServiceMethod;
import net.morimekta.providence.util.ThriftAnnotation;

public class JService {
    private final CService service;
    private final JHelper helper;

    public JService(CService service, JHelper helper) {
        this.service = service;
        this.helper = helper;
    }

    public String className() {
        return JUtils.getClassName((PService)this.service);
    }

    public JServiceMethod[] methods() {
        ArrayList methods = new ArrayList(this.service.getMethodsIncludingExtended());
        CServiceMethod[] ma = methods.toArray(new CServiceMethod[methods.size()]);
        JServiceMethod[] ret = new JServiceMethod[ma.length];
        for (int i = 0; i < methods.size(); ++i) {
            ret[i] = new JServiceMethod(this.service, ma[i], this.helper);
        }
        return ret;
    }

    public JServiceMethod[] declaredMethods() {
        ArrayList methods = new ArrayList(this.service.getMethods());
        CServiceMethod[] ma = methods.toArray(new CServiceMethod[methods.size()]);
        JServiceMethod[] ret = new JServiceMethod[ma.length];
        for (int i = 0; i < methods.size(); ++i) {
            ret[i] = new JServiceMethod(this.service, ma[i], this.helper);
        }
        return ret;
    }

    public String getRequestClassRef(JServiceMethod method) {
        if (!this.isDeclaredMethod(method)) {
            if (this.service.getExtendsService() == null) {
                throw new GeneratorException("Unable to find source service of method: " + method.name() + " context: " + this.service.getQualifiedName());
            }
            return new JService(this.service.getExtendsService(), this.helper).getRequestClassRef(method);
        }
        return this.helper.getJavaPackage((PService)this.service) + "." + this.className() + "." + method.getRequestClass();
    }

    public String getResponseClassRef(JServiceMethod method) {
        if (method.getResponseClass() == null) {
            return null;
        }
        if (!this.isDeclaredMethod(method)) {
            if (this.service.getExtendsService() == null) {
                throw new GeneratorException("Unable to find source service of method: " + method.name() + " context: " + this.service.getQualifiedName());
            }
            return new JService(this.service.getExtendsService(), this.helper).getResponseClassRef(method);
        }
        return this.helper.getJavaPackage((PService)this.service) + "." + this.className() + "." + method.getResponseClass();
    }

    public boolean isDeclaredMethod(JServiceMethod ref) {
        for (PServiceMethod method : this.service.getMethods()) {
            if (!method.getName().equals(ref.name())) continue;
            return true;
        }
        return false;
    }

    public String methodsThrows(JServiceMethod method) {
        if (!this.isDeclaredMethod(method)) {
            if (this.service.getExtendsService() == null) {
                throw new GeneratorException("Unable to find source service of method: " + method.name() + " context: " + this.service.getQualifiedName());
            }
            return new JService(this.service.getExtendsService(), this.helper).methodsThrows(method);
        }
        if (this.service.hasAnnotation(ThriftAnnotation.JAVA_SERVICE_METHOD_THROWS)) {
            String doThrow = this.service.getAnnotationValue(ThriftAnnotation.JAVA_SERVICE_METHOD_THROWS);
            if (!IOException.class.getName().equals(doThrow)) {
                if (Exception.class.getName().equals(doThrow) || Exception.class.getSimpleName().equals(doThrow)) {
                    throw new GeneratorException("Not allowed to declare '" + doThrow + "' as the service thrown exception. Annotation: " + ThriftAnnotation.JAVA_SERVICE_METHOD_THROWS.tag);
                }
                return doThrow;
            }
        }
        return null;
    }

    public CService getService() {
        return this.service;
    }
}

