/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PExceptionDescriptor;
import net.morimekta.providence.descriptor.PExceptionDescriptorProvider;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptorProvider;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessage;
import net.morimekta.providence.util.ThriftAnnotation;

public class JMessage<T extends CMessage<T>> {
    private final PMessageDescriptor<T, CField> descriptor;
    private final ArrayList<JField> declaredFields;
    private final ArrayList<JField> numericalFields;

    public JMessage(PMessageDescriptor<T, CField> descriptor, JHelper helper) {
        this.descriptor = descriptor;
        this.declaredFields = new ArrayList(((CField[])descriptor.getFields()).length);
        CField[] fields = (CField[])descriptor.getFields();
        for (int i = 0; i < fields.length; ++i) {
            this.declaredFields.add(new JField(fields[i], helper, i));
        }
        this.numericalFields = new ArrayList<JField>(this.declaredFields);
        this.numericalFields.sort(Comparator.comparingInt(JField::id));
    }

    public PMessageDescriptor<T, CField> descriptor() {
        return this.descriptor;
    }

    public PMessageVariant variant() {
        return this.descriptor.getVariant();
    }

    public boolean isException() {
        return this.descriptor.getVariant() == PMessageVariant.EXCEPTION;
    }

    public boolean isUnion() {
        return this.descriptor.getVariant() == PMessageVariant.UNION;
    }

    public boolean jsonCompactible() {
        if (this.descriptor().getVariant() != PMessageVariant.STRUCT) {
            return false;
        }
        if (!this.hasAnnotation(ThriftAnnotation.JSON_COMPACT) && !this.hasAnnotation("compact")) {
            return false;
        }
        if (this.declaredFields.size() > 10) {
            return false;
        }
        int next = 1;
        boolean hasOptional = false;
        for (JField field : this.declaredFields) {
            if (field.id() != next) {
                return false;
            }
            if (hasOptional && field.isRequired()) {
                return false;
            }
            if (!field.isRequired()) {
                hasOptional = true;
            }
            ++next;
        }
        return true;
    }

    public String instanceType() {
        return JUtils.getClassName(this.descriptor);
    }

    public List<JField> declaredOrderFields() {
        return this.declaredFields;
    }

    public List<JField> numericalOrderFields() {
        return this.numericalFields;
    }

    public String getDescriptorClass() throws GeneratorException {
        switch (this.variant()) {
            case STRUCT: {
                return PStructDescriptor.class.getName();
            }
            case UNION: {
                return PUnionDescriptor.class.getName();
            }
            case EXCEPTION: {
                return PExceptionDescriptor.class.getName();
            }
        }
        throw new GeneratorException("Unable to determine type class for " + this.variant());
    }

    public String getProviderClass() throws GeneratorException {
        switch (this.variant()) {
            case STRUCT: {
                return PStructDescriptorProvider.class.getName();
            }
            case UNION: {
                return PUnionDescriptorProvider.class.getName();
            }
            case EXCEPTION: {
                return PExceptionDescriptorProvider.class.getName();
            }
        }
        throw new GeneratorException("Unable to determine type class for " + this.variant());
    }

    public String extraImplements() {
        return this.getAnnotationValue(ThriftAnnotation.JAVA_IMPLEMENTS);
    }

    public String exceptionBaseClass() {
        if (!this.isException()) {
            return null;
        }
        if (this.hasAnnotation(ThriftAnnotation.JAVA_EXCEPTION_CLASS)) {
            return this.getAnnotationValue(ThriftAnnotation.JAVA_EXCEPTION_CLASS);
        }
        return Exception.class.getSimpleName();
    }

    public Optional<JField> exceptionMessageField() {
        return this.numericalOrderFields().stream().filter(f -> f.name().equals("message") && f.type() == PType.STRING).findFirst();
    }

    public boolean hasAnnotation(ThriftAnnotation annotation) {
        return this.descriptor instanceof CAnnotatedDescriptor && ((CAnnotatedDescriptor)this.descriptor).hasAnnotation(annotation);
    }

    public boolean hasAnnotation(String annotation) {
        return this.descriptor instanceof CAnnotatedDescriptor && ((CAnnotatedDescriptor)this.descriptor).hasAnnotation(annotation);
    }

    private String getAnnotationValue(ThriftAnnotation annotation) {
        return this.getAnnotationValue(annotation.tag);
    }

    private String getAnnotationValue(String annotation) {
        if (this.descriptor instanceof CAnnotatedDescriptor && ((CAnnotatedDescriptor)this.descriptor).hasAnnotation(annotation)) {
            return ((CAnnotatedDescriptor)this.descriptor).getAnnotationValue(annotation);
        }
        return null;
    }
}

