/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages.extras;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.util.io.IndentedPrintWriter;

public class JacksonMessageFormatter
implements MessageMemberFormatter {
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public JacksonMessageFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    @Override
    public void appendClassAnnotations(JMessage<?> message) {
        this.writer.formatln("@%s(", new Object[]{JsonSerialize.class.getName()}).formatln("        using = %s._Serializer.class)", new Object[]{message.instanceType()});
        this.writer.formatln("@%s(", new Object[]{JsonDeserialize.class.getName()}).formatln("        using = %s._Deserializer.class)", new Object[]{message.instanceType()});
    }

    @Override
    public void appendExtraProperties(JMessage<?> message) throws GeneratorException {
        this.appendJacksonDeserializer(message);
        this.appendJacksonSerializer(message);
    }

    private void appendReadValue(JField field) throws GeneratorException {
        switch (field.type()) {
            case MAP: {
                PMap mType = (PMap)field.field().getDescriptor();
                PDescriptor kType = mType.keyDescriptor();
                this.writer.formatln("%s kType = ctxt.getTypeFactory().constructSimpleType(%s.class, null);", new Object[]{JavaType.class.getName(), this.helper.getFieldType(kType)});
                PDescriptor iType = mType.itemDescriptor();
                if (iType instanceof PMap) {
                    PMap imType = (PMap)iType;
                    PDescriptor ikType = imType.keyDescriptor();
                    PDescriptor iiType = imType.itemDescriptor();
                    if (iiType instanceof PContainer) {
                        throw new GeneratorException("Too many levels of containers: " + field.toString());
                    }
                    this.writer.formatln("%s iType = ctxt.getTypeFactory().constructMapType(%s.class, %s.class, %s.class);", new Object[]{MapType.class.getName(), HashMap.class.getName(), this.helper.getFieldType(ikType), this.helper.getFieldType(iiType)});
                } else if (iType instanceof PContainer) {
                    PContainer icType = (PContainer)iType;
                    PDescriptor iiType = icType.itemDescriptor();
                    if (iiType instanceof PContainer) {
                        throw new GeneratorException("Too many levels of containers: " + field.toString());
                    }
                    this.writer.formatln("%s iType = ctxt.getTypeFactory().constructArrayType(%s.class);", new Object[]{MapType.class.getName(), this.helper.getFieldType(iiType)});
                } else {
                    this.writer.formatln("%s iType = ctxt.getTypeFactory().constructSimpleType(%s.class, null);", new Object[]{JavaType.class.getName(), this.helper.getFieldType(iType)});
                }
                this.writer.formatln("%s type = ctxt.getTypeFactory().constructMapType(%s.class, kType, iType);", new Object[]{MapType.class.getName(), HashMap.class.getName()});
                this.writer.formatln("builder.%s(ctxt.readValue(jp, type));", new Object[]{field.setter()});
                break;
            }
            case SET: 
            case LIST: {
                PContainer cType = (PContainer)field.field().getDescriptor();
                PDescriptor iType = cType.itemDescriptor();
                if (iType instanceof PMap) {
                    PMap imType = (PMap)iType;
                    PDescriptor ikType = imType.keyDescriptor();
                    PDescriptor iiType = imType.itemDescriptor();
                    this.writer.formatln("%s itype = ctxt.getTypeFactory().constructMapType(%s.class, %s.class, %s.class);", new Object[]{MapType.class.getName(), LinkedHashMap.class.getName(), this.helper.getFieldType(ikType), this.helper.getFieldType(iiType)});
                    this.writer.formatln("%s type = ctxt.getTypeFactory().constructArrayType(itype);", new Object[]{ArrayType.class.getName(), this.helper.getFieldType(iType)});
                    this.writer.formatln("builder.%s(%s.asList(ctxt.readValue(jp, type)));", new Object[]{field.setter(), Arrays.class.getName()});
                    break;
                }
                if (iType instanceof PContainer) {
                    PContainer icType = (PContainer)iType;
                    PDescriptor iiType = icType.itemDescriptor();
                    this.writer.formatln("%s itype = ctxt.getTypeFactory().constructArrayType(%s.class);", new Object[]{ArrayType.class.getName(), this.helper.getFieldType(iiType)});
                    this.writer.formatln("%s type = ctxt.getTypeFactory().constructArrayType(itype);", new Object[]{ArrayType.class.getName(), this.helper.getFieldType(iType)});
                    this.writer.formatln("builder.%s(%s.asList(ctxt.readValue(jp, type)));", new Object[]{field.setter(), Arrays.class.getName()});
                    break;
                }
                this.writer.formatln("%s type = ctxt.getTypeFactory().constructArrayType(%s.class);", new Object[]{ArrayType.class.getName(), this.helper.getFieldType(iType)});
                this.writer.formatln("builder.%s(%s.asList(ctxt.readValue(jp, type)));", new Object[]{field.setter(), Arrays.class.getName()});
                break;
            }
            case BINARY: 
            case STRING: 
            case MESSAGE: 
            case ENUM: {
                this.writer.formatln("builder.%s(ctxt.readValue(jp, %s.class));", new Object[]{field.setter(), field.instanceType()});
                break;
            }
            default: {
                this.writer.formatln("builder.%s(ctxt.readValue(jp, %s.TYPE));", new Object[]{field.setter(), field.instanceType()});
            }
        }
    }

    private void appendWriteValue(JField field) {
        switch (field.type()) {
            case VOID: {
                this.writer.formatln("provider.defaultSerializeField(\"%s\", true, generator);", new Object[]{field.name()});
                break;
            }
            default: {
                this.writer.formatln("provider.defaultSerializeField(\"%s\", instance.%s, generator);", new Object[]{field.name(), field.member()});
            }
        }
    }

    private void appendJacksonDeserializer(JMessage<?> message) throws GeneratorException {
        this.writer.formatln("public static class _Deserializer extends %s<%s> {", new Object[]{JsonDeserializer.class.getName(), message.instanceType()}).begin();
        this.writer.appendln((CharSequence)"@Override").formatln("public %s deserialize(%s jp,", new Object[]{message.instanceType(), JsonParser.class.getName()}).formatln("       %s             %s ctxt)", new Object[]{message.instanceType().replaceAll("[\\S]", " "), DeserializationContext.class.getName()}).formatln("         throws %s,", new Object[]{IOException.class.getName()}).formatln("                %s {", new Object[]{JsonProcessingException.class.getName()}).begin();
        this.writer.appendln((CharSequence)"_Builder builder = builder();").newline();
        this.writer.formatln("if (jp.isExpectedStartObjectToken()) {", new Object[0]).begin().formatln("while (jp.nextToken() != %s.END_OBJECT) {", new Object[]{JsonToken.class.getName()}).begin().formatln("if (jp.getCurrentToken() != %s.FIELD_NAME) {", new Object[]{JsonToken.class.getName()}).formatln("    throw new %s(jp, \"Invalid field name token \" + jp.getText());", new Object[]{JsonParseException.class.getName()}).appendln('}').newline().appendln((CharSequence)"String field = jp.getCurrentName();").appendln((CharSequence)"jp.nextToken();").appendln((CharSequence)"switch (field) {").begin();
        for (JField field : message.declaredOrderFields()) {
            this.writer.formatln("case \"%d\":", new Object[]{field.id()}).formatln("case \"%s\": {", new Object[]{field.name()}).begin();
            this.appendReadValue(field);
            this.writer.appendln((CharSequence)"break;").end().appendln('}');
        }
        this.writer.end().appendln((CharSequence)"}").end().appendln((CharSequence)"}");
        if (message.jsonCompactible()) {
            this.writer.end().appendln((CharSequence)"} else if (jp.isExpectedStartArrayToken()) {").begin();
            this.writer.appendln((CharSequence)"int idx = 0;").formatln("while (jp.nextToken() != %s.END_ARRAY) {", new Object[]{JsonToken.class.getName()}).begin().appendln((CharSequence)"switch (idx++) {").begin();
            for (JField field : message.declaredOrderFields()) {
                this.writer.formatln("case %d: {", new Object[]{field.index()}).begin();
                this.appendReadValue(field);
                this.writer.appendln((CharSequence)"break;").end().appendln('}');
            }
            this.writer.appendln((CharSequence)"default:").formatln("    throw new %s(jp, \"Unexpected value: \" + jp.getText());", new Object[]{JsonParseException.class.getName()}).end().appendln('}').end().appendln('}');
        }
        this.writer.end().appendln((CharSequence)"} else {").formatln("    throw new %s(jp, \"Invalid token for object deserialization \" + jp.getText());", new Object[]{JsonParseException.class.getName()}).appendln('}').newline().appendln((CharSequence)"return builder.build();");
        this.writer.end().formatln("}", new Object[0]).end().formatln("}", new Object[0]).newline();
    }

    private void appendJacksonSerializer(JMessage<?> message) throws GeneratorException {
        this.writer.formatln("public static class _Serializer extends %s<%s> {", new Object[]{JsonSerializer.class.getName(), message.instanceType()}).begin().appendln((CharSequence)"@Override").formatln("public void serialize(%s instance, %s generator, %s provider)", new Object[]{message.instanceType(), JsonGenerator.class.getName(), SerializerProvider.class.getName()}).formatln("        throws %s, %s {", new Object[]{IOException.class.getName(), JsonProcessingException.class.getName()}).begin();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"generator.writeStartObject();").formatln("switch (instance.%s) {", new Object[]{"tUnionField"}).begin();
            for (JField jField : message.declaredOrderFields()) {
                this.writer.formatln("case %s: {", new Object[]{jField.fieldEnum()}).begin();
                this.appendWriteValue(jField);
                this.writer.appendln((CharSequence)"break;").end().appendln('}');
            }
            this.writer.end().appendln('}').appendln((CharSequence)"generator.writeEndObject();");
        } else {
            if (message.jsonCompactible()) {
                this.writer.formatln("if (instance.jsonCompact()) {", new Object[0]).begin().formatln("generator.writeStartArray();", new Object[0]);
                int ifStack = 0;
                for (JField field : message.numericalOrderFields()) {
                    if (!field.alwaysPresent() && !field.isRequired()) {
                        this.writer.formatln("if (instance.%s != null) {", new Object[]{field.member()}).begin();
                        ++ifStack;
                    }
                    this.writer.formatln("provider.defaultSerializeValue(instance.%s, generator);", new Object[]{field.member()});
                }
                while (ifStack-- > 0) {
                    this.writer.end().appendln('}');
                }
                this.writer.formatln("generator.writeEndArray();", new Object[0]);
                this.writer.end().appendln((CharSequence)"} else {").begin();
            }
            this.writer.formatln("generator.writeStartObject();", new Object[0]);
            for (JField jField : message.numericalOrderFields()) {
                if (!jField.alwaysPresent() && !jField.isRequired()) {
                    this.writer.formatln("if (instance.%s != null) {", new Object[]{jField.member()}).begin();
                }
                this.appendWriteValue(jField);
                if (jField.alwaysPresent() || jField.isRequired()) continue;
                this.writer.end().appendln('}');
            }
            this.writer.appendln((CharSequence)"generator.writeEndObject();");
            if (message.jsonCompactible()) {
                this.writer.end().appendln('}');
            }
        }
        this.writer.end().formatln("}", new Object[0]).end().formatln("}", new Object[0]).newline();
    }
}

