/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages.extras;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.concurrent.atomic.AtomicInteger;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.util.io.IndentedPrintWriter;

public class BinarySerializableFormatter
implements MessageMemberFormatter {
    public static final String T_SERIALIZE_INSTANCE = "tSerializeInstance";
    private final AtomicInteger nextId = new AtomicInteger(1);
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public BinarySerializableFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    @Override
    public void appendFields(JMessage<?> message) throws GeneratorException {
        this.writer.appendln((CharSequence)"// Transient object used during java deserialization.").formatln("private transient %s tSerializeInstance;", new Object[]{message.instanceType()}).newline();
    }

    @Override
    public void appendMethods(JMessage<?> message) {
        this.appendWriteObject();
        this.appendReadObject(message);
        this.appendReadResolve();
    }

    private void appendWriteObject() {
        this.writer.formatln("private void writeObject(%s oos) throws %s {", new Object[]{ObjectOutputStream.class.getName(), IOException.class.getName()}).appendln((CharSequence)"    oos.defaultWriteObject();").formatln("    %s serializer = new %s(false);", new Object[]{BinarySerializer.class.getName(), BinarySerializer.class.getName()}).appendln((CharSequence)"    serializer.serialize(oos, this);").appendln((CharSequence)"}").newline();
    }

    private void appendReadObject(JMessage<?> message) {
        this.writer.formatln("private void readObject(%s ois)", new Object[]{ObjectInputStream.class.getName()}).formatln("        throws %s, %s {", new Object[]{IOException.class.getName(), ClassNotFoundException.class.getSimpleName()}).begin().formatln("ois.defaultReadObject();", new Object[0]).formatln("%s serializer = new %s(false);", new Object[]{BinarySerializer.class.getName(), BinarySerializer.class.getName()}).appendln((CharSequence)"tSerializeInstance = serializer.deserialize(ois, kDescriptor);");
        if (message.isException()) {
            this.writer.appendln((CharSequence)"if (getCause() != null) {").formatln("    tSerializeInstance.initCause(getCause());", new Object[0]).appendln((CharSequence)"}").appendln((CharSequence)"tSerializeInstance.setStackTrace(getStackTrace());");
        }
        this.writer.end().appendln((CharSequence)"}").newline();
    }

    private void appendReadResolve() {
        this.writer.formatln("private Object readResolve() throws %s {", new Object[]{ObjectStreamException.class.getName()}).appendln((CharSequence)"    return tSerializeInstance;").appendln((CharSequence)"}").newline();
    }
}

