/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CConst;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessageDescriptor;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class ValueBuilder {
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public ValueBuilder(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    public void appendDefaultConstants(List<JField> fields) throws GeneratorException {
        boolean hasDefault = false;
        for (JField field : fields) {
            Object defaultValue;
            if (!field.hasDefaultConstant() || (defaultValue = this.helper.getDefaultValue((PField)field.field())) == null) continue;
            hasDefault = true;
            this.writer.formatln("private final static %s %s = ", new Object[]{field.valueType(), field.kDefault()}).begin("        ");
            this.appendTypedValue(defaultValue, field.field().getDescriptor());
            this.writer.append(';').end();
        }
        if (hasDefault) {
            this.writer.newline();
        }
    }

    public void appendTypedValue(Object value, PDescriptor type) throws GeneratorException {
        switch (type.getType()) {
            case BOOL: {
                this.writer.append((CharSequence)value.toString());
                break;
            }
            case BYTE: {
                this.writer.append((CharSequence)"(byte)").append((CharSequence)value.toString());
                break;
            }
            case I16: {
                this.writer.append((CharSequence)"(short)").append((CharSequence)value.toString());
                break;
            }
            case I32: {
                this.writer.append((CharSequence)value.toString());
                break;
            }
            case I64: {
                this.writer.append((CharSequence)value.toString()).append((CharSequence)"L");
                break;
            }
            case DOUBLE: {
                this.writer.append((CharSequence)value.toString()).append((CharSequence)"d");
                break;
            }
            case BINARY: {
                if (value == null) {
                    this.writer.format("null", new Object[0]);
                    break;
                }
                this.writer.format("%s.wrap(new byte[]{", new Object[]{Binary.class.getName()});
                byte[] bytes = ((Binary)value).get();
                boolean first = true;
                for (byte b : bytes) {
                    if (first) {
                        first = false;
                    } else {
                        this.writer.append(',');
                    }
                    this.writer.format("(byte)%d", new Object[]{b});
                }
                this.writer.append((CharSequence)"})");
                break;
            }
            case STRING: {
                if (value == null) {
                    this.writer.format("null", new Object[0]);
                    break;
                }
                this.writer.append('\"').append((CharSequence)Strings.escape((CharSequence)value.toString())).append('\"');
                break;
            }
            case ENUM: {
                this.writer.format("%s.%s", new Object[]{this.helper.getValueType(type), JUtils.enumConst((PEnumValue)value)});
                break;
            }
            case MESSAGE: {
                if (value == null) {
                    this.writer.format("null", new Object[0]);
                    break;
                }
                this.writer.format("%s.builder()", new Object[]{this.helper.getFieldType(type)}).begin();
                PMessage message = (PMessage)value;
                int i = 0;
                for (CField field : ((CMessageDescriptor)type).getFields()) {
                    JField fld = new JField(field, this.helper, i++);
                    if (!message.has(field.getId())) continue;
                    this.writer.formatln(".%s(", new Object[]{fld.setter()});
                    this.appendTypedValue(message.get(field.getId()), field.getDescriptor());
                    this.writer.append((CharSequence)")");
                }
                this.writer.appendln((CharSequence)".build()").end();
                break;
            }
            case MAP: {
                PMap lDesc = (PMap)type;
                PDescriptor keyDesc = lDesc.keyDescriptor();
                PDescriptor itemDesc = lDesc.itemDescriptor();
                JField constant = new JField((CField)new CConst("", "", () -> type, () -> value, null), this.helper, 0);
                this.writer.format("new %s<%s,%s>()", new Object[]{constant.wrappedBuilderInstanceType(), this.helper.getFieldType(keyDesc), this.helper.getFieldType(itemDesc)}).begin();
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    this.writer.appendln((CharSequence)".put(").begin("     ");
                    this.appendTypedValue(entry.getKey(), keyDesc);
                    this.writer.append((CharSequence)",").appendln();
                    this.appendTypedValue(entry.getValue(), itemDesc);
                    this.writer.end().append((CharSequence)")");
                }
                this.writer.formatln(".build()", new Object[0]).end();
                break;
            }
            case LIST: 
            case SET: {
                PContainer lDesc = (PContainer)type;
                PDescriptor itemDesc = lDesc.itemDescriptor();
                JField constant = new JField((CField)new CConst("", "", () -> type, () -> value, null), this.helper, 0);
                this.writer.format("new %s<%s>()", new Object[]{constant.wrappedBuilderInstanceType(), this.helper.getFieldType(itemDesc)}).begin();
                Collection items = (Collection)value;
                for (Object item : items) {
                    this.writer.appendln((CharSequence)".add(").begin("     ");
                    this.appendTypedValue(item, itemDesc);
                    this.writer.end().append((CharSequence)")");
                }
                this.writer.formatln(".build()", new Object[0]).end();
                break;
            }
            default: {
                throw new GeneratorException("Unhandled value type: " + type.getType());
            }
        }
    }
}

