/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.program.extras;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.GeneratorOptions;
import net.morimekta.providence.generator.format.java.JavaOptions;
import net.morimekta.providence.generator.format.java.shared.BaseProgramFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CConst;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.contained.CStructDescriptor;
import net.morimekta.providence.util.ThriftAnnotation;
import net.morimekta.util.io.IndentedPrintWriter;

public class HazelcastPortableProgramFormatter
implements BaseProgramFormatter {
    public static final String CONFIG_CLASS = "com.hazelcast.config.Config";
    public static final String CLASS_DEFINITION_CLASS = "com.hazelcast.nio.serialization.ClassDefinition";
    public static final String CLASS_DEFINITION_BUILDER_CLASS = "com.hazelcast.nio.serialization.ClassDefinitionBuilder";
    public static final String PORTABLE_FACTORY_CLASS = "com.hazelcast.nio.serialization.PortableFactory";
    public static final String FACTORY_ID = "FACTORY_ID";
    private static final String FACTORY_IMPL = "PortableFactoryImpl";
    private static final String PORTABLE_VERSION = "portableVersion";
    private static final String CONFIG = "config";
    private static final String INSTANCE = "instance";
    private final JHelper helper;
    private final IndentedPrintWriter writer;
    private final GeneratorOptions generatorOptions;
    private final JavaOptions javaOptions;

    public HazelcastPortableProgramFormatter(IndentedPrintWriter writer, JHelper helper, GeneratorOptions generatorOptions, JavaOptions javaOptions) {
        this.writer = writer;
        this.helper = helper;
        this.generatorOptions = generatorOptions;
        this.javaOptions = javaOptions;
    }

    @Override
    public void appendProgramClass(CProgram document) throws GeneratorException {
        if (document.getDocumentation() != null) {
            new BlockCommentBuilder(this.writer).comment(document.getDocumentation()).finish();
        }
        if (this.javaOptions.generated_annotation_version) {
            this.writer.formatln("@%s(\"%s %s\")", new Object[]{Generated.class.getName(), this.generatorOptions.generator_program_name, this.generatorOptions.program_version});
        } else {
            this.writer.formatln("@%s(\"%s\")", new Object[]{Generated.class.getName(), this.generatorOptions.generator_program_name});
        }
        this.writer.formatln("public class %s {", new Object[]{this.helper.getHazelcastFactoryClassName(document)}).begin().newline();
        Optional<CConst> factoryID = document.getConstants().stream().filter(t -> t.getName().equals(FACTORY_ID)).findFirst();
        if (!factoryID.isPresent()) {
            throw new GeneratorException("Need to provide \"const i32 FACTORY_ID = ?\" in the thrift file for hazelcast generation!");
        }
        CConst c = factoryID.get();
        String type = this.helper.getValueType(c.getDescriptor());
        String name = c.getName();
        this.writer.formatln("public static final %s %s = %s.%s;", new Object[]{type, name, this.helper.getConstantsClassName(document), name}).newline();
        ArrayList<CStructDescriptor> messages = new ArrayList<CStructDescriptor>();
        for (PDeclaredDescriptor c2 : document.getDeclaredTypes()) {
            try {
                CStructDescriptor message;
                if (PType.MESSAGE != c2.getType() || !(c2 instanceof CStructDescriptor) || !(message = (CStructDescriptor)c2).hasAnnotation(ThriftAnnotation.JAVA_HAZELCAST_CLASS_ID)) continue;
                this.writer.formatln("public static final int %s = %s;", new Object[]{JUtils.getHazelcastClassId(message.getName()), message.getAnnotationValue(ThriftAnnotation.JAVA_HAZELCAST_CLASS_ID)});
                messages.add(message);
            }
            catch (Exception e) {
                throw new GeneratorException(e.getMessage());
            }
        }
        this.writer.newline();
        this.appendPopulateMethod(messages);
        if (messages.isEmpty()) {
            throw new GeneratorException("No annotations available to generate!");
        }
        this.writer.formatln("private static class %s implements %s {", new Object[]{FACTORY_IMPL, PORTABLE_FACTORY_CLASS}).begin().newline();
        this.appendCreateMethod(messages);
        this.appendGetDefinitions(messages);
        this.writer.end().appendln((CharSequence)"}");
        this.writer.end().appendln((CharSequence)"}").newline();
    }

    private void appendCreateMethod(List<CStructDescriptor> messages) {
        this.writer.appendln((CharSequence)"@Override").formatln("public %s create(int classId) {", new Object[]{"com.hazelcast.nio.serialization.Portable"}).begin().appendln((CharSequence)"switch(classId) {").begin();
        for (CStructDescriptor message : messages) {
            this.writer.formatln("case %s: {", new Object[]{JUtils.getHazelcastClassId(message.getName())}).begin().formatln("return new %s.%s();", new Object[]{message.getName(), "_Builder"}).end().appendln((CharSequence)"}");
        }
        this.writer.appendln((CharSequence)"default: {").begin().appendln((CharSequence)"return null;").end().appendln((CharSequence)"}").end();
        this.writer.appendln((CharSequence)"}").end().appendln((CharSequence)"}").newline();
    }

    private void appendPopulateMethod(List<CStructDescriptor> messages) {
        this.writer.formatln("public static final %s populateConfig(%s %s, int %s) {", new Object[]{CONFIG_CLASS, CONFIG_CLASS, CONFIG, PORTABLE_VERSION}).begin().formatln("%s %s = new %s();", new Object[]{FACTORY_IMPL, INSTANCE, FACTORY_IMPL}).formatln("%s.getSerializationConfig().addPortableFactory(%s, %s);", new Object[]{CONFIG, FACTORY_ID, INSTANCE}).formatln("%s.getSerializationConfig().setPortableVersion(%s);", new Object[]{CONFIG, PORTABLE_VERSION}).appendln().formatln("%s.getSerializationConfig()", new Object[]{CONFIG}).begin().begin();
        for (CStructDescriptor struct : messages) {
            this.writer.formatln(".addClassDefinition(%s.%s(%s))", new Object[]{INSTANCE, JUtils.camelCase("get", struct.getName() + "Definition"), PORTABLE_VERSION});
        }
        this.writer.append((CharSequence)";").end().end().formatln("return %s;", new Object[]{CONFIG}).end().appendln((CharSequence)"}").newline();
    }

    private void appendGetDefinitions(List<CStructDescriptor> messages) {
        for (CStructDescriptor message : messages) {
            this.appendGetDefinition(new JMessage(message, this.helper));
        }
    }

    private void appendGetDefinition(JMessage<?> message) {
        this.writer.formatln("public %s %s(int %s) {", new Object[]{CLASS_DEFINITION_CLASS, JUtils.camelCase("get", message.descriptor().getName() + "Definition"), PORTABLE_VERSION}).begin().formatln("return new %s(%s, %s, %s)", new Object[]{CLASS_DEFINITION_BUILDER_CLASS, FACTORY_ID, JUtils.getHazelcastClassId(message.instanceType()), PORTABLE_VERSION}).begin().begin();
        this.writer.formatln(".addIntArrayField(\"__fields__\")", new Object[0]);
        for (JField field : message.declaredOrderFields()) {
            this.appendTypeField(field);
        }
        this.writer.appendln((CharSequence)".build();").end().end().end().appendln((CharSequence)"}").newline();
    }

    private void appendTypeField(JField field) {
        if (field.portableRequiresBinarySerialization()) {
            this.writer.formatln(".addByteArrayField(\"%s\")", new Object[]{field.name()});
            return;
        }
        switch (field.type()) {
            case BINARY: {
                this.writer.formatln(".addByteArrayField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case BYTE: {
                this.writer.formatln(".addByteField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case BOOL: {
                this.writer.formatln(".addBooleanField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case DOUBLE: {
                this.writer.formatln(".addDoubleField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case ENUM: 
            case I32: {
                this.writer.formatln(".addIntField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case I16: {
                this.writer.formatln(".addShortField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case I64: {
                this.writer.formatln(".addLongField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case STRING: {
                this.writer.formatln(".addUTFField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case LIST: {
                PList pList = field.toPList();
                this.appendCollectionTypeField(field, pList.itemDescriptor());
                break;
            }
            case SET: {
                PSet pSet = field.toPSet();
                this.appendCollectionTypeField(field, pSet.itemDescriptor());
                break;
            }
            case MESSAGE: {
                this.writer.formatln(".addPortableField(\"%s\", %s(%s))", new Object[]{field.name(), JUtils.camelCase("get", field.field().getDescriptor().getName() + "Definition"), PORTABLE_VERSION});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented appendTypeField for type: " + field.type() + " in " + this.getClass().getSimpleName());
            }
        }
    }

    private void appendCollectionTypeField(JField field, PDescriptor descriptor) {
        switch (descriptor.getType()) {
            case BINARY: 
            case BYTE: {
                this.writer.formatln(".addByteArrayField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case BOOL: {
                this.writer.formatln(".addBooleanArrayField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case DOUBLE: {
                this.writer.formatln(".addDoubleArrayField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case I16: {
                this.writer.formatln(".addShortArrayField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case ENUM: 
            case I32: {
                this.writer.formatln(".addIntArrayField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case I64: {
                this.writer.formatln(".addLongArrayField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case STRING: {
                this.writer.formatln(".addUTFArrayField(\"%s\")", new Object[]{field.name()});
                break;
            }
            case MESSAGE: {
                this.writer.formatln(".addPortableArrayField(\"%s\", %s(%s))", new Object[]{field.name(), JUtils.camelCase("get", descriptor.getName() + "Definition"), PORTABLE_VERSION});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented appendCollectionTypeField for list with type: " + descriptor.getType() + " in " + this.getClass().getSimpleName());
            }
        }
    }
}

