/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages.extras;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.util.io.IndentedPrintWriter;

public class JacksonMessageFormatter
implements MessageMemberFormatter {
    private final IndentedPrintWriter writer;
    private final JHelper helper;
    private final AtomicInteger atomicInteger = new AtomicInteger();

    public JacksonMessageFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    private String tmp(String name) {
        return name + this.atomicInteger.incrementAndGet();
    }

    @Override
    public void appendClassAnnotations(JMessage<?> message) {
        this.writer.formatln("@%s(", new Object[]{"com.fasterxml.jackson.databind.annotation.JsonSerialize"}).formatln("        using = %s._Serializer.class)", new Object[]{message.instanceType()});
        this.writer.formatln("@%s(", new Object[]{"com.fasterxml.jackson.databind.annotation.JsonDeserialize"}).formatln("        using = %s._Deserializer.class)", new Object[]{message.instanceType()});
    }

    @Override
    public void appendExtraProperties(JMessage<?> message) throws GeneratorException {
        this.appendJacksonDeserializer(message);
        this.appendJacksonSerializer(message);
    }

    private void appendJsonType(String varName, PDescriptor descriptor) throws GeneratorException {
        switch (descriptor.getType()) {
            case MAP: {
                String kType = this.tmp("k");
                String vType = this.tmp("v");
                PMap map = (PMap)descriptor;
                this.appendJsonType(kType, map.keyDescriptor());
                this.appendJsonType(vType, map.itemDescriptor());
                this.writer.formatln("%s %s = ctxt.getTypeFactory().constructMapType(%s.class, %s, %s);", new Object[]{"com.fasterxml.jackson.databind.type.MapType", varName, LinkedHashMap.class.getName(), kType, vType});
                break;
            }
            case LIST: 
            case SET: {
                String iType = this.tmp("i");
                PContainer container = (PContainer)descriptor;
                this.appendJsonType(iType, container.itemDescriptor());
                this.writer.formatln("%s %s = ctxt.getTypeFactory().constructCollectionType(%s.class, %s);", new Object[]{"com.fasterxml.jackson.databind.type.CollectionType", varName, ArrayList.class.getName(), iType});
                break;
            }
            default: {
                this.writer.formatln("%s %s = ctxt.getTypeFactory().constructSimpleType(%s.class, null);", new Object[]{"com.fasterxml.jackson.databind.JavaType", varName, this.helper.getFieldType(descriptor)});
            }
        }
    }

    private void appendReadValue(JField field) throws GeneratorException {
        switch (field.type()) {
            case MAP: 
            case LIST: 
            case SET: {
                String cType = this.tmp("c");
                this.appendJsonType(cType, field.field().getDescriptor());
                this.writer.formatln("builder.%s(ctxt.readValue(jp, %s));", new Object[]{field.setter(), cType});
                break;
            }
            case BINARY: 
            case STRING: 
            case MESSAGE: 
            case ENUM: {
                this.writer.formatln("builder.%s(ctxt.readValue(jp, %s.class));", new Object[]{field.setter(), field.instanceType()});
                break;
            }
            case VOID: {
                this.writer.formatln("ctxt.readValue(jp, Boolean.class);", new Object[]{field.instanceType()});
                this.writer.formatln("builder.%s();", new Object[]{field.setter()});
                break;
            }
            default: {
                this.writer.formatln("builder.%s(ctxt.readValue(jp, %s.TYPE));", new Object[]{field.setter(), field.instanceType()});
            }
        }
    }

    private void appendWriteValue(JField field) {
        switch (field.type()) {
            case VOID: {
                this.writer.formatln("provider.defaultSerializeField(\"%s\", true, generator);", new Object[]{field.name()});
                break;
            }
            default: {
                this.writer.formatln("provider.defaultSerializeField(\"%s\", instance.%s, generator);", new Object[]{field.name(), field.member()});
            }
        }
    }

    private void appendJacksonDeserializer(JMessage<?> message) throws GeneratorException {
        this.writer.formatln("public static class _Deserializer extends %s<%s> {", new Object[]{"com.fasterxml.jackson.databind.JsonDeserializer", message.instanceType()}).begin();
        this.writer.appendln((CharSequence)"@Override").formatln("public %s deserialize(%s jp,", new Object[]{message.instanceType(), "com.fasterxml.jackson.core.JsonParser"}).formatln("       %s             %s ctxt)", new Object[]{message.instanceType().replaceAll("[\\S]", " "), "com.fasterxml.jackson.databind.DeserializationContext"}).formatln("         throws %s,", new Object[]{IOException.class.getName()}).formatln("                %s {", new Object[]{"com.fasterxml.jackson.core.JsonProcessingException"}).begin();
        this.writer.appendln((CharSequence)"_Builder builder = builder();").newline();
        this.writer.formatln("if (jp.isExpectedStartObjectToken()) {", new Object[0]).begin().formatln("while (jp.nextToken() != %s.END_OBJECT) {", new Object[]{"com.fasterxml.jackson.core.JsonToken"}).begin().formatln("if (jp.getCurrentToken() != %s.FIELD_NAME) {", new Object[]{"com.fasterxml.jackson.core.JsonToken"}).formatln("    throw new %s(jp, \"Invalid field name token \" + jp.getText());", new Object[]{"com.fasterxml.jackson.core.JsonParseException"}).appendln('}').newline().appendln((CharSequence)"String field = jp.getCurrentName();").appendln((CharSequence)"jp.nextToken();").appendln((CharSequence)"switch (field) {").begin();
        for (JField field : message.declaredOrderFields()) {
            this.writer.formatln("case \"%d\":", new Object[]{field.id()}).formatln("case \"%s\": {", new Object[]{field.name()}).begin();
            this.appendReadValue(field);
            this.writer.appendln((CharSequence)"break;").end().appendln('}');
        }
        this.writer.appendln((CharSequence)"default: {").formatln("    ctxt.handleUnknownProperty(jp, this, %s.class, field);", new Object[]{message.instanceType()}).appendln((CharSequence)"    break;").appendln((CharSequence)"}");
        this.writer.end().appendln((CharSequence)"}").end().appendln((CharSequence)"}");
        if (message.jsonCompactible()) {
            this.writer.end().appendln((CharSequence)"} else if (jp.isExpectedStartArrayToken()) {").begin();
            this.writer.appendln((CharSequence)"int idx = 0;").formatln("while (jp.nextToken() != %s.END_ARRAY) {", new Object[]{"com.fasterxml.jackson.core.JsonToken"}).begin().appendln((CharSequence)"switch (idx++) {").begin();
            for (JField field : message.declaredOrderFields()) {
                this.writer.formatln("case %d: {", new Object[]{field.index()}).begin();
                this.appendReadValue(field);
                this.writer.appendln((CharSequence)"break;").end().appendln('}');
            }
            this.writer.appendln((CharSequence)"default:").formatln("    throw new %s(jp, \"Unexpected value: \" + jp.getText());", new Object[]{"com.fasterxml.jackson.core.JsonParseException"}).end().appendln('}').end().appendln('}');
        }
        this.writer.end().appendln((CharSequence)"} else {").formatln("    throw new %s(jp, \"Invalid token for object deserialization \" + jp.getText());", new Object[]{"com.fasterxml.jackson.core.JsonParseException"}).appendln('}').newline().appendln((CharSequence)"return builder.build();");
        this.writer.end().formatln("}", new Object[0]).end().formatln("}", new Object[0]).newline();
    }

    private void appendJacksonSerializer(JMessage<?> message) throws GeneratorException {
        this.writer.formatln("public static class _Serializer extends %s<%s> {", new Object[]{"com.fasterxml.jackson.databind.JsonSerializer", message.instanceType()}).begin().appendln((CharSequence)"@Override").formatln("public void serialize(%s instance, %s generator, %s provider)", new Object[]{message.instanceType(), "com.fasterxml.jackson.core.JsonGenerator", "com.fasterxml.jackson.databind.SerializerProvider"}).formatln("        throws %s, %s {", new Object[]{IOException.class.getName(), "com.fasterxml.jackson.core.JsonProcessingException"}).begin();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"generator.writeStartObject();").formatln("switch (instance.%s) {", new Object[]{"tUnionField"}).begin();
            for (JField jField : message.declaredOrderFields()) {
                this.writer.formatln("case %s: {", new Object[]{jField.fieldEnum()}).begin();
                this.appendWriteValue(jField);
                this.writer.appendln((CharSequence)"break;").end().appendln('}');
            }
            this.writer.end().appendln('}').appendln((CharSequence)"generator.writeEndObject();");
        } else {
            if (message.jsonCompactible()) {
                this.writer.formatln("if (instance.jsonCompact()) {", new Object[0]).begin().formatln("generator.writeStartArray();", new Object[0]);
                int ifStack = 0;
                for (JField field : message.numericalOrderFields()) {
                    if (!field.alwaysPresent() && !field.isRequired()) {
                        this.writer.formatln("if (instance.%s != null) {", new Object[]{field.member()}).begin();
                        ++ifStack;
                    }
                    this.writer.formatln("provider.defaultSerializeValue(instance.%s, generator);", new Object[]{field.member()});
                }
                while (ifStack-- > 0) {
                    this.writer.end().appendln('}');
                }
                this.writer.formatln("generator.writeEndArray();", new Object[0]);
                this.writer.end().appendln((CharSequence)"} else {").begin();
            }
            this.writer.formatln("generator.writeStartObject();", new Object[0]);
            for (JField jField : message.numericalOrderFields()) {
                if (!jField.alwaysPresent() && !jField.isRequired()) {
                    this.writer.formatln("if (instance.%s != null) {", new Object[]{jField.member()}).begin();
                }
                this.appendWriteValue(jField);
                if (jField.alwaysPresent() || jField.isRequired()) continue;
                this.writer.end().appendln('}');
            }
            this.writer.appendln((CharSequence)"generator.writeEndObject();");
            if (message.jsonCompactible()) {
                this.writer.end().appendln('}');
            }
        }
        this.writer.end().formatln("}", new Object[0]).end().formatln("}", new Object[0]).newline();
    }
}

