/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages.extras;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.io.BigEndianBinaryWriter;
import net.morimekta.util.io.IndentedPrintWriter;

public class BinaryWriterFormatter
implements MessageMemberFormatter {
    private final AtomicInteger nextId = new AtomicInteger(1);
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public BinaryWriterFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    @Override
    public Collection<String> getExtraImplements(JMessage<?> message) throws GeneratorException {
        return UnmodifiableList.listOf((Object)BinaryWriter.class.getName());
    }

    private void appendWriteFieldValue(String member, PDescriptor descriptor) {
        switch (descriptor.getType()) {
            case VOID: {
                break;
            }
            case BOOL: {
                this.writer.formatln("length += writer.writeUInt8(%s ? (byte) 1 : (byte) 0);", new Object[]{member});
                break;
            }
            case BYTE: {
                this.writer.formatln("length += writer.writeByte(%s);", new Object[]{member});
                break;
            }
            case I16: {
                this.writer.formatln("length += writer.writeShort(%s);", new Object[]{member});
                break;
            }
            case I32: {
                this.writer.formatln("length += writer.writeInt(%s);", new Object[]{member});
                break;
            }
            case I64: {
                this.writer.formatln("length += writer.writeLong(%s);", new Object[]{member});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("length += writer.writeDouble(%s);", new Object[]{member});
                break;
            }
            case BINARY: {
                this.writer.formatln("length += writer.writeUInt32(%s.length());", new Object[]{member});
                this.writer.formatln("length += writer.writeBinary(%s);", new Object[]{member});
                break;
            }
            case STRING: {
                String tmpName = "tmp_" + this.nextId.getAndIncrement();
                this.writer.formatln("%s %s = %s.wrap(%s.getBytes(%s.UTF_8));", new Object[]{Binary.class.getName(), tmpName, Binary.class.getName(), member, StandardCharsets.class.getName()});
                this.writer.formatln("length += writer.writeUInt32(%s.length());", new Object[]{tmpName});
                this.writer.formatln("length += writer.writeBinary(%s);", new Object[]{tmpName});
                break;
            }
            case ENUM: {
                this.writer.formatln("length += writer.writeInt(%s.asInteger());", new Object[]{member});
                break;
            }
            case MAP: {
                PMap pMap = (PMap)descriptor;
                String entryName = "entry_" + this.nextId.getAndIncrement();
                this.writer.formatln("length += writer.writeByte((byte) %d);", new Object[]{BinaryType.forType((PType)pMap.keyDescriptor().getType())}).formatln("length += writer.writeByte((byte) %d);", new Object[]{BinaryType.forType((PType)pMap.itemDescriptor().getType())}).formatln("length += writer.writeUInt32(%s.size());", new Object[]{member}).formatln("for (%s.Entry<%s,%s> %s : %s.entrySet()) {", new Object[]{Map.class.getName(), this.helper.getFieldType(pMap.keyDescriptor()), this.helper.getFieldType(pMap.itemDescriptor()), entryName, member}).begin();
                this.appendWriteFieldValue(entryName + ".getKey()", pMap.keyDescriptor());
                this.appendWriteFieldValue(entryName + ".getValue()", pMap.itemDescriptor());
                this.writer.end().appendln('}');
                break;
            }
            case LIST: 
            case SET: {
                PContainer pContainer = (PContainer)descriptor;
                String entryName = "entry_" + this.nextId.getAndIncrement();
                this.writer.formatln("length += writer.writeByte((byte) %d);", new Object[]{BinaryType.forType((PType)pContainer.itemDescriptor().getType())}).formatln("length += writer.writeUInt32(%s.size());", new Object[]{member}).formatln("for (%s %s : %s) {", new Object[]{this.helper.getFieldType(pContainer.itemDescriptor()), entryName, member}).begin();
                this.appendWriteFieldValue(entryName, pContainer.itemDescriptor());
                this.writer.end().appendln('}');
                break;
            }
            case MESSAGE: {
                this.writer.formatln("length += %s.writeMessage(writer, %s);", new Object[]{BinaryFormatUtils.class.getName(), member});
                break;
            }
            default: {
                throw new GeneratorException("Unsupported binary writer type: " + descriptor.getQualifiedName());
            }
        }
    }

    @Override
    public void appendMethods(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").formatln("public int writeBinary(%s writer) throws %s {", new Object[]{BigEndianBinaryWriter.class.getName(), IOException.class.getName()}).begin().appendln((CharSequence)"int length = 0;").newline();
        if (message.isUnion()) {
            this.writer.formatln("if (%s != null) {", new Object[]{"tUnionField"}).begin().formatln("switch (%s) {", new Object[]{"tUnionField"}).begin();
            for (JField field : message.numericalOrderFields()) {
                this.writer.formatln("case %s: {", new Object[]{field.fieldEnum()}).begin().formatln("length += writer.writeByte((byte) %d);", new Object[]{BinaryType.forType((PType)field.type())}).formatln("length += writer.writeShort((short) %d);", new Object[]{field.id()});
                this.appendWriteFieldValue(field.member(), field.field().getDescriptor());
                this.writer.appendln((CharSequence)"break;").end().appendln('}');
            }
            this.writer.appendln((CharSequence)"default: break;").end().appendln('}').end().appendln('}');
        } else {
            for (JField field : message.numericalOrderFields()) {
                if (!field.alwaysPresent()) {
                    this.writer.formatln("if (%s()) {", new Object[]{field.presence()}).begin();
                }
                this.writer.formatln("length += writer.writeByte((byte) %d);", new Object[]{BinaryType.forType((PType)field.type())}).formatln("length += writer.writeShort((short) %d);", new Object[]{field.id()});
                this.appendWriteFieldValue(field.member(), field.field().getDescriptor());
                if (!field.alwaysPresent()) {
                    this.writer.end().appendln('}');
                }
                this.writer.newline();
            }
        }
        this.writer.formatln("length += writer.writeByte((byte) %d);", new Object[]{(byte)0});
        this.writer.appendln((CharSequence)"return length;").end().appendln('}').newline();
    }
}

