/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages.extras;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.providence.serializer.DefaultSerializerProvider;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.SerializerProvider;
import net.morimekta.providence.util.Any;
import net.morimekta.util.Binary;
import net.morimekta.util.io.IndentedPrintWriter;

public class AnyMessageFormatter
implements MessageMemberFormatter {
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public AnyMessageFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    @Override
    public void appendMethods(JMessage<?> message) throws GeneratorException {
        if (this.isAny(message)) {
            new BlockCommentBuilder(this.writer).commentRaw("Check the wrapped message type against the provided message type\ndescriptor.").newline().param_("descriptor", "The message type to check.").param_("<M>", "The message type").param_("<F>", "The message field type").return_("True if the wrapped message type matches the provided.").finish();
            this.writer.formatln("public <M extends %s<M, F>, F extends %s>", new Object[]{PMessage.class.getName(), PField.class.getName()}).formatln("boolean wrappedTypeIs(%s %s<M,F> descriptor) {", new Object[]{"@javax.annotation.Nonnull", PMessageDescriptor.class.getName()}).appendln((CharSequence)"    return descriptor.getQualifiedName().equals(getType());").appendln((CharSequence)"}").newline();
            new BlockCommentBuilder(this.writer).commentRaw("Unwrap a message from this wrapper message. This will use the default\nserializer provider to find a suitable serializer to use to deserialize\nthe wrapped message. If no serializer is available, or the message\ncannot be deserialized an unchecked IO exception is thrown.").newline().param_("descriptor", "The message type to unpack from the content.").param_("<M>", "The message type").param_("<F>", "The message field type").return_("The unwrapped message.").finish();
            this.writer.formatln("public <M extends %s<M, F>, F extends %s>", new Object[]{PMessage.class.getName(), PField.class.getName()}).formatln("M unwrapMessage(%s %s<M,F> descriptor) {", new Object[]{"@javax.annotation.Nonnull", PMessageDescriptor.class.getName()}).formatln("    return unwrapMessage(descriptor, new %s());", new Object[]{DefaultSerializerProvider.class.getName()}).formatln("}", new Object[0]).newline();
            new BlockCommentBuilder(this.writer).commentRaw("Unwrap a message from this wrapper message. This will use the provided\nserializer provider to find a suitable serializer to use to deserialize\nthe wrapped message. If no serializer is available, or the message\ncannot be deserialized an unchecked IO exception is thrown.").newline().param_("descriptor", "The message type to unpack from the content.").param_("provider", "Serializer provider to get serializer from.").param_("<M>", "The message type").param_("<F>", "The message field type").return_("The unwrapped message.").finish();
            this.writer.formatln("public <M extends %s<M, F>, F extends %s>", new Object[]{PMessage.class.getName(), PField.class.getName()}).formatln("M unwrapMessage(%s %s<M,F> descriptor, %s %s provider) {", new Object[]{"@javax.annotation.Nonnull", PMessageDescriptor.class.getName(), "@javax.annotation.Nonnull", SerializerProvider.class.getName()}).begin().formatln("if (!descriptor.getQualifiedName().equals(getType())) {", new Object[0]).formatln("    throw new %s(\"Any type \" + getType() + \" does not match requested \" + descriptor.getQualifiedName());", new Object[]{IllegalStateException.class.getSimpleName()}).formatln("}", new Object[0]).newline();
            this.writer.appendln((CharSequence)"try {").begin().formatln("%s serializer = provider.getSerializer(getMediaType());", new Object[]{Serializer.class.getName()}).appendln((CharSequence)"if (hasData()) {").appendln((CharSequence)"    return serializer.deserialize(getData().getInputStream(), descriptor);").appendln((CharSequence)"} else if (hasText()) {").formatln("    %s bais = new %s(getText().getBytes(%s.UTF_8));", new Object[]{ByteArrayInputStream.class.getName(), ByteArrayInputStream.class.getName(), StandardCharsets.class.getName()}).formatln("    return serializer.deserialize(bais, descriptor);", new Object[0]).appendln((CharSequence)"} else {").formatln("    throw new %s(\"Neither data, nor text de deserialize.\");", new Object[]{SerializerException.class.getName()}).appendln((CharSequence)"}");
            this.writer.end().formatln("} catch (%s e) {", new Object[]{IOException.class.getName()}).formatln("    throw new %s(e.getMessage(), e);", new Object[]{UncheckedIOException.class.getName()}).appendln((CharSequence)"}").end().appendln((CharSequence)"}").newline();
        }
    }

    @Override
    public void appendExtraProperties(JMessage<?> message) throws GeneratorException {
        if (this.isAny(message)) {
            new BlockCommentBuilder(this.writer).commentRaw("Wrap a message into an <code>Any</code> wrapper message. This\nwill serialize the message using the default binary serializer.").newline().param_("message", "Wrap this message.").param_("<M>", "The message type").param_("<F>", "The message field type").return_("The wrapped message.").finish();
            this.writer.formatln("public static <M extends %s<M, F>, F extends %s>", new Object[]{PMessage.class.getName(), PField.class.getName()}).formatln("%s wrapMessage(%s M message) {", new Object[]{message.instanceType(), "@javax.annotation.Nonnull"}).formatln("    return wrapMessage(message, new %s());", new Object[]{BinarySerializer.class.getName()}).formatln("}", new Object[0]).newline();
            new BlockCommentBuilder(this.writer).commentRaw("Wrap a message into an <code>Any</code> wrapper message. This\nwill serialize the message using the provided serializer.").newline().param_("message", "Wrap this message.").param_("serializer", "Use this serializer.").param_("<M>", "The message type").param_("<F>", "The message field type").return_("The wrapped message.").finish();
            this.writer.formatln("public static <M extends %s<M, F>, F extends %s>", new Object[]{PMessage.class.getName(), PField.class.getName()}).formatln("%s wrapMessage(%s M message, %s %s serializer) {", new Object[]{message.instanceType(), "@javax.annotation.Nonnull", "@javax.annotation.Nonnull", Serializer.class.getName()}).begin();
            this.writer.appendln((CharSequence)"try {").begin().appendln((CharSequence)"_Builder builder = builder();").formatln("%s baos = new %s();", new Object[]{ByteArrayOutputStream.class.getName(), ByteArrayOutputStream.class.getName()}).appendln((CharSequence)"serializer.serialize(baos, message);").appendln((CharSequence)"if (serializer.binaryProtocol()) {").formatln("    builder.setData(%s.wrap(baos.toByteArray()));", new Object[]{Binary.class.getName()}).appendln((CharSequence)"} else {").formatln("    builder.setText(new String(baos.toByteArray(), %s.UTF_8));", new Object[]{StandardCharsets.class.getName()}).appendln((CharSequence)"}").appendln((CharSequence)"builder.setType(message.descriptor().getQualifiedName());").appendln((CharSequence)"builder.setMediaType(serializer.mediaType());").appendln((CharSequence)"return builder.build();");
            this.writer.end().formatln("} catch (%s e) {", new Object[]{IOException.class.getName()}).formatln("    throw new %s(e.getMessage(), e);", new Object[]{UncheckedIOException.class.getName()}).appendln((CharSequence)"}").end().appendln((CharSequence)"}").newline();
        }
    }

    private boolean isAny(JMessage<?> message) {
        return message.descriptor().getQualifiedName().equals(Any.kDescriptor.getQualifiedName()) && this.helper.getValueType((PDescriptor)message.descriptor()).equals(Any.class.getName());
    }
}

