/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages;

import java.util.List;
import java.util.Optional;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.BaseMessageFormatter;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.util.io.IndentedPrintWriter;

public class CommonBuilderFormatter
extends BaseMessageFormatter
implements MessageMemberFormatter {
    public CommonBuilderFormatter(IndentedPrintWriter writer, JHelper helper, List<MessageMemberFormatter> formatters) {
        super(true, false, writer, helper, formatters);
    }

    @Override
    public String getClassName(JMessage<?> message) {
        return "_Builder";
    }

    @Override
    public void appendMethods(JMessage<?> message) throws GeneratorException {
        this.appendMutate(message);
    }

    @Override
    public void appendExtraProperties(JMessage<?> message) throws GeneratorException {
        this.appendStaticMakeBuilder(message);
        this.appendMessageClass(message.descriptor());
    }

    @Override
    public void appendConstructors(JMessage<?> message) throws GeneratorException {
        this.appendBuilderConstructors(message);
    }

    @Override
    protected void appendClassExtends(JMessage<?> message) throws GeneratorException {
        this.writer.formatln("extends %s<%s,_Field>", new Object[]{PMessageBuilder.class.getName(), message.instanceType()});
    }

    private void appendMutate(JMessage message) {
        this.writer.appendln((CharSequence)"@javax.annotation.Nonnull").appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder mutate() {").begin().appendln((CharSequence)"return new _Builder(this);").end().appendln('}').newline();
    }

    private void appendStaticMakeBuilder(JMessage message) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.commentRaw("Make a <code>" + message.descriptor().getQualifiedName() + "</code> builder.").return_("The builder instance.").finish();
        this.writer.formatln("public static _Builder builder() {", new Object[0]).begin().appendln((CharSequence)"return new _Builder();").end().appendln('}').newline();
    }

    private void appendBuilderConstructors(JMessage<?> message) throws GeneratorException {
        this.writer.formatln("private %s(_Builder builder) {", new Object[]{message.instanceType()}).begin();
        if (message.isUnion()) {
            this.writer.formatln("%s = builder.%s;", new Object[]{"tUnionField", "tUnionField"}).newline();
            block5: for (JField field : message.declaredOrderFields()) {
                switch (field.type()) {
                    case VOID: {
                        continue block5;
                    }
                    case LIST: 
                    case MAP: 
                    case SET: {
                        this.writer.formatln("%s = %s == _Field.%s ? %s : null;", new Object[]{field.member(), "tUnionField", field.fieldEnum(), field.fieldInstanceCopy("builder." + field.member()), field.member()});
                        continue block5;
                    }
                    case MESSAGE: {
                        this.writer.formatln("%s = %s != _Field.%s", new Object[]{field.member(), "tUnionField", field.fieldEnum()}).appendln((CharSequence)"        ? null").formatln("        : builder.%s_builder != null ? builder.%s_builder.build() : builder.%s;", new Object[]{field.member(), field.member(), field.member()});
                        continue block5;
                    }
                }
                if (field.alwaysPresent()) {
                    this.writer.formatln("%s = %s == _Field.%s ? builder.%s : %s;", new Object[]{field.member(), "tUnionField", field.fieldEnum(), field.member(), field.kDefault()});
                    continue;
                }
                this.writer.formatln("%s = %s == _Field.%s ? builder.%s : null;", new Object[]{field.member(), "tUnionField", field.fieldEnum(), field.member()});
            }
        } else {
            if (message.isException()) {
                Optional<JField> msg = message.exceptionMessageField();
                if (msg.isPresent()) {
                    this.writer.formatln("super(builder.%s);", new Object[]{msg.get().member()}).newline();
                } else {
                    this.writer.appendln((CharSequence)"super(createMessage(").begin("                    ");
                    boolean first = true;
                    for (JField field : message.declaredOrderFields()) {
                        if (first) {
                            first = false;
                        } else {
                            this.writer.append(',').appendln();
                        }
                        if (field.container()) {
                            this.writer.format("builder.%s() ? %s : null", new Object[]{field.isSet(), field.fieldInstanceCopy("builder." + field.member())});
                            continue;
                        }
                        if (field.isVoid()) continue;
                        this.writer.format("builder.%s", new Object[]{field.member()});
                    }
                    this.writer.append((CharSequence)"));").end().newline();
                }
            }
            for (JField field : message.declaredOrderFields()) {
                if (field.container()) {
                    this.writer.formatln("if (builder.%s()) {", new Object[]{field.isSet()}).formatln("    %s = %s;", new Object[]{field.member(), field.fieldInstanceCopy("builder." + field.member())}).appendln((CharSequence)"} else {");
                    if (field.alwaysPresent()) {
                        this.writer.formatln("    %s = %s;", new Object[]{field.member(), field.kDefault()});
                    } else {
                        this.writer.formatln("    %s = null;", new Object[]{field.member()});
                    }
                    this.writer.appendln('}');
                    continue;
                }
                if (field.type() == PType.MESSAGE) {
                    this.writer.formatln("%s = builder.%s_builder != null ? builder.%s_builder.build() : builder.%s;", new Object[]{field.member(), field.member(), field.member(), field.member()});
                    continue;
                }
                if (field.isVoid()) continue;
                if (field.alwaysPresent() && !field.isPrimitiveJavaValue()) {
                    this.writer.formatln("if (builder.%s()) {", new Object[]{field.isSet()}).formatln("    %s = builder.%s;", new Object[]{field.member(), field.member()}).appendln((CharSequence)"} else {").formatln("    %s = %s;", new Object[]{field.member(), field.kDefault()}).appendln('}');
                    continue;
                }
                this.writer.formatln("%s = builder.%s;", new Object[]{field.member(), field.member()});
            }
        }
        this.writer.end().appendln('}').newline();
    }
}

