/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.enums.extras;

import java.io.IOException;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.EnumMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class JacksonEnumFormatter
implements EnumMemberFormatter {
    private final IndentedPrintWriter writer;

    public JacksonEnumFormatter(IndentedPrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public void appendClassAnnotations(CEnumDescriptor type) throws GeneratorException {
        String simpleClass = JUtils.getClassName(type);
        this.writer.formatln("@%s(", new Object[]{"com.fasterxml.jackson.databind.annotation.JsonDeserialize"}).formatln("        using = %s._Deserializer.class)", new Object[]{simpleClass});
    }

    @Override
    public void appendMethods(CEnumDescriptor type) throws GeneratorException {
        this.writer.formatln("@%s", new Object[]{"com.fasterxml.jackson.annotation.JsonValue"}).appendln((CharSequence)"public int jsonValue() {").appendln((CharSequence)"    return mId;").appendln('}').newline();
    }

    @Override
    public void appendExtraProperties(CEnumDescriptor type) throws GeneratorException {
        String simpleClass = JUtils.getClassName(type);
        String spacesClass = Strings.times((String)" ", (int)simpleClass.length());
        this.writer.formatln("public static class _Deserializer extends %s<%s> {", new Object[]{"com.fasterxml.jackson.databind.JsonDeserializer", simpleClass}).appendln((CharSequence)"    @Override").formatln("    public %s deserialize(%s jp,", new Object[]{simpleClass, "com.fasterxml.jackson.core.JsonParser"}).formatln("           %s             %s ctxt)", new Object[]{spacesClass, "com.fasterxml.jackson.databind.DeserializationContext"}).formatln("            throws %s,", new Object[]{IOException.class.getName()}).formatln("                   %s {", new Object[]{"com.fasterxml.jackson.core.JsonProcessingException"}).formatln("        if (jp.getCurrentToken() == %s.VALUE_NUMBER_INT) {", new Object[]{"com.fasterxml.jackson.core.JsonToken"}).formatln("            return %s.findById(jp.getIntValue());", new Object[]{simpleClass}).formatln("        } else if (jp.getCurrentToken() == %s.VALUE_STRING) {", new Object[]{"com.fasterxml.jackson.core.JsonToken"}).formatln("            if (%s.isInteger(jp.getText())) {", new Object[]{Strings.class.getName()}).formatln("                return %s.findById(Integer.parseInt(jp.getText()));", new Object[]{simpleClass}).appendln((CharSequence)"            }").formatln("            return %s.findByName(jp.getText());", new Object[]{simpleClass}).appendln((CharSequence)"        } else {").formatln("            throw new %s(jp, \"Invalid token for enum %s deserialization \" + jp.getText());", new Object[]{"com.fasterxml.jackson.core.JsonParseException", type.getQualifiedName()}).appendln((CharSequence)"        }").appendln((CharSequence)"    }").appendln('}').newline();
    }
}

