/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.generator.Generator;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.GeneratorOptions;
import net.morimekta.providence.generator.format.java.JavaConstantsFormatter;
import net.morimekta.providence.generator.format.java.JavaEnumFormatter;
import net.morimekta.providence.generator.format.java.JavaMessageFormatter;
import net.morimekta.providence.generator.format.java.JavaOptions;
import net.morimekta.providence.generator.format.java.JavaServiceFormatter;
import net.morimekta.providence.generator.format.java.program.extras.HazelcastPortableProgramFormatter;
import net.morimekta.providence.generator.format.java.shared.BaseEnumFormatter;
import net.morimekta.providence.generator.format.java.shared.BaseMessageFormatter;
import net.morimekta.providence.generator.format.java.shared.BaseProgramFormatter;
import net.morimekta.providence.generator.format.java.shared.BaseServiceFormatter;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.generator.util.FileManager;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.reflect.util.ProgramTypeRegistry;
import net.morimekta.util.io.IndentedPrintWriter;

public class JavaGenerator
extends Generator {
    private final GeneratorOptions generatorOptions;
    private final JavaOptions javaOptions;

    public JavaGenerator(FileManager manager, GeneratorOptions generatorOptions, JavaOptions javaOptions) throws GeneratorException {
        super(manager);
        this.generatorOptions = generatorOptions;
        this.javaOptions = javaOptions;
    }

    private BaseMessageFormatter messageFormatter(IndentedPrintWriter writer, JHelper helper) {
        return new JavaMessageFormatter(writer, helper, this.generatorOptions, this.javaOptions);
    }

    private BaseEnumFormatter enumFormatter(IndentedPrintWriter writer) {
        return new JavaEnumFormatter(writer, this.generatorOptions, this.javaOptions);
    }

    private BaseProgramFormatter constFomatter(IndentedPrintWriter writer, JHelper helper) {
        return new JavaConstantsFormatter(writer, helper, this.generatorOptions, this.javaOptions);
    }

    private BaseProgramFormatter hazelcastFomatter(IndentedPrintWriter writer, JHelper helper) {
        return new HazelcastPortableProgramFormatter(writer, helper, this.generatorOptions, this.javaOptions);
    }

    private BaseServiceFormatter serviceFormatter(IndentedPrintWriter writer, JHelper helper) {
        return new JavaServiceFormatter(writer, helper, new JavaMessageFormatter(true, true, writer, helper, this.generatorOptions, this.javaOptions), this.generatorOptions, this.javaOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(@Nonnull ProgramTypeRegistry registry) throws IOException, GeneratorException {
        IndentedPrintWriter writer;
        BufferedOutputStream out;
        String file;
        IndentedPrintWriter writer2;
        BufferedOutputStream out2;
        String file2;
        CProgram program = registry.getProgram();
        String javaPackage = JUtils.getJavaPackage(program);
        JHelper helper = new JHelper(registry);
        if (!this.javaOptions.generate_providence_core_types && ("net.morimekta.providence".equals(helper.getJavaPackage(program)) || "net.morimekta.providence.util".equals(helper.getJavaPackage(program)) || "net.morimekta.providence.model".equals(helper.getJavaPackage(program)))) {
            return;
        }
        String path = JUtils.getPackageClassPath(javaPackage);
        if (program.getConstants().size() > 0) {
            file2 = helper.getConstantsClassName(program) + ".java";
            out2 = new BufferedOutputStream(this.getFileManager().create(path, file2));
            try {
                writer2 = new IndentedPrintWriter((OutputStream)out2);
                this.appendFileHeader(writer2, helper, program);
                this.constFomatter(writer2, helper).appendProgramClass(program);
                writer2.flush();
            }
            finally {
                try {
                    this.getFileManager().finalize((OutputStream)out2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.javaOptions.hazelcast_portable && program.getConstants().stream().anyMatch(t -> t.getName().equals("FACTORY_ID"))) {
            file2 = helper.getHazelcastFactoryClassName(program) + ".java";
            out2 = new BufferedOutputStream(this.getFileManager().create(path, file2));
            try {
                writer2 = new IndentedPrintWriter((OutputStream)out2);
                this.appendFileHeader(writer2, helper, program);
                this.hazelcastFomatter(writer2, helper).appendProgramClass(program);
                writer2.flush();
            }
            finally {
                try {
                    this.getFileManager().finalize((OutputStream)out2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (PDeclaredDescriptor type : program.getDeclaredTypes()) {
            file = JUtils.getClassName(type) + ".java";
            out = new BufferedOutputStream(this.getFileManager().create(path, file));
            try {
                writer = new IndentedPrintWriter((OutputStream)out);
                this.appendFileHeader(writer, helper, program);
                switch (type.getType()) {
                    case MESSAGE: {
                        this.messageFormatter(writer, helper).appendMessageClass((PMessageDescriptor)type);
                        break;
                    }
                    case ENUM: {
                        this.enumFormatter(writer).appendEnumClass((CEnumDescriptor)type);
                        break;
                    }
                    default: {
                        throw new GeneratorException("Unhandled declaration type.");
                    }
                }
                writer.flush();
            }
            finally {
                try {
                    this.getFileManager().finalize((OutputStream)out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (CService service : program.getServices()) {
            file = JUtils.getClassName((PService)service) + ".java";
            out = new BufferedOutputStream(this.getFileManager().create(path, file));
            try {
                writer = new IndentedPrintWriter((OutputStream)out);
                this.appendFileHeader(writer, helper, program);
                this.serviceFormatter(writer, helper).appendServiceClass(service);
                writer.flush();
            }
            finally {
                try {
                    this.getFileManager().finalize((OutputStream)out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void appendFileHeader(IndentedPrintWriter writer, JHelper helper, CProgram document) throws GeneratorException, IOException {
        writer.format("package %s;", new Object[]{helper.getJavaPackage(document)}).newline();
    }
}

