/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import java.io.File;
import javax.annotation.Nonnull;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.util.Strings;

public class JUtils {
    public static long generateSerialVersionUID(@Nonnull PMessageDescriptor<?, ?> type) {
        String string = type.getVariant().toString() + " " + type.getQualifiedName();
        long hash = 1125899906842597L;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            hash = 4909L * hash + 7919L * (long)string.charAt(i);
        }
        return hash;
    }

    public static String getClassName(@Nonnull PDeclaredDescriptor<?> type) {
        if (type.getName().contains(".")) {
            String[] parts = type.getName().split("[.]");
            if (parts.length != 3) {
                throw new GeneratorException("Unrecognized service message name: " + type.getName());
            }
            return "_" + parts[1] + "_" + parts[2];
        }
        return JUtils.camelCase(type.getName());
    }

    public static String getClassName(@Nonnull PService service) {
        return JUtils.camelCase(service.getName());
    }

    public static String getJavaPackage(@Nonnull CProgram document) throws GeneratorException {
        String javaPackage = document.getNamespaceForLanguage("java");
        if (javaPackage == null) {
            throw new GeneratorException("No java namespace for thrift package " + document.getProgramName());
        }
        return javaPackage;
    }

    public static String getPackageClassPath(@Nonnull String javaPackage) throws GeneratorException {
        String[] parts = javaPackage.split("[.]");
        return Strings.join((String)File.separator, (Object[])parts);
    }

    public static String getHazelcastFactory(@Nonnull PMessageDescriptor<?, ?> type) {
        return JUtils.camelCase(type.getProgramName()).concat("_Factory");
    }

    public static String getHazelcastClassId(PMessageDescriptor<?, ?> type) {
        return JUtils.getHazelcastClassId(type.getName());
    }

    public static String getHazelcastClassId(String name) {
        return "CLASS_" + JUtils.macroCase(name) + "_ID";
    }

    public static String camelCase(String name) {
        return Strings.camelCase((String)"", (String)name);
    }

    public static String camelCase(String prefix, String name) {
        return Strings.camelCase((String)prefix, (String)name);
    }

    public static String macroCase(String name) {
        String result = name.replaceAll("([A-Z])", "_$1");
        while (result.startsWith("_")) {
            result = result.substring(1, result.length());
        }
        return result.toUpperCase();
    }

    public static String enumConst(PEnumValue value) {
        return Strings.c_case((String)"", (String)value.asString()).toUpperCase();
    }
}

