/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import javax.annotation.Nonnull;
import net.morimekta.util.io.IndentedPrintWriter;

public class BlockCommentBuilder {
    private final IndentedPrintWriter writer;
    private final Escaper html = HtmlEscapers.htmlEscaper();

    public BlockCommentBuilder(IndentedPrintWriter writer) {
        this.writer = writer;
        writer.appendln((CharSequence)"/**").begin(" *");
    }

    public BlockCommentBuilder comment(String comment) {
        String escaped = this.html.escape(comment).replaceAll("[@]", "&#64;");
        for (String line : escaped.trim().split("\r?\n")) {
            if (line.trim().length() == 0) {
                this.writer.appendln((CharSequence)" <p>");
                continue;
            }
            this.writer.appendln((CharSequence)(" " + line.replaceAll("[ ]*$", "")));
        }
        return this;
    }

    public BlockCommentBuilder newline() {
        this.writer.appendln();
        return this;
    }

    public BlockCommentBuilder param_(String name, String comment) {
        this.writer.formatln(" @param %s %s", new Object[]{name, this.html.escape(comment)});
        return this;
    }

    public BlockCommentBuilder return_(String comment) {
        this.writer.formatln(" @return %s", new Object[]{this.html.escape(comment)});
        return this;
    }

    public BlockCommentBuilder throws_(Class<?> klass, String comment) {
        return this.throws_(klass.getName().replaceAll("[$]", "."), comment);
    }

    public BlockCommentBuilder throws_(String klass, String comment) {
        this.writer.formatln(" @throws %s %s", new Object[]{klass, this.html.escape(comment)});
        return this;
    }

    public BlockCommentBuilder see_(Class<?> klass, String comment) {
        return this.see_(klass.getName().replaceAll("[$]", "."), comment);
    }

    public BlockCommentBuilder see_(String klass, String comment) {
        this.writer.formatln(" @see %s %s", new Object[]{klass, this.html.escape(comment)});
        return this;
    }

    public BlockCommentBuilder deprecated_(@Nonnull String useInstead) {
        this.writer.formatln(" @deprecated Use {@link %s} instead.", new Object[]{useInstead});
        return this;
    }

    public BlockCommentBuilder deprecated_(@Nonnull String useInstead, @Nonnull String reason) {
        this.writer.formatln(" @deprecated %s. Use {@link %s} instead.", new Object[]{this.html.escape(reason), useInstead});
        return this;
    }

    public void finish() {
        this.writer.end().appendln((CharSequence)" */");
    }
}

