/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.shared;

import java.io.IOException;
import java.io.OutputStream;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.generator.Generator;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.BaseEnumFormatter;
import net.morimekta.providence.generator.format.java.shared.BaseMessageFormatter;
import net.morimekta.providence.generator.format.java.shared.BaseProgramFormatter;
import net.morimekta.providence.generator.format.java.shared.BaseServiceFormatter;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.generator.util.FileManager;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.reflect.util.ProgramRegistry;
import net.morimekta.util.io.IndentedPrintWriter;

public abstract class BaseGenerator
extends Generator {
    protected final JHelper helper;

    public BaseGenerator(FileManager manager, ProgramRegistry registry) throws GeneratorException {
        super(manager);
        this.helper = new JHelper(registry);
    }

    protected abstract BaseMessageFormatter messageFormatter(IndentedPrintWriter var1);

    protected abstract BaseEnumFormatter enumFormatter(IndentedPrintWriter var1);

    protected abstract BaseProgramFormatter constFomatter(IndentedPrintWriter var1);

    protected abstract BaseProgramFormatter hazelcastFomatter(IndentedPrintWriter var1);

    protected abstract BaseServiceFormatter serviceFormatter(IndentedPrintWriter var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(CProgram program) throws IOException, GeneratorException {
        IndentedPrintWriter writer;
        OutputStream out;
        String file;
        IndentedPrintWriter writer2;
        OutputStream out2;
        String file2;
        String javaPackage = JUtils.getJavaPackage(program);
        String path = JUtils.getPackageClassPath(javaPackage);
        if (program.getConstants().size() > 0) {
            file2 = this.helper.getConstantsClassName(program) + ".java";
            out2 = this.getFileManager().create(path, file2);
            try {
                writer2 = new IndentedPrintWriter(out2);
                this.appendFileHeader(writer2, program);
                this.constFomatter(writer2).appendProgramClass(program);
                writer2.flush();
            }
            finally {
                try {
                    this.getFileManager().finalize(out2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (program.getConstants().stream().anyMatch(t -> t.getName().equals("FACTORY_ID"))) {
            file2 = this.helper.getHazelcastFactoryClassName(program) + ".java";
            out2 = this.getFileManager().create(path, file2);
            try {
                writer2 = new IndentedPrintWriter(out2);
                this.appendFileHeader(writer2, program);
                this.hazelcastFomatter(writer2).appendProgramClass(program);
                writer2.flush();
            }
            finally {
                try {
                    this.getFileManager().finalize(out2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (PDeclaredDescriptor type : program.getDeclaredTypes()) {
            file = JUtils.getClassName(type) + ".java";
            out = this.getFileManager().create(path, file);
            try {
                writer = new IndentedPrintWriter(out);
                this.appendFileHeader(writer, program);
                switch (type.getType()) {
                    case MESSAGE: {
                        this.messageFormatter(writer).appendMessageClass((PMessageDescriptor)type);
                        break;
                    }
                    case ENUM: {
                        this.enumFormatter(writer).appendEnumClass((CEnumDescriptor)type);
                        break;
                    }
                    default: {
                        throw new GeneratorException("Unhandled declaration type.");
                    }
                }
                writer.flush();
            }
            finally {
                try {
                    this.getFileManager().finalize(out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (CService service : program.getServices()) {
            file = JUtils.getClassName((PService)service) + ".java";
            out = this.getFileManager().create(path, file);
            try {
                writer = new IndentedPrintWriter(out);
                this.appendFileHeader(writer, program);
                this.serviceFormatter(writer).appendServiceClass(service);
                writer.flush();
            }
            finally {
                try {
                    this.getFileManager().finalize(out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void appendFileHeader(IndentedPrintWriter writer, CProgram document) throws GeneratorException, IOException {
        writer.format("package %s;", new Object[]{this.helper.getJavaPackage(document)}).newline();
    }
}

