/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages.extras;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.util.ThriftAnnotation;
import net.morimekta.util.Binary;
import net.morimekta.util.BinaryUtil;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;
import net.morimekta.util.io.IndentedPrintWriter;

public class HazelcastPortableMessageFormatter
implements MessageMemberFormatter {
    public static final String WRAPPER_CLASS_NAME = "_Builder";
    private static final String PORTABLE_WRITER = "portableWriter";
    private static final String PORTABLE_READER = "portableReader";
    private final IndentedPrintWriter writer;
    private final JHelper helper;
    private Integer uniqueVariable;

    public HazelcastPortableMessageFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
        this.uniqueVariable = 0;
    }

    private String tempVariable() {
        this.uniqueVariable = this.uniqueVariable - 1;
        return "temp" + Integer.toHexString(this.uniqueVariable.hashCode());
    }

    @Override
    public Collection<String> getExtraImplements(JMessage<?> message) throws GeneratorException {
        if (message.hasAnnotation(ThriftAnnotation.JAVA_HAZELCAST_CLASS_ID)) {
            return ImmutableList.of((Object)Portable.class.getName());
        }
        return new LinkedList<String>();
    }

    @Override
    public void appendMethods(JMessage<?> message) throws GeneratorException {
        if (message.hasAnnotation(ThriftAnnotation.JAVA_HAZELCAST_CLASS_ID)) {
            this.appendFactoryId(message);
            this.appendClassId(message);
            this.appendPortableWriter(message);
            this.appendPortableReader(message);
        }
    }

    private void appendFactoryId(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int getFactoryId() {").begin().formatln("return %s.%s;", new Object[]{JUtils.getHazelcastFactory(message.descriptor()), "FACTORY_ID"}).end().appendln((CharSequence)"}").newline();
    }

    private void appendClassId(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int getClassId() {").begin().formatln("return %s.%s;", new Object[]{JUtils.getHazelcastFactory(message.descriptor()), JUtils.getHazelcastClassId(message.descriptor())}).end().appendln((CharSequence)"}").newline();
    }

    private void appendPortableWriter(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").formatln("public void writePortable(%s %s) throws %s {", new Object[]{PortableWriter.class.getName(), PORTABLE_WRITER, IOException.class.getName()}).begin();
        for (JField field : message.declaredOrderFields()) {
            if (!field.alwaysPresent()) {
                this.writer.formatln("if( %s() ) {", new Object[]{field.isSet()}).begin();
            }
            this.writePortableField(field);
            if (field.alwaysPresent()) continue;
            this.writer.end().appendln((CharSequence)"} else {").begin();
            this.writeDefaultPortableField(field);
            this.writer.end().appendln((CharSequence)"}");
        }
        this.writer.end().appendln((CharSequence)"}").newline();
    }

    private void appendPortableReader(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").formatln("public void readPortable(%s %s) throws %s {", new Object[]{PortableReader.class.getName(), PORTABLE_READER, IOException.class.getName()}).begin();
        for (JField field : message.declaredOrderFields()) {
            this.readPortableField(field);
        }
        this.writer.end().appendln((CharSequence)"}").newline();
    }

    private void writePortableField(JField field) throws GeneratorException {
        String baosTemp = JUtils.camelCase("baos", field.name());
        String bebwTemp = JUtils.camelCase("bebw", field.name());
        switch (field.type()) {
            case BINARY: {
                this.writer.formatln("%s.writeByteArray(\"%s\", %s.get());", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s.writeBoolean(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case BYTE: {
                this.writer.formatln("%s.writeByte(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s.writeDouble(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s.writeInt(\"%s\", %s.asInteger());", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case I16: {
                this.writer.formatln("%s.writeShort(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case I32: {
                this.writer.formatln("%s.writeInt(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case I64: {
                this.writer.formatln("%s.writeLong(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case STRING: {
                this.writer.formatln("%s.writeUTF(\"%s\", %s);", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case MAP: {
                PMap pMap = field.toPMap();
                String iterator = "entry";
                this.writer.formatln("try (%s %s = new %s();", new Object[]{ByteArrayOutputStream.class.getName(), baosTemp, ByteArrayOutputStream.class.getName()}).formatln("%s %s = new %s(%s) ) {", new Object[]{BigEndianBinaryWriter.class.getName(), bebwTemp, BigEndianBinaryWriter.class.getName(), baosTemp}).begin().formatln("%s.writeInt(%s.build().size());", new Object[]{bebwTemp, field.member()}).formatln("for( %s.Entry<%s,%s> %s : %s.build().entrySet() ) {", new Object[]{Map.class.getName(), this.helper.getFieldType(pMap.keyDescriptor()), this.helper.getFieldType(pMap.itemDescriptor()), iterator, field.member()}).begin();
                this.writePortableBinary(field, bebwTemp, iterator + ".getKey()", pMap.keyDescriptor());
                this.writePortableBinary(field, bebwTemp, iterator + ".getValue()", pMap.itemDescriptor());
                this.writer.end().println("}");
                this.writer.formatln("%s.writeByteArray(\"%s\", %s.toByteArray());", new Object[]{PORTABLE_WRITER, field.name(), baosTemp}).end().println("}");
                break;
            }
            case LIST: {
                if (field.isUnion()) {
                    this.writer.formatln("try (%s %s = new %s();", new Object[]{ByteArrayOutputStream.class.getName(), baosTemp, ByteArrayOutputStream.class.getName()}).formatln("%s %s = new %s(%s) ) {", new Object[]{BigEndianBinaryWriter.class.getName(), bebwTemp, BigEndianBinaryWriter.class.getName(), baosTemp}).begin();
                    this.writePortableBinary(field, bebwTemp, field.member() + ".build()", (PDescriptor)field.toPList());
                    this.writer.formatln("%s.writeByteArray(\"%s\", %s.toByteArray());", new Object[]{PORTABLE_WRITER, field.name(), baosTemp}).end().println("}");
                    break;
                }
                this.writePortableFieldList(field, field.toPList().itemDescriptor());
                break;
            }
            case SET: {
                if (field.isUnion()) {
                    this.writer.formatln("try (%s %s = new %s();", new Object[]{ByteArrayOutputStream.class.getName(), baosTemp, ByteArrayOutputStream.class.getName()}).formatln("%s %s = new %s(%s) ) {", new Object[]{BigEndianBinaryWriter.class.getName(), bebwTemp, BigEndianBinaryWriter.class.getName(), baosTemp}).begin();
                    this.writePortableBinary(field, bebwTemp, field.member() + ".build()", (PDescriptor)field.toPSet());
                    this.writer.formatln("%s.writeByteArray(\"%s\", %s.toByteArray());", new Object[]{PORTABLE_WRITER, field.name(), baosTemp}).end().println("}");
                    break;
                }
                this.writePortableFieldList(field, field.toPSet().itemDescriptor());
                break;
            }
            case MESSAGE: {
                if (field.isUnion()) {
                    this.writer.formatln("try (%s %s = new %s();", new Object[]{ByteArrayOutputStream.class.getName(), baosTemp, ByteArrayOutputStream.class.getName()}).formatln("%s %s = new %s(%s) ) {", new Object[]{BigEndianBinaryWriter.class.getName(), bebwTemp, BigEndianBinaryWriter.class.getName(), baosTemp}).begin();
                    this.writer.formatln("%s.writeBinary(%s);", new Object[]{field.member(), bebwTemp});
                    this.writer.formatln("%s.writeByteArray(\"%s\", %s.toByteArray());", new Object[]{PORTABLE_WRITER, field.name(), baosTemp}).end().println("}");
                    break;
                }
                this.writer.formatln("%s.writePortable(\"%s\", %s());", new Object[]{PORTABLE_WRITER, field.name(), Strings.camelCase((String)"mutable", (String)field.name())});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented writePortableField for type: " + field.type() + " in " + this.getClass().getSimpleName());
            }
        }
        this.writer.formatln("%s.writeBoolean(\"%s\", true);", new Object[]{PORTABLE_WRITER, field.hasName()});
    }

    private void writePortableBinary(JField field, String bebw, String getter, PDescriptor descriptor) {
        switch (descriptor.getType()) {
            case BINARY: {
                this.writer.formatln("%s.%s(%s.length());", new Object[]{bebw, "writeInt", getter}).formatln("%s.%s(%s.get());", new Object[]{bebw, "write", getter});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s.%s(%s ? (byte)1 : 0);", new Object[]{bebw, "writeByte", getter});
                break;
            }
            case BYTE: {
                this.writer.formatln("%s.%s(%s);", new Object[]{bebw, "writeByte", getter});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s.%s(%s);", new Object[]{bebw, "writeDouble", getter});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s.%s(%s.getValue());", new Object[]{bebw, "writeInt", getter});
                break;
            }
            case I16: {
                this.writer.formatln("%s.%s(%s);", new Object[]{bebw, "writeShort", getter});
                break;
            }
            case I32: {
                this.writer.formatln("%s.%s(%s);", new Object[]{bebw, "writeInt", getter});
                break;
            }
            case I64: {
                this.writer.formatln("%s.%s(%s);", new Object[]{bebw, "writeLong", getter});
                break;
            }
            case STRING: {
                String tempBinary = this.tempVariable();
                this.writer.formatln("%s[] %s = %s.getBytes(%s.UTF_8);", new Object[]{Byte.TYPE.getName(), tempBinary, getter, StandardCharsets.class.getName()}).formatln("%s.%s(%s.length);", new Object[]{bebw, "writeInt", tempBinary}).formatln("%s.%s(%s);", new Object[]{bebw, "write", tempBinary});
                break;
            }
            case LIST: {
                PDescriptor innerList = ((PList)descriptor).itemDescriptor();
                String iteratorList = this.tempVariable();
                this.writer.formatln("%s.%s(%s.size());", new Object[]{bebw, "writeInt", getter});
                this.writer.formatln("for( %s %s : %s ) {", new Object[]{this.helper.getFieldType(innerList), iteratorList, getter}).begin();
                this.writePortableBinary(field, bebw, iteratorList, innerList);
                this.writer.end().println("}");
                break;
            }
            case SET: {
                PDescriptor innerSet = ((PSet)descriptor).itemDescriptor();
                String iteratorSet = this.tempVariable();
                this.writer.formatln("%s.%s(%s.size());", new Object[]{bebw, "writeInt", getter});
                this.writer.formatln("for( %s %s : %s ) {", new Object[]{this.helper.getFieldType(innerSet), iteratorSet, getter}).begin();
                this.writePortableBinary(field, bebw, iteratorSet, innerSet);
                this.writer.end().println("}");
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s.writeBinary(%s);", new Object[]{getter, bebw});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented writePortableBinary for type: " + this.helper.getFieldType(descriptor) + " in " + this.getClass().getSimpleName());
            }
        }
    }

    private void readPortableBinary(JField field, String bebr, String variable, PDescriptor descriptor) {
        switch (descriptor.getType()) {
            case BINARY: {
                this.writer.formatln("%s = %s.%s(%s.%s());", new Object[]{variable, bebr, "expectBinary", bebr, "expectInt"});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s = (%s.%s() > 0 ? true : false);", new Object[]{variable, bebr, "expectByte"});
                break;
            }
            case BYTE: {
                this.writer.formatln("%s = %s.%s();", new Object[]{variable, bebr, "expectByte"});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s = %s.%s();", new Object[]{variable, bebr, "expectDouble"});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s = %s.findById(%s.%s());", new Object[]{variable, this.helper.getFieldType(descriptor), bebr, "expectInt"});
                break;
            }
            case I16: {
                this.writer.formatln("%s = %s.%s();", new Object[]{variable, bebr, "expectShort"});
                break;
            }
            case I32: {
                this.writer.formatln("%s = %s.%s();", new Object[]{variable, bebr, "expectInt"});
                break;
            }
            case I64: {
                this.writer.formatln("%s = %s.%s();", new Object[]{variable, bebr, "expectLong"});
                break;
            }
            case STRING: {
                this.writer.formatln("%s = new %s(%s.%s(%s.%s()), %s.UTF_8);", new Object[]{variable, this.helper.getFieldType(descriptor), bebr, "expectBytes", bebr, "expectInt", StandardCharsets.class.getName()});
                break;
            }
            case LIST: {
                PDescriptor innerList = ((PList)descriptor).itemDescriptor();
                String tempSizeList = this.tempVariable();
                String tempCounterList = this.tempVariable();
                String tempVariableList = this.tempVariable();
                this.writer.formatln("%s = new %s<>();", new Object[]{variable, ArrayList.class.getName()});
                this.writer.formatln("int %s = %s.%s();", new Object[]{tempSizeList, bebr, "expectInt"});
                this.writer.formatln("%s %s;", new Object[]{this.helper.getFieldType(innerList), tempVariableList});
                this.writer.formatln("for( int %s = 0; %s < %s; %s++ ) {", new Object[]{tempCounterList, tempCounterList, tempSizeList, tempCounterList}).begin();
                this.readPortableBinary(field, bebr, tempVariableList, innerList);
                this.writer.formatln("%s.add(%s);", new Object[]{variable, tempVariableList});
                this.writer.end().println("}");
                break;
            }
            case SET: {
                PDescriptor innerSet = ((PSet)descriptor).itemDescriptor();
                String tempSizeSet = this.tempVariable();
                String tempCounterSet = this.tempVariable();
                String tempVariableSet = this.tempVariable();
                this.writer.formatln("%s = new %s<>();", new Object[]{variable, HashSet.class.getName()});
                this.writer.formatln("int %s = %s.%s();", new Object[]{tempSizeSet, bebr, "expectInt"});
                this.writer.formatln("%s %s;", new Object[]{this.helper.getFieldType(innerSet), tempVariableSet});
                this.writer.formatln("for( int %s = 0; %s < %s; %s++ ) {", new Object[]{tempCounterSet, tempCounterSet, tempSizeSet, tempCounterSet}).begin();
                this.readPortableBinary(field, bebr, tempVariableSet, innerSet);
                this.writer.formatln("%s.add(%s);", new Object[]{variable, tempVariableSet});
                this.writer.end().println("}");
                break;
            }
            case MESSAGE: {
                String tempMessage = this.tempVariable();
                this.writer.formatln("%s._Builder %s = %s.builder();", new Object[]{this.helper.getFieldType(descriptor), tempMessage, this.helper.getFieldType(descriptor)}).formatln("%s.readBinary(%s, false);", new Object[]{tempMessage, bebr}).formatln("%s = %s.build();", new Object[]{variable, tempMessage});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented readPortableBinary for type: " + this.helper.getFieldType(descriptor) + " in " + this.getClass().getSimpleName());
            }
        }
    }

    private void writeDefaultPortableField(JField field) throws GeneratorException {
        switch (field.type()) {
            case BINARY: {
                this.writer.formatln("%s.writeByteArray(\"%s\", new byte[0]);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s.writeBoolean(\"%s\", false);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case BYTE: {
                this.writer.formatln("%s.writeByte(\"%s\", (byte) 0);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s.writeDouble(\"%s\", 0.0);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s.writeInt(\"%s\", 0);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case I16: {
                this.writer.formatln("%s.writeShort(\"%s\", (short) 0);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case I32: {
                this.writer.formatln("%s.writeInt(\"%s\", 0);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case I64: {
                this.writer.formatln("%s.writeLong(\"%s\", 0L);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case STRING: {
                this.writer.formatln("%s.writeUTF(\"%s\", \"\");", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case MAP: {
                this.writer.formatln("%s.writeByteArray(\"%s\", new byte[0]);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            case LIST: {
                if (field.isUnion()) {
                    this.writer.formatln("%s.writeByteArray(\"%s\", new byte[0]);", new Object[]{PORTABLE_WRITER, field.name()});
                    break;
                }
                this.writeDefaultPortableFieldList(field, field.toPList().itemDescriptor());
                break;
            }
            case SET: {
                if (field.isUnion()) {
                    this.writer.formatln("%s.writeByteArray(\"%s\", new byte[0]);", new Object[]{PORTABLE_WRITER, field.name()});
                    break;
                }
                this.writeDefaultPortableFieldList(field, field.toPSet().itemDescriptor());
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s.writePortable(\"%s\", null);", new Object[]{PORTABLE_WRITER, field.name()});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented writeDefaultPortableField for type: " + field.type() + " in " + this.getClass().getSimpleName());
            }
        }
        this.writer.formatln("%s.writeBoolean(\"%s\", false);", new Object[]{PORTABLE_WRITER, field.hasName()});
    }

    private void writePortableFieldList(JField field, PDescriptor descriptor) throws GeneratorException {
        switch (descriptor.getType()) {
            case BYTE: {
                this.writer.formatln("%s.writeByteArray(\"%s\", %s.toArray(%s));", new Object[]{PORTABLE_WRITER, field.name(), Bytes.class.getName(), field.member()});
                break;
            }
            case BINARY: {
                this.writer.formatln("%s.writeByteArray(\"%s\", %s.%s(%s));", new Object[]{PORTABLE_WRITER, field.name(), BinaryUtil.class.getName(), "fromBinaryCollection", field.member()});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s.writeBooleanArray(\"%s\", %s.toArray(%s));", new Object[]{PORTABLE_WRITER, field.name(), Booleans.class.getName(), field.member()});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s.writeDoubleArray(\"%s\", %s.toArray(%s));", new Object[]{PORTABLE_WRITER, field.name(), Doubles.class.getName(), field.member()});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s.writeIntArray(\"%s\", %s.stream().mapToInt(t -> t.getValue()).toArray());", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case I16: {
                this.writer.formatln("%s.writeShortArray(\"%s\", %s.toArray(%s));", new Object[]{PORTABLE_WRITER, field.name(), Shorts.class.getName(), field.member()});
                break;
            }
            case I32: {
                this.writer.formatln("%s.writeIntArray(\"%s\", %s.toArray(%s));", new Object[]{PORTABLE_WRITER, field.name(), Ints.class.getName(), field.member()});
                break;
            }
            case I64: {
                this.writer.formatln("%s.writeLongArray(\"%s\", %s.toArray(%s));", new Object[]{PORTABLE_WRITER, field.name(), Longs.class.getName(), field.member()});
                break;
            }
            case STRING: {
                this.writer.formatln("%s.writeUTFArray(\"%s\", %s.toArray(new String[0]));", new Object[]{PORTABLE_WRITER, field.name(), field.member()});
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s<%s.%s> %sList = %s.stream().map(i -> i.mutate()).collect(%s.toList());", new Object[]{List.class.getName(), this.helper.getValueType(descriptor), WRAPPER_CLASS_NAME, JUtils.camelCase("temp", field.name()), field.member(), Collectors.class.getName()});
                this.writer.formatln("%s.writePortableArray(\"%s\", %sList.toArray(new %s.%s[%sList.size()]));", new Object[]{PORTABLE_WRITER, field.name(), JUtils.camelCase("temp", field.name()), this.helper.getValueType(descriptor), WRAPPER_CLASS_NAME, JUtils.camelCase("temp", field.name())});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented writePortableFieldList for list with type: " + descriptor.getType() + " in " + this.getClass().getSimpleName());
            }
        }
    }

    private void writeDefaultPortableFieldList(JField field, PDescriptor descriptor) throws GeneratorException {
        switch (descriptor.getType()) {
            case BYTE: {
                this.writer.formatln("%s.writeByteArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case BINARY: {
                this.writer.formatln("%s.writeByteArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), "byte"});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s.writeBooleanArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s.writeDoubleArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s.writeIntArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), Integer.TYPE.getName()});
                break;
            }
            case I16: {
                this.writer.formatln("%s.writeShortArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case I32: {
                this.writer.formatln("%s.writeIntArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case I64: {
                this.writer.formatln("%s.writeLongArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case STRING: {
                this.writer.formatln("%s.writeUTFArray(\"%s\", new %s[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s.writePortableArray(\"%s\", new %s._Builder[0]);", new Object[]{PORTABLE_WRITER, field.name(), this.helper.getValueType(descriptor)});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented writeDefaultPortableFieldList for list with type: " + descriptor.getType() + " in " + this.getClass().getSimpleName());
            }
        }
    }

    private void readPortableField(JField field) {
        String baisTemp = JUtils.camelCase("bais", field.name());
        String bebrTemp = JUtils.camelCase("bebr", field.name());
        String tempIterator = this.tempVariable();
        String valueVariable = this.tempVariable();
        if (!field.alwaysPresent()) {
            this.writer.formatln("if( %s.hasField(\"%s\") && %s.readBoolean(\"%s\") && %s.hasField(\"%s\") ) {", new Object[]{PORTABLE_READER, field.hasName(), PORTABLE_READER, field.hasName(), PORTABLE_READER, field.name()}).begin();
        }
        switch (field.type()) {
            case BINARY: {
                this.writer.formatln("%s(new %s(%s.readByteArray(\"%s\")));", new Object[]{field.setter(), Binary.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s(%s.readBoolean(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case BYTE: {
                this.writer.formatln("%s(%s.readByte(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s(%s.readDouble(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s(%s.findById(%s.readInt(\"%s\")));", new Object[]{field.setter(), field.instanceType(), PORTABLE_READER, field.name()});
                break;
            }
            case I16: {
                this.writer.formatln("%s(%s.readShort(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case I32: {
                this.writer.formatln("%s(%s.readInt(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case I64: {
                this.writer.formatln("%s(%s.readLong(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case STRING: {
                this.writer.formatln("%s(%s.readUTF(\"%s\"));", new Object[]{field.setter(), PORTABLE_READER, field.name()});
                break;
            }
            case LIST: {
                if (field.isUnion()) {
                    this.writer.formatln("try ( %s %s = new %s(%s.readByteArray(\"%s\"));", new Object[]{ByteArrayInputStream.class.getName(), baisTemp, ByteArrayInputStream.class.getName(), PORTABLE_READER, field.name()}).formatln("%s %s = new %s(%s) ) {", new Object[]{BigEndianBinaryReader.class.getName(), bebrTemp, BigEndianBinaryReader.class.getName(), baisTemp}).begin().formatln("%s %s;", new Object[]{this.helper.getFieldType((PDescriptor)field.toPList()), valueVariable});
                    this.readPortableBinary(field, bebrTemp, valueVariable, (PDescriptor)field.toPList());
                    this.writer.formatln("%s(%s);", new Object[]{field.setter(), valueVariable}).end().println("}");
                    break;
                }
                this.readPortableFieldList(field, field.toPList().itemDescriptor());
                break;
            }
            case SET: {
                if (field.isUnion()) {
                    this.writer.formatln("try ( %s %s = new %s(%s.readByteArray(\"%s\"));", new Object[]{ByteArrayInputStream.class.getName(), baisTemp, ByteArrayInputStream.class.getName(), PORTABLE_READER, field.name()}).formatln("%s %s = new %s(%s) ) {", new Object[]{BigEndianBinaryReader.class.getName(), bebrTemp, BigEndianBinaryReader.class.getName(), baisTemp}).begin().formatln("%s %s;", new Object[]{this.helper.getFieldType((PDescriptor)field.toPSet()), valueVariable});
                    this.readPortableBinary(field, bebrTemp, valueVariable, (PDescriptor)field.toPSet());
                    this.writer.formatln("%s(%s);", new Object[]{field.setter(), valueVariable}).end().println("}");
                    break;
                }
                this.readPortableFieldList(field, field.toPSet().itemDescriptor());
                break;
            }
            case MAP: {
                PMap pMap = field.toPMap();
                String mapSize = this.tempVariable();
                String keyVariable = this.tempVariable();
                this.writer.formatln("try ( %s %s = new %s(%s.readByteArray(\"%s\"));", new Object[]{ByteArrayInputStream.class.getName(), baisTemp, ByteArrayInputStream.class.getName(), PORTABLE_READER, field.name()}).formatln("%s %s = new %s(%s) ) {", new Object[]{BigEndianBinaryReader.class.getName(), bebrTemp, BigEndianBinaryReader.class.getName(), baisTemp}).begin().formatln("%s %s = %s.%s();", new Object[]{Integer.TYPE.getName(), mapSize, bebrTemp, "expectInt"}).formatln("%s %s;", new Object[]{this.helper.getFieldType(pMap.keyDescriptor()), keyVariable}).formatln("%s %s;", new Object[]{this.helper.getFieldType(pMap.itemDescriptor()), valueVariable}).formatln("for( %s %s = 0; %s < %s; %s++) {", new Object[]{Integer.TYPE.getName(), tempIterator, tempIterator, mapSize, tempIterator}).begin();
                this.readPortableBinary(field, bebrTemp, keyVariable, pMap.keyDescriptor());
                this.readPortableBinary(field, bebrTemp, valueVariable, pMap.itemDescriptor());
                this.writer.formatln("%s(%s, %s);", new Object[]{field.adder(), keyVariable, valueVariable}).end().println("}");
                this.writer.end().println("}");
                break;
            }
            case MESSAGE: {
                if (field.isUnion()) {
                    String tempBuilder = this.tempVariable();
                    this.writer.formatln("try ( %s %s = new %s(%s.readByteArray(\"%s\"));", new Object[]{ByteArrayInputStream.class.getName(), baisTemp, ByteArrayInputStream.class.getName(), PORTABLE_READER, field.name()}).formatln("%s %s = new %s(%s) ) {", new Object[]{BigEndianBinaryReader.class.getName(), bebrTemp, BigEndianBinaryReader.class.getName(), baisTemp}).begin().formatln("%s._Builder %s = %s.builder();", new Object[]{this.helper.getFieldType(field.field().getDescriptor()), tempBuilder, this.helper.getFieldType(field.field().getDescriptor())}).formatln("%s.readBinary(%s, false);", new Object[]{tempBuilder, bebrTemp}).formatln("%s(%s.build());", new Object[]{field.setter(), tempBuilder}).end().println("}");
                    break;
                }
                this.writer.formatln("%s(((%s.%s)%s.readPortable(\"%s\")).%s());", new Object[]{field.setter(), field.instanceType(), WRAPPER_CLASS_NAME, PORTABLE_READER, field.name(), "build"});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented readPortableField for type: " + field.type() + " in " + this.getClass().getSimpleName());
            }
        }
        if (!field.alwaysPresent()) {
            this.writer.end().appendln((CharSequence)"}");
        }
    }

    private void readPortableFieldList(JField field, PDescriptor descriptor) throws GeneratorException {
        switch (descriptor.getType()) {
            case BYTE: {
                this.writer.formatln("%s(%s.asList(%s.readByteArray(\"%s\")));", new Object[]{field.setter(), Bytes.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case BINARY: {
                this.writer.formatln("%s(%s.%s(%s.readByteArray(\"%s\")));", new Object[]{field.setter(), BinaryUtil.class.getName(), "toBinaryCollection", PORTABLE_READER, field.name()});
                break;
            }
            case BOOL: {
                this.writer.formatln("%s(%s.asList(%s.readBooleanArray(\"%s\")));", new Object[]{field.setter(), Booleans.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case DOUBLE: {
                this.writer.formatln("%s(%s.asList(%s.readDoubleArray(\"%s\")));", new Object[]{field.setter(), Doubles.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case ENUM: {
                this.writer.formatln("%s(%s.asList(%s.readIntArray(\"%s\")).stream().map(t -> %s.%s(t.intValue())).collect(%s.toList()));", new Object[]{field.setter(), Ints.class.getName(), PORTABLE_READER, field.name(), descriptor.getName(), "findById", Collectors.class.getName()});
                break;
            }
            case I16: {
                this.writer.formatln("%s(%s.asList(%s.readShortArray(\"%s\")));", new Object[]{field.setter(), Shorts.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case I32: {
                this.writer.formatln("%s(%s.asList(%s.readIntArray(\"%s\")));", new Object[]{field.setter(), Ints.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case I64: {
                this.writer.formatln("%s(%s.asList(%s.readLongArray(\"%s\")));", new Object[]{field.setter(), Longs.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case STRING: {
                this.writer.formatln("%s(%s.asList(%s.readUTFArray(\"%s\")));", new Object[]{field.setter(), Arrays.class.getName(), PORTABLE_READER, field.name()});
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s(%s.asList(%s.readPortableArray(\"%s\")).stream().map(i -> ((%s.%s)i).build()).collect(%s.toList()));", new Object[]{field.setter(), Arrays.class.getName(), PORTABLE_READER, field.name(), descriptor.getName(), WRAPPER_CLASS_NAME, Collectors.class.getName()});
                break;
            }
            default: {
                throw new GeneratorException("Not implemented readPortableField for list with type: " + descriptor.getType() + " in " + this.getClass().getSimpleName());
            }
        }
    }
}

