/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Properties;
import javax.annotation.Generated;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PClient;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PProcessor;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallHandler;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JavaMessageFormatter;
import net.morimekta.providence.generator.format.java.JavaOptions;
import net.morimekta.providence.generator.format.java.shared.BaseServiceFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JService;
import net.morimekta.providence.generator.format.java.utils.JServiceMethod;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class JavaServiceFormatter
implements BaseServiceFormatter {
    private final JHelper helper;
    private final JavaMessageFormatter messageFormat;
    private final IndentedPrintWriter writer;
    private final JavaOptions options;
    private final String version;

    JavaServiceFormatter(IndentedPrintWriter writer, JHelper helper, JavaMessageFormatter messageFormat, JavaOptions options) {
        this.writer = writer;
        this.helper = helper;
        this.messageFormat = messageFormat;
        this.options = options;
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/java_generator_version.properties"));
            this.version = properties.getProperty("java_generator_version");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void appendServiceClass(CService cs) throws GeneratorException, IOException {
        JService service = new JService(cs, this.helper);
        if (cs.getDocumentation() != null) {
            new BlockCommentBuilder(this.writer).comment(cs.getDocumentation()).finish();
        }
        String inherits = "";
        if (service.getService().getExtendsService() != null) {
            CService other = service.getService().getExtendsService();
            inherits = "extends " + this.helper.getJavaPackage((PService)other) + "." + new JService(other, this.helper).className() + " ";
        }
        this.writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")");
        if (this.options.generated_annotation_version) {
            this.writer.formatln("@%s(\"providence java generator %s\")", new Object[]{Generated.class.getName(), this.version});
        } else {
            this.writer.formatln("@%s(\"providence java generator\")", new Object[]{Generated.class.getName()});
        }
        this.writer.formatln("public class %s %s{", new Object[]{service.className(), inherits}).begin();
        this.appendIface(this.writer, service);
        this.appendClient(this.writer, service);
        this.appendProcessor(this.writer, service);
        this.appendDescriptor(this.writer, service);
        this.appendStructs(this.writer, service);
        this.writer.formatln("protected %s() {}", new Object[]{service.className()});
        this.writer.end().appendln('}');
    }

    private void appendClient(IndentedPrintWriter writer, JService service) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(writer);
        if (service.getService().getDocumentation() != null) {
            comment.comment(service.getService().getDocumentation()).newline();
        }
        comment.comment("Client implementation for " + service.getService().getQualifiedName()).finish();
        writer.appendln((CharSequence)"public static class Client").formatln("        extends %s", new Object[]{PClient.class.getName()}).formatln("        implements Iface {", new Object[0]).begin();
        writer.formatln("private final %s handler;", new Object[]{PServiceCallHandler.class.getName()}).newline();
        new BlockCommentBuilder(writer).comment("Create " + service.getService().getQualifiedName() + " service client.").newline().param_("handler", "The client handler.").finish();
        writer.formatln("public Client(%s handler) {", new Object[]{PServiceCallHandler.class.getName()}).appendln((CharSequence)"    this.handler = handler;").appendln('}').newline();
        boolean firstMethod = true;
        for (JServiceMethod method : service.methods()) {
            if (firstMethod) {
                firstMethod = false;
            } else {
                writer.newline();
            }
            writer.appendln((CharSequence)"@Override");
            JField ret = method.getResponse();
            writer.appendln((CharSequence)"public ");
            if (ret != null) {
                writer.append((CharSequence)ret.valueType());
            } else {
                writer.append((CharSequence)"void");
            }
            writer.format(" %s(", new Object[]{method.methodName()}).begin("        ");
            boolean first = true;
            for (JField param : method.params()) {
                if (first) {
                    first = false;
                } else {
                    writer.append((CharSequence)",");
                }
                writer.formatln("%s %s", new Object[]{param.valueType(), param.param()});
            }
            writer.end().format(")", new Object[0]).formatln("        throws %s", new Object[]{IOException.class.getName()}).begin("               ");
            for (JField ex : method.exceptions()) {
                writer.append((CharSequence)",");
                writer.appendln((CharSequence)ex.instanceType());
            }
            writer.format(" {", new Object[0]).end().begin();
            writer.formatln("%s._Builder rq = %s.builder();", new Object[]{service.getRequestClassRef(method), service.getRequestClassRef(method)});
            for (JField param : method.params()) {
                writer.formatln("rq.%s(%s);", new Object[]{param.setter(), param.param()});
            }
            String type = method.getMethod().isOneway() ? PServiceCallType.ONEWAY.name() : PServiceCallType.CALL.name();
            writer.newline().formatln("%s call = new %s<>(\"%s\", %s.%s, getNextSequenceId(), rq.build());", new Object[]{PServiceCall.class.getName(), PServiceCall.class.getName(), method.name(), PServiceCallType.class.getName(), type}).appendln();
            if (method.getResponseClass() != null) {
                writer.format("%s resp = ", new Object[]{PServiceCall.class.getName()});
            }
            writer.format("handler.handleCall(call, %s.kDescriptor);", new Object[]{service.className()});
            if (method.getResponseClass() != null) {
                writer.newline().formatln("if (resp.getType() == %s.%s) {", new Object[]{PServiceCallType.class.getName(), PServiceCallType.EXCEPTION.name()}).formatln("    throw (%s) resp.getMessage();", new Object[]{PApplicationException.class.getName()}).appendln('}').newline().formatln("%s msg = (%s) resp.getMessage();", new Object[]{service.getResponseClassRef(method), service.getResponseClassRef(method)});
                writer.appendln((CharSequence)"if (msg.unionField() != null) {").begin().appendln((CharSequence)"switch (msg.unionField()) {").begin();
                if (method.exceptions().length > 0) {
                    for (JField ex : method.exceptions()) {
                        writer.formatln("case %s:", new Object[]{ex.fieldEnum()}).formatln("    throw msg.%s();", new Object[]{ex.getter()});
                    }
                }
                if (method.getResponse() != null) {
                    writer.formatln("case %s:", new Object[]{method.getResponse().fieldEnum()});
                    if (method.getResponse().isVoid()) {
                        writer.formatln("    return;", new Object[0]);
                    } else {
                        writer.formatln("    return msg.%s();", new Object[]{method.getResponse().getter()});
                    }
                }
                writer.end().appendln((CharSequence)"}").end().appendln((CharSequence)"}").newline();
                writer.formatln("throw new %s(\"Result field for %s.%s() not set\",", new Object[]{PApplicationException.class.getName(), service.getService().getQualifiedName(), method.name()}).formatln("          %s %s.%s);", new Object[]{PApplicationException.class.getName().replaceAll(".", " "), PApplicationExceptionType.class.getName(), PApplicationExceptionType.MISSING_RESULT.name()});
            }
            writer.end().appendln('}');
        }
        writer.end().appendln('}').newline();
    }

    private void appendProcessor(IndentedPrintWriter writer, JService service) throws GeneratorException {
        writer.formatln("public static class Processor implements %s {", new Object[]{PProcessor.class.getName()}).begin().appendln((CharSequence)"private final Iface impl;");
        writer.formatln("public Processor(Iface impl) {", new Object[0]).appendln((CharSequence)"    this.impl = impl;").appendln('}').newline();
        writer.appendln((CharSequence)"@Override").formatln("public %s getDescriptor() {", new Object[]{PService.class.getName()}).appendln((CharSequence)"    return kDescriptor;").appendln('}').newline();
        writer.appendln((CharSequence)"@Override").formatln("public <Request extends %s<Request, RequestField>,", new Object[]{PMessage.class.getName()}).formatln("        Response extends %s<Response, ResponseField>,", new Object[]{PMessage.class.getName()}).formatln("        RequestField extends %s,", new Object[]{PField.class.getName()}).formatln("        ResponseField extends %s>", new Object[]{PField.class.getName()}).formatln("%s<Response, ResponseField> handleCall(", new Object[]{PServiceCall.class.getName()}).formatln("        %s<Request, RequestField> call,", new Object[]{PServiceCall.class.getName()}).formatln("        %s service)", new Object[]{PService.class.getName()}).formatln("        throws %s,", new Object[]{IOException.class.getName()}).formatln("               %s {", new Object[]{SerializerException.class.getName()}).begin();
        writer.appendln((CharSequence)"switch(call.getMethod()) {").begin();
        for (JServiceMethod method : service.methods()) {
            String methodThrows;
            writer.formatln("case \"%s\": {", new Object[]{method.name()}).begin();
            if (method.getResponseClass() != null) {
                writer.formatln("%s._Builder rsp = %s.builder();", new Object[]{service.getResponseClassRef(method), service.getResponseClassRef(method)});
            }
            if ((methodThrows = service.methodsThrows(method)) != null || method.exceptions().length > 0) {
                writer.appendln((CharSequence)"try {").begin();
            }
            writer.formatln("%s req = (%s) call.getMessage();", new Object[]{service.getRequestClassRef(method), service.getRequestClassRef(method)});
            String indent = "      " + Strings.times((String)" ", (int)method.methodName().length());
            if (method.getResponse() != null && !method.getResponse().isVoid()) {
                writer.formatln("%s result =", new Object[]{method.getResponse().valueType()});
                writer.appendln((CharSequence)"        ");
                indent = indent + "        ";
            } else {
                writer.appendln();
            }
            writer.format("impl.%s(", new Object[]{method.methodName()}).begin(indent);
            boolean first = true;
            for (JField param : method.params()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(',').appendln();
                }
                writer.format("req.%s()", new Object[]{param.getter()});
            }
            writer.end().append((CharSequence)");");
            if (method.getResponse() != null) {
                if (method.getResponse().isVoid()) {
                    writer.formatln("rsp.%s();", new Object[]{method.getResponse().setter()});
                } else {
                    writer.formatln("rsp.%s(result);", new Object[]{method.getResponse().setter()});
                }
            }
            if (methodThrows != null || method.exceptions().length > 0) {
                writer.end();
                for (JField ex : method.exceptions()) {
                    writer.formatln("} catch (%s e) {", new Object[]{ex.instanceType()}).formatln("    rsp.%s(e);", new Object[]{ex.setter()});
                }
                if (methodThrows != null) {
                    writer.formatln("} catch (%s e) {", new Object[]{methodThrows}).formatln("    throw new %s(e.getMessage(), e);", new Object[]{IOException.class.getName()});
                }
                writer.appendln('}');
            }
            if (method.getResponseClass() != null) {
                String spaces = PServiceCall.class.getName().replaceAll("[\\S]", " ");
                writer.formatln("%s reply =", new Object[]{PServiceCall.class.getName()}).formatln("        new %s<>(call.getMethod(),", new Object[]{PServiceCall.class.getName()}).formatln("            %s   %s.%s,", new Object[]{spaces, PServiceCallType.class.getName(), PServiceCallType.REPLY.name()}).formatln("            %s   call.getSequence(),", new Object[]{spaces}).formatln("            %s   rsp.build());", new Object[]{spaces}).appendln((CharSequence)"return reply;");
            } else {
                writer.appendln((CharSequence)"return null;");
            }
            writer.end().appendln('}');
        }
        writer.appendln((CharSequence)"default: {").begin().formatln("%s ex =", new Object[]{PApplicationException.class.getName()}).formatln("        new %s(", new Object[]{PApplicationException.class.getName()}).formatln("                \"Unknown method \\\"\" + call.getMethod() + \"\\\" on %s.\",", new Object[]{service.getService().getQualifiedName()}).formatln("                %s.%s);", new Object[]{PApplicationExceptionType.class.getName(), PApplicationExceptionType.UNKNOWN_METHOD.asString()});
        String spaces = PServiceCall.class.getName().replaceAll("[\\S]", " ");
        writer.formatln("%s reply =", new Object[]{PServiceCall.class.getName()}).formatln("        new %s(call.getMethod(),", new Object[]{PServiceCall.class.getName()}).formatln("            %s %s.%s,", new Object[]{spaces, PServiceCallType.class.getName(), PServiceCallType.EXCEPTION.name()}).formatln("            %s call.getSequence(),", new Object[]{spaces}).formatln("            %s ex);", new Object[]{spaces}).appendln((CharSequence)"return reply;");
        writer.end().appendln('}').end().appendln('}');
        writer.end().appendln('}');
        writer.end().appendln('}').newline();
    }

    private void appendDescriptor(IndentedPrintWriter writer, JService service) throws GeneratorException {
        writer.formatln("public enum Method implements %s {", new Object[]{PServiceMethod.class.getName()}).begin();
        for (JServiceMethod method : service.methods()) {
            String responseDesc = method.getResponseClass() == null ? "null" : service.getResponseClassRef(method) + ".kDescriptor";
            writer.formatln("%s(\"%s\", %b, %s.kDescriptor, %s),", new Object[]{method.constant(), method.name(), method.getMethod().isOneway(), service.getRequestClassRef(method), responseDesc});
        }
        writer.appendln(';').newline();
        writer.appendln((CharSequence)"private final String name;").appendln((CharSequence)"private final boolean oneway;").formatln("private final %s request;", new Object[]{PStructDescriptor.class.getName()}).formatln("private final %s response;", new Object[]{PUnionDescriptor.class.getName()}).newline();
        writer.formatln("private Method(String name, boolean oneway, %s request, %s response) {", new Object[]{PStructDescriptor.class.getName(), PUnionDescriptor.class.getName()}).appendln((CharSequence)"    this.name = name;").appendln((CharSequence)"    this.oneway = oneway;").appendln((CharSequence)"    this.request = request;").appendln((CharSequence)"    this.response = response;").appendln('}').newline();
        writer.appendln((CharSequence)"public String getName() {").appendln((CharSequence)"    return name;").appendln('}').newline().appendln((CharSequence)"public boolean isOneway() {").appendln((CharSequence)"    return oneway;").appendln('}').newline().formatln("public %s getRequestType() {", new Object[]{PStructDescriptor.class.getName()}).formatln("    return request;", new Object[0]).appendln('}').newline().formatln("public %s getResponseType() {", new Object[]{PUnionDescriptor.class.getName()}).formatln("    return response;", new Object[0]).appendln('}').newline();
        writer.appendln((CharSequence)"public static Method findByName(String name) {").begin().appendln((CharSequence)"switch (name) {").begin();
        for (JServiceMethod method : service.methods()) {
            writer.formatln("case \"%s\": return %s;", new Object[]{method.name(), method.constant()});
        }
        writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}');
        writer.appendln((CharSequence)"@javax.annotation.Nonnull").appendln((CharSequence)"public static Method methodForName(String name) {").begin().appendln((CharSequence)"Method method = findByName(name);").appendln((CharSequence)"if (method == null) {").formatln("    throw new IllegalArgumentException(\"No such method \\\"\" + name + \"\\\" in service %s\");", new Object[]{service.getService().getQualifiedName()}).appendln((CharSequence)"}").appendln((CharSequence)"return method;").end().appendln('}');
        writer.end().appendln('}').newline();
        String inherits = "null";
        if (service.getService().getExtendsService() != null) {
            CService other = service.getService().getExtendsService();
            inherits = this.helper.getJavaPackage((PService)other) + "." + new JService(other, this.helper).className() + ".provider()";
        }
        writer.formatln("private static class _Descriptor extends %s {", new Object[]{PService.class.getName()}).begin().appendln((CharSequence)"private _Descriptor() {").formatln("    super(\"%s\", \"%s\", %s, Method.values());", new Object[]{service.getService().getProgramName(), service.getService().getName(), inherits}).appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"public Method getMethod(String name) {").appendln((CharSequence)"    return Method.findByName(name);").appendln((CharSequence)"}").end().appendln('}').newline();
        writer.formatln("private static class _Provider implements %s {", new Object[]{PServiceProvider.class.getName()}).begin().appendln((CharSequence)"@Override").formatln("public %s getService() {", new Object[]{PService.class.getName()}).appendln((CharSequence)"    return kDescriptor;").appendln((CharSequence)"}").end().appendln('}').newline();
        writer.formatln("public static final %s kDescriptor = new _Descriptor();", new Object[]{PService.class.getName()}).newline();
        writer.formatln("public static %s provider() {", new Object[]{PServiceProvider.class.getName()}).appendln((CharSequence)"    return new _Provider();").appendln('}').newline();
    }

    private void appendStructs(IndentedPrintWriter writer, JService service) throws GeneratorException, IOException {
        for (JServiceMethod method : service.declaredMethods()) {
            JMessage request = new JMessage(method.getMethod().getRequestType(), this.helper);
            writer.formatln("// type --> %s", new Object[]{request.descriptor().getName()});
            this.messageFormat.appendMessageClass((PMessageDescriptor<?, ?>)method.getMethod().getRequestType());
            if (method.getMethod().getResponseType() == null) continue;
            JMessage response = new JMessage(method.getMethod().getResponseType(), this.helper);
            writer.formatln("// type <-- %s", new Object[]{response.descriptor().getName()});
            this.messageFormat.appendMessageClass((PMessageDescriptor<?, ?>)method.getMethod().getResponseType());
        }
    }

    private void appendIface(IndentedPrintWriter writer, JService service) throws GeneratorException {
        String inherits = "";
        if (service.getService().getExtendsService() != null) {
            CService other = service.getService().getExtendsService();
            inherits = "extends " + this.helper.getJavaPackage((PService)other) + "." + new JService(other, this.helper).className() + ".Iface ";
        }
        if (service.getService().getDocumentation() != null) {
            new BlockCommentBuilder(writer).comment(service.getService().getDocumentation()).finish();
        }
        writer.formatln("public interface Iface %s{", new Object[]{inherits}).begin();
        boolean firstMethod = true;
        for (JServiceMethod method : service.declaredMethods()) {
            if (firstMethod) {
                firstMethod = false;
            } else {
                writer.newline();
            }
            String methodThrows = service.methodsThrows(method);
            BlockCommentBuilder comment = new BlockCommentBuilder(writer);
            if (method.getMethod().getDocumentation() != null) {
                comment.comment(method.getMethod().getDocumentation()).newline();
            }
            for (JField param : method.params()) {
                if (param.comment() != null) {
                    comment.param_(param.param(), param.comment());
                    continue;
                }
                comment.param_(param.param(), "The " + param.name() + " value.");
            }
            if (method.getResponse() != null && !method.getResponse().isVoid()) {
                comment.return_("The " + method.name() + " result.");
            }
            if (methodThrows != null) {
                comment.throws_(methodThrows, "On any declared exception.");
            } else {
                for (JField param : method.exceptions()) {
                    if (param.comment() != null) {
                        comment.throws_(param.fieldType(), param.comment());
                        continue;
                    }
                    comment.throws_(param.fieldType(), "The " + param.name() + " exception.");
                }
            }
            comment.throws_(IOException.class, "On providence or non-declared exceptions.").finish();
            JField ret = method.getResponse();
            if (ret != null) {
                writer.appendln((CharSequence)ret.valueType());
            } else {
                writer.appendln((CharSequence)"void");
            }
            writer.format(" %s(", new Object[]{method.methodName()}).begin("        ");
            boolean first = true;
            for (JField param : method.params()) {
                if (first) {
                    first = false;
                } else {
                    writer.append((CharSequence)",");
                }
                writer.formatln("%s %s", new Object[]{param.valueType(), param.param()});
            }
            writer.end().format(")", new Object[0]);
            writer.formatln("        throws %s", new Object[]{IOException.class.getName()}).begin("               ");
            if (methodThrows != null) {
                writer.append((CharSequence)",");
                writer.formatln("%s", new Object[]{methodThrows});
            } else {
                for (JField ex : method.exceptions()) {
                    writer.append((CharSequence)",");
                    writer.appendln((CharSequence)ex.instanceType());
                }
            }
            writer.format(";", new Object[0]).end();
        }
        writer.end().appendln('}').newline();
    }
}

