/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages;

import java.util.Collections;
import java.util.Optional;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.ContainerType;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.generator.format.java.utils.ValueBuilder;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class CommonMemberFormatter
implements MessageMemberFormatter {
    protected final IndentedPrintWriter writer;
    private final JHelper helper;

    public CommonMemberFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    @Override
    public void appendClassAnnotations(JMessage<?> message) throws GeneratorException {
        this.writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")");
    }

    @Override
    public void appendConstants(JMessage<?> message) throws GeneratorException {
        this.writer.formatln("private final static long serialVersionUID = %dL;", new Object[]{JUtils.generateSerialVersionUID(message.descriptor())}).newline();
        this.appendFieldDefaultValues(message);
    }

    @Override
    public void appendFields(JMessage<?> message) throws GeneratorException {
        this.appendFieldDeclarations(message);
    }

    @Override
    public void appendConstructors(JMessage<?> message) throws GeneratorException {
        this.appendCreateConstructor(message);
    }

    @Override
    public void appendMethods(JMessage<?> message) throws GeneratorException {
        this.appendFieldGetters(message);
        if (message.isException()) {
            this.appendCreateMessage(message);
        }
    }

    private void appendFieldDefaultValues(JMessage<?> message) throws GeneratorException {
        ValueBuilder values = new ValueBuilder(this.writer, this.helper);
        values.appendDefaultConstants(message.declaredOrderFields());
    }

    private void appendFieldGetters(JMessage<?> message) throws GeneratorException {
        for (JField field : message.declaredOrderFields()) {
            if (message.isUnion()) {
                if (field.container()) {
                    this.writer.formatln("public int %s() {", new Object[]{field.counter()}).formatln("    return %s == _Field.%s ? %s.size() : 0;", new Object[]{"tUnionField", field.fieldEnum(), field.member()}).appendln('}').newline();
                }
                if (field.alwaysPresent() || field.isVoid()) {
                    this.writer.formatln("public boolean %s() {", new Object[]{field.presence()}).formatln("    return %s == _Field.%s;", new Object[]{"tUnionField", field.fieldEnum()}).appendln('}').newline();
                } else {
                    this.writer.formatln("public boolean %s() {", new Object[]{field.presence()}).formatln("    return %s == _Field.%s && %s != null;", new Object[]{"tUnionField", field.fieldEnum(), field.member()}).appendln('}').newline();
                }
            } else {
                if (field.container()) {
                    this.writer.formatln("public int %s() {", new Object[]{field.counter()}).formatln("    return %s != null ? %s.size() : 0;", new Object[]{field.member(), field.member()}).appendln('}').newline();
                }
                if (field.alwaysPresent()) {
                    this.writer.formatln("public boolean %s() {", new Object[]{field.presence()}).begin().formatln("return true;", new Object[0]).end().appendln('}').newline();
                } else {
                    this.writer.formatln("public boolean %s() {", new Object[]{field.presence()}).begin().formatln("return %s != null;", new Object[]{field.member()}).end().appendln('}').newline();
                }
            }
            if (field.isVoid()) continue;
            BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
            if (field.hasComment()) {
                comment.comment(field.comment()).newline();
            }
            comment.return_("The field value").finish();
            if (JAnnotation.isDeprecated(field)) {
                this.writer.appendln((CharSequence)"@Deprecated");
            }
            this.writer.formatln("public %s %s() {", new Object[]{field.valueType(), field.getter()});
            if (field.isPrimitiveJavaValue() && !field.alwaysPresent() || !field.container() && !field.alwaysPresent() && field.getPField().hasDefaultValue()) {
                this.writer.formatln("    return %s() ? %s : %s;", new Object[]{field.presence(), field.member(), field.kDefault()});
            } else {
                this.writer.formatln("    return %s;", new Object[]{field.member()});
            }
            this.writer.appendln('}').newline();
        }
    }

    private void appendFieldDeclarations(JMessage<?> message) throws GeneratorException {
        for (JField field : message.declaredOrderFields()) {
            if (field.isVoid()) continue;
            this.writer.formatln("private final %s %s;", new Object[]{field.fieldType(), field.member()});
        }
        this.writer.newline();
    }

    private void appendCreateMessage(JMessage<?> message) throws GeneratorException {
        if (message.exceptionMessageField().isPresent()) {
            return;
        }
        this.writer.appendln((CharSequence)"private static String createMessage(").begin("                                    ");
        boolean first = true;
        for (JField fld : message.declaredOrderFields()) {
            if (fld.isVoid()) continue;
            if (first) {
                first = false;
            } else {
                this.writer.append(',').appendln();
            }
            this.writer.format("%s %s", new Object[]{fld.fieldType(), fld.param()});
        }
        this.writer.append((CharSequence)") {").end().begin().appendln((CharSequence)"StringBuilder out = new StringBuilder();").appendln((CharSequence)"out.append('{');");
        boolean firstFirstCheck = true;
        boolean alwaysAfter = false;
        int i = 0;
        int lastPos = message.declaredOrderFields().size() - 1;
        for (JField field : message.declaredOrderFields()) {
            if (field.isVoid()) {
                --lastPos;
                continue;
            }
            boolean last = i == lastPos;
            first = i == 0;
            ++i;
            if (!field.alwaysPresent()) {
                if (!alwaysAfter && firstFirstCheck && !last) {
                    this.writer.appendln((CharSequence)"boolean first = true;");
                }
                if (field.container()) {
                    this.writer.formatln("if (%s != null && %s.size() > 0) {", new Object[]{field.param(), field.param()});
                } else {
                    this.writer.formatln("if (%s != null) {", new Object[]{field.param()});
                }
                this.writer.begin();
            }
            if (alwaysAfter) {
                this.writer.appendln((CharSequence)"out.append(',');");
            } else if (!field.alwaysPresent()) {
                if (firstFirstCheck || first) {
                    if (!last) {
                        this.writer.appendln((CharSequence)"first = false;");
                    }
                } else if (last) {
                    this.writer.appendln((CharSequence)"if (!first) out.append(',');");
                } else {
                    this.writer.appendln((CharSequence)"if (first) first = false;").appendln((CharSequence)"else out.append(',');");
                }
            }
            this.writer.formatln("out.append(\"%s:\")", new Object[]{field.name()});
            switch (field.type()) {
                case BOOL: 
                case I32: 
                case I64: {
                    this.writer.formatln("   .append(%s);", new Object[]{field.param()});
                    break;
                }
                case BYTE: 
                case I16: {
                    this.writer.formatln("   .append((int) %s);", new Object[]{field.param()});
                    break;
                }
                case DOUBLE: 
                case MAP: 
                case SET: 
                case LIST: {
                    this.writer.formatln("   .append(%s.asString(%s));", new Object[]{Strings.class.getName(), field.param()});
                    break;
                }
                case STRING: {
                    this.writer.formatln("   .append('\\\"')", new Object[0]).formatln("   .append(%s.escape(%s))", new Object[]{Strings.class.getName(), field.param()}).appendln((CharSequence)"   .append('\\\"');");
                    break;
                }
                case BINARY: {
                    this.writer.appendln((CharSequence)"   .append(\"b64(\")").formatln("   .append(%s.toBase64())", new Object[]{field.param()}).appendln((CharSequence)"   .append(')');");
                    break;
                }
                case MESSAGE: {
                    this.writer.formatln("   .append(%s.asString());", new Object[]{field.param()});
                    break;
                }
                default: {
                    this.writer.formatln("   .append(%s.toString());", new Object[]{field.param()});
                }
            }
            if (!field.alwaysPresent()) {
                this.writer.end().appendln('}');
                if (alwaysAfter || !firstFirstCheck) continue;
                firstFirstCheck = false;
                continue;
            }
            alwaysAfter = true;
        }
        this.writer.appendln((CharSequence)"out.append('}');").appendln((CharSequence)"return out.toString();").end().appendln('}').newline();
    }

    private void appendCreateConstructor(JMessage<?> message) throws GeneratorException {
        if (message.isUnion()) {
            for (JField field : message.declaredOrderFields()) {
                BlockCommentBuilder block = new BlockCommentBuilder(this.writer);
                if (field.hasComment()) {
                    block.comment(field.comment());
                }
                if (field.isVoid()) {
                    block.return_("The created union.").finish();
                    this.writer.formatln("public static %s %s() {", new Object[]{message.instanceType(), JUtils.camelCase("with", field.name())}).begin().formatln("return new _Builder().%s().build();", new Object[]{field.setter()}).end().appendln('}').newline();
                    continue;
                }
                block.param_("value", "The union value").return_("The created union.").finish();
                this.writer.formatln("public static %s %s(%s value) {", new Object[]{message.instanceType(), JUtils.camelCase("with", field.name()), field.valueType()}).begin().formatln("return new _Builder().%s(value).build();", new Object[]{field.setter()}).end().appendln('}').newline();
            }
        } else {
            String spaces = message.instanceType().replaceAll("[\\S]", " ");
            this.writer.formatln("public %s(", new Object[]{message.instanceType()}).begin("        " + spaces);
            boolean first = true;
            for (JField jField : message.declaredOrderFields()) {
                if (jField.isVoid()) continue;
                if (first) {
                    first = false;
                } else {
                    this.writer.append(',').appendln();
                }
                this.writer.format("%s %s", new Object[]{jField.paramType(), jField.param()});
            }
            this.writer.end().append((CharSequence)") {").begin();
            if (message.isException()) {
                Optional<JField> msg = message.exceptionMessageField();
                if (msg.isPresent()) {
                    this.writer.formatln("super(%s);", new Object[]{msg.get().param()}).newline();
                } else {
                    this.writer.appendln((CharSequence)"super(createMessage(").begin("                    ");
                    first = true;
                    for (JField field : message.declaredOrderFields()) {
                        if (field.isVoid()) continue;
                        if (first) {
                            first = false;
                        } else {
                            this.writer.append(',').appendln();
                        }
                        this.writer.format("%s", new Object[]{field.param()});
                    }
                    this.writer.append((CharSequence)"));").end().newline();
                }
            }
            block8: for (JField jField : message.declaredOrderFields()) {
                if (jField.isVoid()) continue;
                switch (jField.type()) {
                    case LIST: {
                        this.writer.formatln("if (%s != null) {", new Object[]{jField.param()}).formatln("    %s = %s.copyOf(%s);", new Object[]{jField.member(), jField.fieldInstanceType(), jField.param()}).appendln((CharSequence)"} else {").formatln("    %s = null;", new Object[]{jField.member()}).appendln('}');
                        continue block8;
                    }
                    case SET: {
                        this.writer.formatln("if (%s != null) {", new Object[]{jField.param()}).begin();
                        if (jField.containerType() == ContainerType.ORDERED) {
                            this.writer.formatln("%s = %s.unmodifiableSet(%s);", new Object[]{jField.member(), Collections.class.getName(), jField.param()});
                        } else {
                            this.writer.formatln("%s = %s.copyOf(%s);", new Object[]{jField.member(), jField.fieldInstanceType(), jField.param()});
                        }
                        this.writer.end().appendln((CharSequence)"} else {").formatln("    %s = null;", new Object[]{jField.member()}).appendln('}');
                        continue block8;
                    }
                    case MAP: {
                        this.writer.formatln("if (%s != null) {", new Object[]{jField.param()}).begin();
                        if (jField.containerType() == ContainerType.ORDERED) {
                            this.writer.formatln("%s = %s.unmodifiableMap(%s);", new Object[]{jField.member(), Collections.class.getName(), jField.param()});
                        } else {
                            this.writer.formatln("%s = %s.copyOf(%s);", new Object[]{jField.member(), jField.fieldInstanceType(), jField.param()});
                        }
                        this.writer.end().appendln((CharSequence)"} else {").formatln("    %s = null;", new Object[]{jField.member()}).appendln('}');
                        continue block8;
                    }
                }
                if (jField.alwaysPresent() && !jField.isRequired()) {
                    this.writer.formatln("if (%s != null) {", new Object[]{jField.param()}).formatln("    %s = %s;", new Object[]{jField.member(), jField.param()}).appendln((CharSequence)"} else {").formatln("    %s = %s;", new Object[]{jField.member(), jField.kDefault()}).appendln('}');
                    continue;
                }
                this.writer.formatln("%s = %s;", new Object[]{jField.member(), jField.param()});
            }
            this.writer.end().appendln('}').newline();
        }
    }
}

