/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.BaseProgramFormatter;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.ValueBuilder;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.util.io.IndentedPrintWriter;

public class JavaConstantsFormatter
implements BaseProgramFormatter {
    private static final String DBL_INDENT = "        ";
    private final JHelper helper;
    private final IndentedPrintWriter writer;

    public JavaConstantsFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    @Override
    public void appendProgramClass(CProgram document) throws GeneratorException {
        ValueBuilder value = new ValueBuilder(this.writer, this.helper);
        if (document.getComment() != null) {
            new BlockCommentBuilder(this.writer).comment(document.getComment()).finish();
        }
        this.writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")").formatln("public class %s {", new Object[]{this.helper.getConstantsClassName(document)}).begin().formatln("private %s() {}", new Object[]{this.helper.getConstantsClassName(document)});
        for (CField c : document.getConstants()) {
            this.writer.newline();
            try {
                String name = c.getName();
                this.writer.formatln("public static final %s %s;", new Object[]{this.helper.getValueType(c.getDescriptor()), name}).appendln((CharSequence)"static {").begin().formatln("%s = ", new Object[]{name}).begin();
                value.appendTypedValue(c.getDefaultValue(), c.getDescriptor());
                this.writer.append(';').end().end().appendln('}');
            }
            catch (Exception e) {
                throw new GeneratorException("Unable to generate constant " + document.getProgramName() + "." + c.getName(), (Throwable)e);
            }
        }
        this.writer.end().appendln('}');
    }
}

