/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.messages;

import java.util.LinkedList;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.shared.MessageMemberFormatter;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class BuilderCoreOverridesFormatter
implements MessageMemberFormatter {
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public BuilderCoreOverridesFormatter(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    @Override
    public void appendConstructors(JMessage<?> message) throws GeneratorException {
        this.appendMerge(message);
    }

    @Override
    public void appendMethods(JMessage<?> message) throws GeneratorException {
        this.appendOverrideMutator(message);
        this.appendOverrideSetter(message);
        this.appendOverrideIsSet(message);
        this.appendOverrideIsModified(message);
        this.appendOverrideAdder(message);
        this.appendOverrideResetter(message);
        this.appendOverrideIsValid(message);
        this.appendOverrideValidate(message);
        this.appendOverrideDescriptor(message);
    }

    private void appendMerge(JMessage<?> message) throws GeneratorException {
        this.writer.appendln((CharSequence)"@Override").formatln("public _Builder merge(%s from) {", new Object[]{message.instanceType()}).begin();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"if (from.unionField() == null) {").appendln((CharSequence)"    return this;").appendln((CharSequence)"}").newline().appendln((CharSequence)"switch (from.unionField()) {").begin();
            for (JField field : message.declaredOrderFields()) {
                this.writer.formatln("case %s: {", new Object[]{field.fieldEnum()}).begin();
                switch (field.type()) {
                    case VOID: {
                        this.writer.formatln("%s = _Field.%s;", new Object[]{"tUnionField", field.fieldEnum()});
                        break;
                    }
                    case MESSAGE: {
                        this.writer.formatln("if (%s == _Field.%s && %s != null) {", new Object[]{"tUnionField", field.fieldEnum(), field.member()}).formatln("    %s = %s.mutate().merge(from.%s()).build();", new Object[]{field.member(), field.member(), field.getter()}).appendln((CharSequence)"} else {").formatln("    %s(from.%s());", new Object[]{field.setter(), field.getter()}).appendln('}');
                        break;
                    }
                    case SET: {
                        this.writer.formatln("if (%s == _Field.%s) {", new Object[]{"tUnionField", field.fieldEnum()}).formatln("    %s.addAll(from.%s()):", new Object[]{field.member(), field.getter()}).appendln((CharSequence)"} else {").formatln("    %s(from.%s());", new Object[]{field.setter(), field.getter()}).appendln('}');
                        break;
                    }
                    case MAP: {
                        this.writer.formatln("if (%s == _Field.%s) {", new Object[]{"tUnionField", field.fieldEnum()}).formatln("    %s.putAll(from.%s()):", new Object[]{field.member(), field.getter()}).appendln((CharSequence)"} else {").formatln("    %s(from.%s());", new Object[]{field.setter(), field.getter()}).appendln('}');
                        break;
                    }
                    default: {
                        this.writer.formatln("%s(from.%s());", new Object[]{field.setter(), field.getter()});
                    }
                }
                this.writer.appendln((CharSequence)"break;").end().appendln('}');
            }
            this.writer.end().appendln('}');
        } else {
            boolean first = true;
            for (JField field : message.declaredOrderFields()) {
                if (first) {
                    first = false;
                } else {
                    this.writer.newline();
                }
                if (!field.alwaysPresent()) {
                    this.writer.formatln("if (from.%s()) {", new Object[]{field.presence()}).begin();
                }
                this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
                this.writer.formatln("modified.set(%d);", new Object[]{field.index()});
                switch (field.type()) {
                    case MESSAGE: {
                        this.writer.formatln("if (%s_builder != null) {", new Object[]{field.member()}).formatln("    %s_builder.merge(from.%s());", new Object[]{field.member(), field.getter()}).formatln("} else if (%s != null) {", new Object[]{field.member()}).formatln("    %s_builder = %s.mutate().merge(from.%s());", new Object[]{field.member(), field.member(), field.getter()}).formatln("    %s = null;", new Object[]{field.member()}).appendln((CharSequence)"} else {").formatln("    %s = from.%s();", new Object[]{field.member(), field.getter()}).appendln('}');
                        break;
                    }
                    case SET: {
                        this.writer.formatln("%s.addAll(from.%s());", new Object[]{field.member(), field.getter()});
                        break;
                    }
                    case MAP: {
                        this.writer.formatln("%s.putAll(from.%s());", new Object[]{field.member(), field.getter()});
                        break;
                    }
                    case LIST: {
                        this.writer.formatln("%s.clear();", new Object[]{field.member()});
                        this.writer.formatln("%s.addAll(from.%s());", new Object[]{field.member(), field.getter()});
                        break;
                    }
                    default: {
                        this.writer.formatln("%s = from.%s();", new Object[]{field.member(), field.getter()});
                    }
                }
                if (field.alwaysPresent()) continue;
                this.writer.end().appendln('}');
            }
        }
        this.writer.appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendOverrideMutator(JMessage<?> message) throws GeneratorException {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"@SuppressWarnings(\"unchecked\")").formatln("public %s mutator(int key) {", new Object[]{PMessageBuilder.class.getName()}).begin().appendln((CharSequence)"switch (key) {").begin();
        message.numericalOrderFields().stream().filter(field -> field.type() == PType.MESSAGE).forEachOrdered(field -> this.writer.formatln("case %d: return %s();", new Object[]{field.id(), Strings.camelCase((String)"mutable", (String)field.name())}));
        this.writer.appendln((CharSequence)"default: throw new IllegalArgumentException(\"Not a message field ID: \" + key);").end().appendln('}').end().appendln('}').newline();
    }

    private void appendOverrideSetter(JMessage<?> message) throws GeneratorException {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"@SuppressWarnings(\"unchecked\")").appendln((CharSequence)"public _Builder set(int key, Object value) {").begin().appendln((CharSequence)"if (value == null) return clear(key);").appendln((CharSequence)"switch (key) {").begin();
        for (JField field : message.numericalOrderFields()) {
            if (field.isVoid()) {
                this.writer.formatln("case %d: %s(); break;", new Object[]{field.id(), field.setter(), field.valueType()});
                continue;
            }
            this.writer.formatln("case %d: %s((%s) value); break;", new Object[]{field.id(), field.setter(), field.valueType()});
        }
        this.writer.appendln((CharSequence)"default: break;").end().appendln('}').appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendOverrideIsSet(JMessage<?> message) throws GeneratorException {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean isSet(int key) {").begin().appendln((CharSequence)"switch (key) {").begin();
        if (message.isUnion()) {
            for (JField field : message.numericalOrderFields()) {
                this.writer.formatln("case %d: return %s == _Field.%s;", new Object[]{field.id(), "tUnionField", field.fieldEnum()});
            }
        } else {
            for (JField field : message.numericalOrderFields()) {
                this.writer.formatln("case %d: return optionals.get(%d);", new Object[]{field.id(), field.index()});
            }
        }
        this.writer.appendln((CharSequence)"default: break;").end().appendln('}').appendln((CharSequence)"return false;").end().appendln('}').newline();
    }

    private void appendOverrideIsModified(JMessage<?> message) throws GeneratorException {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean isModified(int key) {").begin();
        if (!message.isUnion()) {
            this.writer.appendln((CharSequence)"switch (key) {").begin();
            for (JField field : message.numericalOrderFields()) {
                this.writer.formatln("case %d: return modified.get(%d);", new Object[]{field.id(), field.index()});
            }
            this.writer.appendln((CharSequence)"default: break;").end().appendln('}').appendln((CharSequence)"return false;");
        } else {
            this.writer.appendln((CharSequence)"return modified;");
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendOverrideAdder(JMessage<?> message) throws GeneratorException {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder addTo(int key, Object value) {").begin().appendln((CharSequence)"switch (key) {").begin();
        message.numericalOrderFields().stream().filter(field -> field.type() == PType.LIST || field.type() == PType.SET).forEachOrdered(field -> {
            PContainer ct = (PContainer)field.getPField().getDescriptor();
            PDescriptor itype = ct.itemDescriptor();
            this.writer.formatln("case %d: %s((%s) value); break;", new Object[]{field.id(), field.adder(), this.helper.getValueType(itype)});
        });
        this.writer.appendln((CharSequence)"default: break;").end().appendln('}').appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendOverrideResetter(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder clear(int key) {").begin().appendln((CharSequence)"switch (key) {").begin();
        for (JField field : message.numericalOrderFields()) {
            this.writer.formatln("case %d: %s(); break;", new Object[]{field.id(), field.resetter()});
        }
        this.writer.appendln((CharSequence)"default: break;").end().appendln('}').appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendOverrideIsValid(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean valid() {").begin();
        if (message.isUnion()) {
            this.writer.formatln("if (%s == null) {", new Object[]{"tUnionField"}).appendln((CharSequence)"    return false;").appendln('}').newline().formatln("switch (%s) {", new Object[]{"tUnionField"}).begin();
            message.numericalOrderFields().stream().filter(field -> !field.alwaysPresent()).forEachOrdered(field -> {
                if (field.isVoid()) {
                    this.writer.formatln("case %s: return true;", new Object[]{field.fieldEnum()});
                } else if (field.type() == PType.MESSAGE) {
                    this.writer.formatln("case %s: return %s != null || %s_builder != null;", new Object[]{field.fieldEnum(), field.member(), field.member()});
                } else {
                    this.writer.formatln("case %s: return %s != null;", new Object[]{field.fieldEnum(), field.member()});
                }
            });
            this.writer.appendln((CharSequence)"default: return true;").end().appendln('}');
        } else {
            this.writer.appendln((CharSequence)"return ").begin("       ");
            boolean first = true;
            for (JField field2 : message.declaredOrderFields()) {
                if (!field2.isRequired()) continue;
                if (first) {
                    first = false;
                } else {
                    this.writer.append((CharSequence)" &&").appendln((CharSequence)"");
                }
                this.writer.format("optionals.get(%d)", new Object[]{field2.index()});
            }
            if (first) {
                this.writer.append((CharSequence)"true");
            }
            this.writer.end().append(';');
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendOverrideValidate(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public void validate() {").begin();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"if (!valid()) {").formatln("    throw new %s(\"No union field set in %s\");", new Object[]{IllegalStateException.class.getName(), message.descriptor().getQualifiedName()}).appendln((CharSequence)"}");
        } else {
            boolean hasRequired = message.declaredOrderFields().stream().anyMatch(JField::isRequired);
            if (hasRequired) {
                this.writer.appendln((CharSequence)"if (!valid()) {").begin().formatln("%s<String> missing = new %s<>();", new Object[]{LinkedList.class.getName(), LinkedList.class.getName()}).newline();
                message.declaredOrderFields().stream().filter(JField::isRequired).forEachOrdered(field -> this.writer.formatln("if (!optionals.get(%d)) {", new Object[]{field.index()}).formatln("    missing.add(\"%s\");", new Object[]{field.name()}).appendln((CharSequence)"}").newline());
                this.writer.formatln("throw new %s(", new Object[]{IllegalStateException.class.getName()}).appendln((CharSequence)"        \"Missing required fields \" +").appendln((CharSequence)"        String.join(\",\", missing) +").formatln("        \" in message %s\");", new Object[]{message.descriptor().getQualifiedName()}).end().appendln((CharSequence)"}");
            }
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendOverrideDescriptor(JMessage<?> message) throws GeneratorException {
        String typeClass = message.getDescriptorClass();
        this.writer.appendln((CharSequence)"@Override").formatln("public %s<%s,_Field> descriptor() {", new Object[]{typeClass, message.instanceType()}).begin().appendln((CharSequence)"return kDescriptor;").end().appendln('}').newline();
    }
}

